/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AssignmentsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class LmsListAssignmentsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AssignmentsPaginated> assignmentsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public LmsListAssignmentsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AssignmentsPaginated> assignmentsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(assignmentsPaginated, "assignmentsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.assignmentsPaginated = assignmentsPaginated;
        this.headers = headers;
    }

    public LmsListAssignmentsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AssignmentsPaginated> assignmentsPaginated() {
        return this.assignmentsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public LmsListAssignmentsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public LmsListAssignmentsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public LmsListAssignmentsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public LmsListAssignmentsResponse withAssignmentsPaginated(AssignmentsPaginated assignmentsPaginated) {
        Utils.checkNotNull(assignmentsPaginated, "assignmentsPaginated");
        this.assignmentsPaginated = Optional.ofNullable(assignmentsPaginated);
        return this;
    }

    public LmsListAssignmentsResponse withAssignmentsPaginated(Optional<? extends AssignmentsPaginated> assignmentsPaginated) {
        Utils.checkNotNull(assignmentsPaginated, "assignmentsPaginated");
        this.assignmentsPaginated = assignmentsPaginated;
        return this;
    }

    public LmsListAssignmentsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LmsListAssignmentsResponse other = (LmsListAssignmentsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.assignmentsPaginated, other.assignmentsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.assignmentsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(LmsListAssignmentsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "assignmentsPaginated", this.assignmentsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AssignmentsPaginated> assignmentsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder assignmentsPaginated(AssignmentsPaginated assignmentsPaginated) {
            Utils.checkNotNull(assignmentsPaginated, "assignmentsPaginated");
            this.assignmentsPaginated = Optional.ofNullable(assignmentsPaginated);
            return this;
        }

        public Builder assignmentsPaginated(Optional<? extends AssignmentsPaginated> assignmentsPaginated) {
            Utils.checkNotNull(assignmentsPaginated, "assignmentsPaginated");
            this.assignmentsPaginated = assignmentsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public LmsListAssignmentsResponse build() {
            return new LmsListAssignmentsResponse(this.contentType, this.statusCode, this.rawResponse, this.assignmentsPaginated, this.headers);
        }
    }
}

