/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class ListValue {
    public static final ListValue CANDIDATES = new ListValue("candidates");
    public static final ListValue CONTACTS = new ListValue("contacts");
    public static final ListValue COMPANIES = new ListValue("companies");
    public static final ListValue UNMAPPED_VALUE = new ListValue("unmapped_value");
    private static final Map<String, ListValue> values = ListValue.createValuesMap();
    private static final Map<String, ListValueEnum> enums = ListValue.createEnumsMap();
    private final String value;

    private ListValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListValue of(String value) {
        Class<ListValue> clazz = ListValue.class;
        synchronized (ListValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new ListValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<ListValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListValue other = (ListValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "ListValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListValue[] values() {
        Class<ListValue> clazz = ListValue.class;
        synchronized (ListValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new ListValue[0]);
        }
    }

    private static final Map<String, ListValue> createValuesMap() {
        LinkedHashMap<String, ListValue> map = new LinkedHashMap<String, ListValue>();
        map.put("candidates", CANDIDATES);
        map.put("contacts", CONTACTS);
        map.put("companies", COMPANIES);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ListValueEnum> createEnumsMap() {
        HashMap<String, ListValueEnum> map = new HashMap<String, ListValueEnum>();
        map.put("candidates", ListValueEnum.CANDIDATES);
        map.put("contacts", ListValueEnum.CONTACTS);
        map.put("companies", ListValueEnum.COMPANIES);
        map.put("unmapped_value", ListValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum ListValueEnum {
        CANDIDATES("candidates"),
        CONTACTS("contacts"),
        COMPANIES("companies"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private ListValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<ListValue> {
        protected _Deserializer() {
            super(ListValue.class);
        }

        public ListValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return ListValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<ListValue> {
        protected _Serializer() {
            super(ListValue.class);
        }

        public void serialize(ListValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

