/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.LmsListCategoriesRequest;
import com.stackone.stackone_client_java.models.operations.LmsListCategoriesResponse;
import com.stackone.stackone_client_java.operations.LmsListCategoriesOperation;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class LmsListCategoriesRequestBuilder {
    private LmsListCategoriesRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public LmsListCategoriesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public LmsListCategoriesRequestBuilder request(LmsListCategoriesRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public LmsListCategoriesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public LmsListCategoriesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public LmsListCategoriesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        LmsListCategoriesOperation operation = new LmsListCategoriesOperation(this.sdkConfiguration, options);
        return (LmsListCategoriesResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<LmsListCategoriesResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        LmsListCategoriesOperation operation = new LmsListCategoriesOperation(this.sdkConfiguration, options);
        Paginator<LmsListCategoriesRequest, String> iterator = new Paginator<LmsListCategoriesRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), LmsListCategoriesRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<LmsListCategoriesResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

