/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class SkillsValue {
    public static final SkillsValue PRIMARY = new SkillsValue("primary");
    public static final SkillsValue SECONDARY = new SkillsValue("secondary");
    public static final SkillsValue TERTIARY = new SkillsValue("tertiary");
    public static final SkillsValue UNMAPPED_VALUE = new SkillsValue("unmapped_value");
    private static final Map<String, SkillsValue> values = SkillsValue.createValuesMap();
    private static final Map<String, SkillsValueEnum> enums = SkillsValue.createEnumsMap();
    private final String value;

    private SkillsValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SkillsValue of(String value) {
        Class<SkillsValue> clazz = SkillsValue.class;
        synchronized (SkillsValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new SkillsValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<SkillsValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SkillsValue other = (SkillsValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "SkillsValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SkillsValue[] values() {
        Class<SkillsValue> clazz = SkillsValue.class;
        synchronized (SkillsValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new SkillsValue[0]);
        }
    }

    private static final Map<String, SkillsValue> createValuesMap() {
        LinkedHashMap<String, SkillsValue> map = new LinkedHashMap<String, SkillsValue>();
        map.put("primary", PRIMARY);
        map.put("secondary", SECONDARY);
        map.put("tertiary", TERTIARY);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, SkillsValueEnum> createEnumsMap() {
        HashMap<String, SkillsValueEnum> map = new HashMap<String, SkillsValueEnum>();
        map.put("primary", SkillsValueEnum.PRIMARY);
        map.put("secondary", SkillsValueEnum.SECONDARY);
        map.put("tertiary", SkillsValueEnum.TERTIARY);
        map.put("unmapped_value", SkillsValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum SkillsValueEnum {
        PRIMARY("primary"),
        SECONDARY("secondary"),
        TERTIARY("tertiary"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private SkillsValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<SkillsValue> {
        protected _Deserializer() {
            super(SkillsValue.class);
        }

        public SkillsValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return SkillsValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<SkillsValue> {
        protected _Serializer() {
            super(SkillsValue.class);
        }

        public void serialize(SkillsValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

