/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.TimeOffBalancesSourceValue;
import com.stackone.stackone_client_java.models.components.TimeOffBalancesValue;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class BalanceUnit {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends TimeOffBalancesValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends TimeOffBalancesSourceValue> sourceValue;

    @JsonCreator
    public BalanceUnit(@JsonProperty(value="value") JsonNullable<? extends TimeOffBalancesValue> value, @JsonProperty(value="source_value") JsonNullable<? extends TimeOffBalancesSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public BalanceUnit() {
        this((JsonNullable<? extends TimeOffBalancesValue>)JsonNullable.undefined(), (JsonNullable<? extends TimeOffBalancesSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<TimeOffBalancesValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<TimeOffBalancesSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public BalanceUnit withValue(TimeOffBalancesValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public BalanceUnit withValue(JsonNullable<? extends TimeOffBalancesValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public BalanceUnit withSourceValue(TimeOffBalancesSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public BalanceUnit withSourceValue(JsonNullable<? extends TimeOffBalancesSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceUnit other = (BalanceUnit)o;
        return Utils.enhancedDeepEquals(this.value, other.value) && Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(BalanceUnit.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends TimeOffBalancesValue> value = JsonNullable.undefined();
        private JsonNullable<? extends TimeOffBalancesSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(TimeOffBalancesValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends TimeOffBalancesValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(TimeOffBalancesSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends TimeOffBalancesSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public BalanceUnit build() {
            return new BalanceUnit(this.value, this.sourceValue);
        }
    }
}

