/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.HrisListShiftsRequest;
import com.stackone.stackone_client_java.models.operations.HrisListShiftsResponse;
import com.stackone.stackone_client_java.operations.HrisListShiftsOperation;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class HrisListShiftsRequestBuilder {
    private HrisListShiftsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public HrisListShiftsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public HrisListShiftsRequestBuilder request(HrisListShiftsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public HrisListShiftsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public HrisListShiftsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public HrisListShiftsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListShiftsOperation operation = new HrisListShiftsOperation(this.sdkConfiguration, options);
        return (HrisListShiftsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<HrisListShiftsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListShiftsOperation operation = new HrisListShiftsOperation(this.sdkConfiguration, options);
        Paginator<HrisListShiftsRequest, String> iterator = new Paginator<HrisListShiftsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), HrisListShiftsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<HrisListShiftsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

