/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.javascript;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ClassPermission;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.script.ScoreAccessor;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.javascript.support.NativeList;
import org.elasticsearch.script.javascript.support.NativeMap;
import org.elasticsearch.script.javascript.support.ScriptValueConverter;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.PolicySecurityController;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.WrapFactory;

public class JavaScriptScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    private final AtomicLong counter = new AtomicLong();
    private static WrapFactory wrapFactory = new CustomWrapFactory();
    private Scriptable globalScope;
    private static final CodeSource DOMAIN;
    private static final int OPTIMIZATION_LEVEL = 1;

    public static void init() {
    }

    @Inject
    public JavaScriptScriptEngineService(Settings settings) {
        super(settings);
        Context ctx = Context.enter();
        try {
            this.globalScope = ctx.initStandardObjects(null, true);
        }
        finally {
            Context.exit();
        }
    }

    public void close() {
    }

    public String[] types() {
        return new String[]{"js", "javascript"};
    }

    public String[] extensions() {
        return new String[]{"js"};
    }

    public boolean sandboxed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object compile(String script, Map<String, String> params) {
        Context ctx = Context.enter();
        try {
            Script script2 = ctx.compileString(script, this.generateScriptName(), 1, (Object)DOMAIN);
            return script2;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutableScript executable(CompiledScript compiledScript, @Nullable Map<String, Object> vars) {
        Context ctx = Context.enter();
        try {
            Scriptable scope = ctx.newObject(this.globalScope);
            scope.setPrototype(this.globalScope);
            scope.setParentScope(null);
            if (vars != null) {
                for (Map.Entry<String, Object> entry : vars.entrySet()) {
                    ScriptableObject.putProperty((Scriptable)scope, (String)entry.getKey(), (Object)entry.getValue());
                }
            }
            JavaScriptExecutableScript javaScriptExecutableScript = new JavaScriptExecutableScript((Script)compiledScript.compiled(), scope);
            return javaScriptExecutableScript;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchScript search(final CompiledScript compiledScript, final SearchLookup lookup, final @Nullable Map<String, Object> vars) {
        Context ctx = Context.enter();
        try {
            final Scriptable scope = ctx.newObject(this.globalScope);
            scope.setPrototype(this.globalScope);
            scope.setParentScope(null);
            SearchScript searchScript = new SearchScript(){

                public LeafSearchScript getLeafSearchScript(LeafReaderContext context) throws IOException {
                    LeafSearchLookup leafLookup = lookup.getLeafSearchLookup(context);
                    for (Map.Entry entry : leafLookup.asMap().entrySet()) {
                        ScriptableObject.putProperty((Scriptable)scope, (String)((String)entry.getKey()), entry.getValue());
                    }
                    if (vars != null) {
                        for (Map.Entry entry : vars.entrySet()) {
                            ScriptableObject.putProperty((Scriptable)scope, (String)((String)entry.getKey()), entry.getValue());
                        }
                    }
                    return new JavaScriptSearchScript((Script)compiledScript.compiled(), scope, leafLookup);
                }

                public boolean needsScores() {
                    return true;
                }
            };
            return searchScript;
        }
        finally {
            Context.exit();
        }
    }

    private String generateScriptName() {
        return "Script" + this.counter.incrementAndGet() + ".js";
    }

    static {
        try {
            DOMAIN = new CodeSource(new URL("file:/untrusted"), (Certificate[])null);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        ContextFactory factory = new ContextFactory(){

            protected void onContextCreated(Context cx) {
                cx.setWrapFactory(wrapFactory);
                cx.setOptimizationLevel(1);
            }
        };
        if (System.getSecurityManager() != null) {
            factory.initApplicationClassLoader(AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    final AccessControlContext engineContext = AccessController.getContext();
                    return new ClassLoader(JavaScriptScriptEngineService.class.getClassLoader()){

                        @Override
                        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                            try {
                                engineContext.checkPermission((Permission)new ClassPermission(name));
                            }
                            catch (SecurityException e) {
                                throw new ClassNotFoundException(name, e);
                            }
                            return super.loadClass(name, resolve);
                        }
                    };
                }
            }));
        }
        factory.seal();
        ContextFactory.initGlobal((ContextFactory)factory);
        SecurityController.initGlobal((SecurityController)new PolicySecurityController(){

            public GeneratedClassLoader createClassLoader(ClassLoader parent, Object securityDomain) {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission((Permission)new SpecialPermission());
                }
                if (securityDomain != DOMAIN) {
                    throw new SecurityException("illegal securityDomain: " + securityDomain);
                }
                return super.createClassLoader(parent, securityDomain);
            }
        });
    }

    public static class CustomWrapFactory
    extends WrapFactory {
        public CustomWrapFactory() {
            this.setJavaPrimitiveWrap(false);
        }

        public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
            if (javaObject instanceof Map) {
                return NativeMap.wrap(scope, (Map)javaObject);
            }
            if (javaObject instanceof List) {
                return NativeList.wrap(scope, (List)javaObject, staticType);
            }
            return super.wrapAsJavaObject(cx, scope, javaObject, staticType);
        }
    }

    public static class JavaScriptSearchScript
    implements LeafSearchScript {
        private final Script script;
        private final Scriptable scope;
        private final LeafSearchLookup lookup;

        public JavaScriptSearchScript(Script script, Scriptable scope, LeafSearchLookup lookup) {
            this.script = script;
            this.scope = scope;
            this.lookup = lookup;
        }

        public void setScorer(Scorer scorer) {
            Context ctx = Context.enter();
            try {
                ScriptableObject.putProperty((Scriptable)this.scope, (String)"_score", (Object)wrapFactory.wrapAsJavaObject(ctx, this.scope, (Object)new ScoreAccessor(scorer), ScoreAccessor.class));
            }
            finally {
                Context.exit();
            }
        }

        public void setDocument(int doc) {
            this.lookup.setDocument(doc);
        }

        public void setNextVar(String name, Object value) {
            ScriptableObject.putProperty((Scriptable)this.scope, (String)name, (Object)value);
        }

        public void setSource(Map<String, Object> source) {
            this.lookup.source().setSource(source);
        }

        public Object run() {
            Context ctx = Context.enter();
            try {
                Object object = ScriptValueConverter.unwrapValue(this.script.exec(ctx, this.scope));
                return object;
            }
            finally {
                Context.exit();
            }
        }

        public float runAsFloat() {
            return ((Number)this.run()).floatValue();
        }

        public long runAsLong() {
            return ((Number)this.run()).longValue();
        }

        public double runAsDouble() {
            return ((Number)this.run()).doubleValue();
        }

        public Object unwrap(Object value) {
            return ScriptValueConverter.unwrapValue(value);
        }
    }

    public static class JavaScriptExecutableScript
    implements ExecutableScript {
        private final Script script;
        private final Scriptable scope;

        public JavaScriptExecutableScript(Script script, Scriptable scope) {
            this.script = script;
            this.scope = scope;
        }

        public Object run() {
            Context ctx = Context.enter();
            try {
                Object object = ScriptValueConverter.unwrapValue(this.script.exec(ctx, this.scope));
                return object;
            }
            finally {
                Context.exit();
            }
        }

        public void setNextVar(String name, Object value) {
            ScriptableObject.putProperty((Scriptable)this.scope, (String)name, (Object)value);
        }

        public Object unwrap(Object value) {
            return ScriptValueConverter.unwrapValue(value);
        }
    }
}

