/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.javascript.support;

import java.util.Arrays;
import java.util.List;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeList
extends NativeJavaObject
implements Scriptable,
Wrapper {
    private static final long serialVersionUID = 3664761893203964569L;
    private static final String LENGTH_PROPERTY = "length";
    private final List<Object> list;

    public static NativeList wrap(Scriptable scope, List<Object> list, Class<?> staticType) {
        return new NativeList(scope, list, staticType);
    }

    private NativeList(Scriptable scope, List<Object> list, Class<?> staticType) {
        super(scope, list, staticType);
        this.list = list;
    }

    public Object unwrap() {
        return this.list;
    }

    public String getClassName() {
        return "NativeList";
    }

    public Object get(String name, Scriptable start) {
        if (LENGTH_PROPERTY.equals(name)) {
            return this.list.size();
        }
        return super.get(name, start);
    }

    public Object get(int index, Scriptable start) {
        if (!this.has(index, start)) {
            return Undefined.instance;
        }
        return this.list.get(index);
    }

    public boolean has(String name, Scriptable start) {
        return super.has(name, start) || LENGTH_PROPERTY.equals(name);
    }

    public boolean has(int index, Scriptable start) {
        return index >= 0 && index < this.list.size();
    }

    public void put(int index, Scriptable start, Object value) {
        if (index == this.list.size()) {
            this.list.add(value);
        } else {
            this.list.set(index, value);
        }
    }

    public void delete(int index) {
        this.list.remove(index);
    }

    public Object[] getIds() {
        Object[] javaObjectIds = super.getIds();
        int size = this.list.size();
        Object[] ids = Arrays.copyOf(javaObjectIds, javaObjectIds.length + size);
        for (int i = 0; i < size; ++i) {
            ids[javaObjectIds.length + i] = i;
        }
        return ids;
    }

    public boolean hasInstance(Scriptable value) {
        if (!(value instanceof Wrapper)) {
            return false;
        }
        Object instance = ((Wrapper)value).unwrap();
        return List.class.isInstance(instance);
    }
}

