/*
 * Decompiled with CFR 0.152.
 */
package com.telapi.api;

import com.telapi.api.configuration.TelapiConfiguration;
import com.telapi.api.configuration.TelapiConstants;
import com.telapi.api.domain.Account;
import com.telapi.api.domain.Application;
import com.telapi.api.domain.Call;
import com.telapi.api.domain.Conference;
import com.telapi.api.domain.IncomingPhoneNumber;
import com.telapi.api.domain.Notification;
import com.telapi.api.domain.Participant;
import com.telapi.api.domain.Recording;
import com.telapi.api.domain.SmsMessage;
import com.telapi.api.domain.Transcription;
import com.telapi.api.domain.enums.AudioDirection;
import com.telapi.api.domain.enums.CallInterruptStatus;
import com.telapi.api.domain.enums.CallStatus;
import com.telapi.api.domain.enums.HttpMethod;
import com.telapi.api.domain.enums.Legs;
import com.telapi.api.domain.enums.LogLevel;
import com.telapi.api.domain.enums.TranscriptionStatus;
import com.telapi.api.domain.enums.TranscriptionType;
import com.telapi.api.domain.list.AccountsList;
import com.telapi.api.domain.list.ApplicationList;
import com.telapi.api.domain.list.AvailablePhoneNumberList;
import com.telapi.api.domain.list.CallList;
import com.telapi.api.domain.list.CarrierLookupList;
import com.telapi.api.domain.list.CnamDipList;
import com.telapi.api.domain.list.ConferenceList;
import com.telapi.api.domain.list.FraudList;
import com.telapi.api.domain.list.IncomingPhoneNumberList;
import com.telapi.api.domain.list.NotificationList;
import com.telapi.api.domain.list.RecordingList;
import com.telapi.api.domain.list.SmsMessageList;
import com.telapi.api.domain.list.TranscriptionList;
import com.telapi.api.exceptions.TelapiException;
import com.telapi.api.http.RestExecutor;
import com.telapi.api.requests.ApplicationRequest;
import com.telapi.api.requests.CallRequest;
import com.telapi.api.requests.IncomingPhoneNumberRequest;
import com.telapi.api.restproxies.AccountsProxy;
import com.telapi.api.restproxies.ApplicationProxy;
import com.telapi.api.restproxies.AvailablePhoneNumberProxy;
import com.telapi.api.restproxies.CallProxy;
import com.telapi.api.restproxies.CarrierLookupProxy;
import com.telapi.api.restproxies.ConferenceProxy;
import com.telapi.api.restproxies.FraudControlProxy;
import com.telapi.api.restproxies.IncomingPhoneNumberProxy;
import com.telapi.api.restproxies.NotificationProxy;
import com.telapi.api.restproxies.RecordingProxy;
import com.telapi.api.restproxies.SmsProxy;
import com.telapi.api.restproxies.TranscriptionProxy;
import java.net.URI;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;

public class TelapiConnector {
    private ApacheHttpClient4Executor executor;
    private TelapiConfiguration conf;
    private String fullBaseUrl;
    private AccountsProxy accountsProxy;
    private SmsProxy smsProxy;
    private CallProxy callProxy;
    private ConferenceProxy conferenceProxy;
    private ApplicationProxy applicationProxy;
    private IncomingPhoneNumberProxy incomingPhoneNumberProxy;
    private AvailablePhoneNumberProxy availablePhoneNumberProxy;
    private RecordingProxy recordingProxy;
    private NotificationProxy notificationProxy;
    private TranscriptionProxy transcriptionProxy;
    private CarrierLookupProxy carrierLookupProxy;
    private FraudControlProxy fraudControlProxy;

    public TelapiConnector(TelapiConfiguration conf) {
        this.conf = conf;
        this.executor = RestExecutor.createExecutor(conf);
        URI baseUrl = UriBuilder.fromUri((String)conf.getBaseUrl()).path("2011-07-01").build(new Object[0]);
        this.fullBaseUrl = baseUrl.toString();
        this.accountsProxy = this.createProxy(AccountsProxy.class);
        this.smsProxy = this.createProxy(SmsProxy.class);
        this.callProxy = this.createProxy(CallProxy.class);
        this.conferenceProxy = this.createProxy(ConferenceProxy.class);
        this.applicationProxy = this.createProxy(ApplicationProxy.class);
        this.incomingPhoneNumberProxy = this.createProxy(IncomingPhoneNumberProxy.class);
        this.availablePhoneNumberProxy = this.createProxy(AvailablePhoneNumberProxy.class);
        this.recordingProxy = this.createProxy(RecordingProxy.class);
        this.notificationProxy = this.createProxy(NotificationProxy.class);
        this.transcriptionProxy = this.createProxy(TranscriptionProxy.class);
        this.carrierLookupProxy = this.createProxy(CarrierLookupProxy.class);
        this.fraudControlProxy = this.createProxy(FraudControlProxy.class);
    }

    private <T> T createProxy(Class<T> clazz) {
        return (T)ProxyFactory.create(clazz, (String)this.fullBaseUrl, (ClientExecutor)this.executor);
    }

    private <T> T returnThrows(ClientResponse<T> response) throws TelapiException {
        int status = response.getStatus();
        if (status > 399) {
            TelapiException exception = (TelapiException)response.getEntity(TelapiException.class);
            throw exception;
        }
        return (T)response.getEntity();
    }

    private String getDateString(Date date) {
        if (date == null) {
            return null;
        }
        return TelapiConstants.queryDateFormat.format(date);
    }

    public Account viewAccount(String accountSid) throws TelapiException {
        ClientResponse<Account> acc = this.accountsProxy.getAccount(accountSid);
        return this.returnThrows(acc);
    }

    public Account viewAccount() throws TelapiException {
        return this.viewAccount(this.conf.getSid());
    }

    public AccountsList viewAccounts() throws TelapiException {
        ClientResponse<AccountsList> accounts = this.accountsProxy.getAccounts();
        return this.returnThrows(accounts);
    }

    public SmsMessage viewSmsMessage(String sid, String smsMessageSid) throws TelapiException {
        ClientResponse<SmsMessage> sms = this.smsProxy.getSmsMessage(sid, smsMessageSid);
        return this.returnThrows(sms);
    }

    public SmsMessage viewSmsMessage(String smsMessageSid) throws TelapiException {
        return this.viewSmsMessage(this.conf.getSid(), smsMessageSid);
    }

    public SmsMessageList listSmsMessages(String accountSid, String to, String from, Date dateSentGte, Date dateSentLt, Long page, Long pageSize) throws TelapiException {
        ClientResponse<SmsMessageList> smsList = this.smsProxy.getSmsMessageList(accountSid, to, from, this.getDateString(dateSentGte), this.getDateString(dateSentLt), page, pageSize);
        return this.returnThrows(smsList);
    }

    public SmsMessageList listSmsMessages(String to, String from, Date dateSentGte, Date dateSentLt, Long page, Long pageSize) throws TelapiException {
        return this.listSmsMessages(this.conf.getSid(), to, from, dateSentGte, dateSentLt, page, pageSize);
    }

    public SmsMessageList listSmsMessages() throws TelapiException {
        return this.listSmsMessages(this.conf.getSid(), null, null, null, null, null, null);
    }

    public SmsMessage sendSmsMessage(String accountSid, String to, String from, String body, String statusCallback) throws TelapiException {
        ClientResponse<SmsMessage> smsMessage = this.smsProxy.sendSmsMessage(accountSid, to, from, body, statusCallback);
        return this.returnThrows(smsMessage);
    }

    public SmsMessage sendSmsMessage(String to, String from, String body, String statusCallback) throws TelapiException {
        return this.sendSmsMessage(this.conf.getSid(), to, from, body, statusCallback);
    }

    public Call viewCall(String accountSid, String callSid) throws TelapiException {
        return this.returnThrows(this.callProxy.viewCall(accountSid, callSid));
    }

    public Call viewCall(String callSid) throws TelapiException {
        return this.viewCall(this.conf.getSid(), callSid);
    }

    public CallList listCalls(String accountSid, String to, String from, CallStatus status, Date startTimeGte, Date startTimeLt, Long page, Long pageSize) throws TelapiException {
        return this.returnThrows(this.callProxy.listCalls(accountSid, to, from, status, this.getDateString(startTimeGte), this.getDateString(startTimeLt), page, pageSize));
    }

    public CallList listCalls(String to, String from, CallStatus status, Date startTimeGte, Date startTimeLt, Long page, Long pageSize) throws TelapiException {
        return this.listCalls(this.conf.getSid(), to, from, status, startTimeGte, startTimeLt, page, pageSize);
    }

    public CallList listCalls() throws TelapiException {
        return this.listCalls(this.conf.getSid(), null, null, null, null, null, null, null);
    }

    public Call makeCall(String accountSid, String to, String from, String url, HttpMethod method, String fallbackUrl, HttpMethod fallbackMethod, String statusCallback, HttpMethod statusCallbackMethod, String heartbeatUrl, HttpMethod heartbeatMethod, String forwardedFrom, String sendDigits, Long timeout, Boolean hideCallerId, Boolean record, String recordCallback, HttpMethod recordCallbackMethod, Boolean transcribe, String transcribeCallback, HttpMethod transcribeCallbackMethod) throws TelapiException {
        return this.returnThrows(this.callProxy.makeCall(accountSid, to, from, url, method, fallbackUrl, fallbackMethod, statusCallback, statusCallbackMethod, heartbeatUrl, heartbeatMethod, forwardedFrom, sendDigits, timeout, hideCallerId, record, recordCallback, recordCallbackMethod, transcribe, transcribeCallback, transcribeCallbackMethod));
    }

    public Call makeCall(String to, String from, String url, HttpMethod method, String fallbackUrl, HttpMethod fallbackMethod, String statusCallback, HttpMethod statusCallbackMethod, String heartbeatUrl, HttpMethod heartbeatMethod, String forwardedFrom, String sendDigits, Long timeout, Boolean hideCallerId, Boolean record, String recordCallback, HttpMethod recordCallbackMethod, Boolean transcribe, String transcribeCallback, HttpMethod transcribeCallbackMethod) throws TelapiException {
        return this.makeCall(this.conf.getSid(), to, from, url, method, fallbackUrl, fallbackMethod, statusCallback, statusCallbackMethod, heartbeatUrl, heartbeatMethod, forwardedFrom, sendDigits, timeout, hideCallerId, record, recordCallback, recordCallbackMethod, transcribe, transcribeCallback, transcribeCallbackMethod);
    }

    public Call makeCall(CallRequest callRequest) throws TelapiException {
        String accountSid = this.conf.getSid();
        if (callRequest.getAccountSid() != null) {
            accountSid = callRequest.getAccountSid();
        }
        return this.makeCall(accountSid, callRequest.getTo(), callRequest.getFrom(), callRequest.getUrl(), callRequest.getMethod(), callRequest.getFallbackUrl(), callRequest.getFallbackMethod(), callRequest.getStatusCallback(), callRequest.getStatusCallbackMethod(), callRequest.getHeartbeatUrl(), callRequest.getHeartbeatMethod(), callRequest.getForwardedFrom(), callRequest.getSendDigits(), callRequest.getTimeout(), callRequest.getHideCallerId(), callRequest.getRecord(), callRequest.getRecordCallback(), callRequest.getRecordCallbackMethod(), callRequest.getTranscribe(), callRequest.getTranscribeCallback(), callRequest.getTranscribeCallbackMethod());
    }

    public Call hangUpCall(String accountSid, String callSid) throws TelapiException {
        return this.returnThrows(this.callProxy.hangupCall(accountSid, callSid, CallInterruptStatus.COMPLETED));
    }

    public Call hangUpCall(String callSid) throws TelapiException {
        return this.hangUpCall(this.conf.getSid(), callSid);
    }

    public Call sendDigits(String accountSid, String callSid, String playDtfm, Legs dtmfLeg) throws TelapiException {
        return this.returnThrows(this.callProxy.sendDigits(accountSid, callSid, playDtfm, dtmfLeg));
    }

    public Call sendDigits(String callSid, String playDtfm, Legs dtmfLeg) throws TelapiException {
        return this.sendDigits(this.conf.getSid(), callSid, playDtfm, dtmfLeg);
    }

    public Call playAudioToCall(String accountSid, String callSid, String soundsUrl, Long length, Legs legs, Boolean loop, Boolean mix) throws TelapiException {
        return this.returnThrows(this.callProxy.playAudio(accountSid, callSid, soundsUrl, length, legs, loop, mix));
    }

    public Call playAudioToCall(String callSid, String soundsUrl, Long length, Legs legs, Boolean loop, Boolean mix) throws TelapiException {
        return this.playAudioToCall(this.conf.getSid(), callSid, soundsUrl, length, legs, loop, mix);
    }

    public Call playAudioToCall(String callSid, String soundsUrl) throws TelapiException {
        return this.playAudioToCall(this.conf.getSid(), callSid, soundsUrl, null, null, null, null);
    }

    public Call voiceEffects(String accountSid, String callSid, AudioDirection audioDirection, Double pitch, Long pitchSemiTones, Long pitchOctaves, Double rate) throws TelapiException {
        return this.returnThrows(this.callProxy.voiceEffects(accountSid, callSid, audioDirection, pitch, pitchSemiTones, pitchOctaves, rate));
    }

    public Call voiceEffects(String callSid, AudioDirection audioDirection, Double pitch, Long pitchSemiTones, Long pitchOctaves, Double rate) throws TelapiException {
        return this.voiceEffects(this.conf.getSid(), callSid, audioDirection, pitch, pitchSemiTones, pitchOctaves, rate);
    }

    public RecordingList recordCall(String accountSid, String callSid, Boolean record, Long timeLimit, String callbackUrl) throws TelapiException {
        return this.returnThrows(this.callProxy.recordCall(accountSid, callSid, record, timeLimit, callbackUrl));
    }

    public RecordingList recordCall(String callSid, Boolean record, Long timeLimit, String callbackUrl) throws TelapiException {
        return this.recordCall(this.conf.getSid(), callSid, record, timeLimit, callbackUrl);
    }

    public Conference viewConference(String accountSid, String conferenceSid) throws TelapiException {
        return this.returnThrows(this.conferenceProxy.viewConference(accountSid, conferenceSid));
    }

    public ConferenceList listConferences(String accountSid, String friendlyName, String status, Date dateCreatedGte, Date dateCreatedLt, Date dateUpdatedGte, Date dateUpdatedLt, Long page, Long pageSize) throws TelapiException {
        return this.returnThrows(this.conferenceProxy.listConferences(accountSid, friendlyName, status, this.getDateString(dateCreatedGte), this.getDateString(dateCreatedLt), this.getDateString(dateUpdatedGte), this.getDateString(dateUpdatedLt), page, pageSize));
    }

    public Participant viewParticipant(String accountSid, String conferenceSid, String callSid) throws TelapiException {
        return this.returnThrows(this.conferenceProxy.viewParticipant(accountSid, conferenceSid, callSid));
    }

    public Participant viewParticipant(String conferenceSid, String callSid) throws TelapiException {
        return this.returnThrows(this.conferenceProxy.viewParticipant(this.conf.getSid(), conferenceSid, callSid));
    }

    public List<Participant> listParticipants(String accountSid, String conferenceSid, Boolean muted, Boolean deaf, Long page, Long pageSize) throws TelapiException {
        return this.returnThrows(this.conferenceProxy.listParticipants(accountSid, conferenceSid, muted, deaf, page, pageSize));
    }

    public List<Participant> listParticipants(String conferenceSid, Boolean muted, Boolean deaf, Long page, Long pageSize) throws TelapiException {
        return this.listParticipants(this.conf.getSid(), conferenceSid, muted, deaf, page, pageSize);
    }

    public List<Participant> listParticipants(String conferenceSid) throws TelapiException {
        return this.listParticipants(conferenceSid, null, null, null, null);
    }

    public Participant deafOrMuteParticipant(String accountSid, String conferenceSid, String callSid, Boolean muted, Boolean deaf) throws TelapiException {
        return this.returnThrows(this.conferenceProxy.muteDeafParticipant(accountSid, conferenceSid, callSid, muted, deaf));
    }

    public Participant deafOrMuteParticipant(String conferenceSid, String callSid, Boolean muted, Boolean deaf) throws TelapiException {
        return this.returnThrows(this.conferenceProxy.muteDeafParticipant(this.conf.getSid(), conferenceSid, callSid, muted, deaf));
    }

    public Participant hangupParticipant(String accountSid, String conferenceSid, String callSid) throws TelapiException {
        return this.returnThrows(this.conferenceProxy.hangupParticipant(accountSid, conferenceSid, callSid));
    }

    public Participant hangupParticipant(String conferenceSid, String callSid) throws TelapiException {
        return this.returnThrows(this.conferenceProxy.hangupParticipant(this.conf.getSid(), conferenceSid, callSid));
    }

    public Participant playAudioToParticipant(String accountSid, String conferenceSid, String callSid, String url) throws TelapiException {
        return this.returnThrows(this.conferenceProxy.playAudioToParticipant(accountSid, conferenceSid, callSid, url));
    }

    public Conference viewConference(String conferenceSid) throws TelapiException {
        return this.viewConference(this.conf.getSid(), conferenceSid);
    }

    public ConferenceList listConferences(String friendlyName, String status, Date dateCreatedGte, Date dateCreatedLt, Date dateUpdatedGte, Date dateUpdatedLt, Long page, Long pageSize) throws TelapiException {
        return this.listConferences(this.conf.getSid(), friendlyName, status, dateCreatedGte, dateCreatedLt, dateUpdatedGte, dateUpdatedLt, page, pageSize);
    }

    public ConferenceList listConferences() throws TelapiException {
        return this.listConferences(null, null, null, null, null, null, null, null);
    }

    public Participant playAudioToParticipant(String conferenceSid, String callSid, String audioUrl) throws TelapiException {
        return this.playAudioToParticipant(this.conf.getSid(), conferenceSid, callSid, audioUrl);
    }

    public Application viewApplication(String accountSid, String applicationSid) throws TelapiException {
        return this.returnThrows(this.applicationProxy.viewApplication(accountSid, applicationSid));
    }

    public ApplicationList listApplications(String accountSid, String friendlyName, Long page, Long pageSize) throws TelapiException {
        return this.returnThrows(this.applicationProxy.listApplications(accountSid, friendlyName, page, pageSize));
    }

    public Application createApplication(String accountSid, String friendlyName, String voiceUrl, HttpMethod voiceMethod, String voiceFallbackUrl, HttpMethod voiceFallbackMethod, Boolean voiceCallerIdLookup, String smsUrl, HttpMethod smsMethod, String smsFallbackUrl, HttpMethod smsFallbackMethod, String heartbeatUrl, HttpMethod heartbeatMethod, String hangupCallback, HttpMethod hangupCallbackMethod) throws TelapiException {
        return this.returnThrows(this.applicationProxy.createApplication(accountSid, friendlyName, voiceUrl, voiceMethod, voiceFallbackUrl, voiceFallbackMethod, voiceCallerIdLookup, smsUrl, smsMethod, smsFallbackUrl, smsFallbackMethod, heartbeatUrl, heartbeatMethod, hangupCallback, hangupCallbackMethod));
    }

    public Application createApplication(ApplicationRequest applicationRequest) throws TelapiException {
        String accountSid = this.conf.getSid();
        if (applicationRequest.getAccountSid() != null) {
            accountSid = applicationRequest.getAccountSid();
        }
        return this.createApplication(accountSid, applicationRequest.getFriendlyName(), applicationRequest.getVoiceUrl(), applicationRequest.getVoiceMethod(), applicationRequest.getVoiceFallbackUrl(), applicationRequest.getVoiceFallbackMethod(), applicationRequest.getVoiceCallerIdLookup(), applicationRequest.getSmsUrl(), applicationRequest.getSmsMethod(), applicationRequest.getSmsFallbackUrl(), applicationRequest.getSmsFallbackMethod(), applicationRequest.getHeartbeatUrl(), applicationRequest.getHeartbeatMethod(), applicationRequest.getStatusCallback(), applicationRequest.getStatusCallbackMethod());
    }

    public Application updateApplication(String accountSid, String applicationSid, String friendlyName, String voiceUrl, HttpMethod voiceMethod, String voiceFallbackUrl, HttpMethod voiceFallbackMethod, Boolean voiceCallerIdLookup, String smsUrl, HttpMethod smsMethod, String smsFallbackUrl, HttpMethod smsFallbackMethod, String heartbeatUrl, HttpMethod heartbeatMethod, String hangupCallback, HttpMethod hangupCallbackMethod) throws TelapiException {
        return this.returnThrows(this.applicationProxy.updateApplication(accountSid, applicationSid, friendlyName, voiceUrl, voiceMethod, voiceFallbackUrl, voiceFallbackMethod, voiceCallerIdLookup, smsUrl, smsMethod, smsFallbackUrl, smsFallbackMethod, heartbeatUrl, heartbeatMethod, hangupCallback, hangupCallbackMethod));
    }

    public Application updateApplication(ApplicationRequest applicationRequest) throws TelapiException {
        String accountSid = this.conf.getSid();
        if (applicationRequest.getAccountSid() != null) {
            accountSid = applicationRequest.getAccountSid();
        }
        return this.updateApplication(accountSid, applicationRequest.getSid(), applicationRequest.getFriendlyName(), applicationRequest.getVoiceUrl(), applicationRequest.getVoiceMethod(), applicationRequest.getVoiceFallbackUrl(), applicationRequest.getVoiceFallbackMethod(), applicationRequest.getVoiceCallerIdLookup(), applicationRequest.getSmsUrl(), applicationRequest.getSmsMethod(), applicationRequest.getSmsFallbackUrl(), applicationRequest.getSmsFallbackMethod(), applicationRequest.getHeartbeatUrl(), applicationRequest.getHeartbeatMethod(), applicationRequest.getStatusCallback(), applicationRequest.getStatusCallbackMethod());
    }

    public Application deleteApplication(String accountSid, String applicationSid) throws TelapiException {
        return this.returnThrows(this.applicationProxy.deleteApplication(accountSid, applicationSid));
    }

    public Application viewApplication(String applicationSid) throws TelapiException {
        return this.viewApplication(this.conf.getSid(), applicationSid);
    }

    public ApplicationList listApplications(String friendlyName, Long page, Long pageSize) throws TelapiException {
        return this.listApplications(this.conf.getSid(), friendlyName, page, pageSize);
    }

    public ApplicationList listApplications() throws TelapiException {
        return this.listApplications(this.conf.getSid(), null, null, null);
    }

    public Application createApplication(String friendlyName, String voiceUrl, HttpMethod voiceMethod, String voiceFallbackUrl, HttpMethod voiceFallbackMethod, Boolean voiceCallerIdLookup, String smsUrl, HttpMethod smsMethod, String smsFallbackUrl, HttpMethod smsFallbackMethod, String heartbeatUrl, HttpMethod heartbeatMethod, String hangupCallback, HttpMethod hangupCallbackMethod) throws TelapiException {
        return this.createApplication(this.conf.getSid(), friendlyName, voiceUrl, voiceMethod, voiceFallbackUrl, voiceFallbackMethod, voiceCallerIdLookup, smsUrl, smsMethod, smsFallbackUrl, smsFallbackMethod, heartbeatUrl, heartbeatMethod, hangupCallback, hangupCallbackMethod);
    }

    public Application updateApplication(String applicationSid, String friendlyName, String voiceUrl, HttpMethod voiceMethod, String voiceFallbackUrl, HttpMethod voiceFallbackMethod, Boolean voiceCallerIdLookup, String smsUrl, HttpMethod smsMethod, String smsFallbackUrl, HttpMethod smsFallbackMethod, String heartbeatUrl, HttpMethod heartbeatMethod, String hangupCallback, HttpMethod hangupCallbackMethod) throws TelapiException {
        return this.updateApplication(this.conf.getSid(), applicationSid, friendlyName, voiceUrl, voiceMethod, voiceFallbackUrl, voiceFallbackMethod, voiceCallerIdLookup, smsUrl, smsMethod, smsFallbackUrl, smsFallbackMethod, heartbeatUrl, heartbeatMethod, hangupCallback, hangupCallbackMethod);
    }

    public Application deleteApplication(String applicationSid) throws TelapiException {
        return this.deleteApplication(this.conf.getSid(), applicationSid);
    }

    public IncomingPhoneNumber viewIncomingPhoneNumber(String accountSid, String incomingPhoneNumberSid) throws TelapiException {
        return this.returnThrows(this.incomingPhoneNumberProxy.viewIncomingPhoneNumber(accountSid, incomingPhoneNumberSid));
    }

    public IncomingPhoneNumberList listIncomingPhoneNumbers(String accountSid, String phoneNumber, String friendlyName, Long page, Long pageSize) throws TelapiException {
        return this.returnThrows(this.incomingPhoneNumberProxy.listIncomingPhoneNumbers(accountSid, phoneNumber, friendlyName, page, pageSize));
    }

    public IncomingPhoneNumber addIncomingPhoneNumber(String accountSid, String phoneNumber, String areaCode) throws TelapiException {
        return this.returnThrows(this.incomingPhoneNumberProxy.addIncomingPhoneNumber(accountSid, phoneNumber, areaCode));
    }

    public IncomingPhoneNumber deleteIncomingPhoneNumber(String accountSid, String incomingPhoneNumberSid) throws TelapiException {
        return this.returnThrows(this.incomingPhoneNumberProxy.deleteIncomingPhoneNumber(accountSid, incomingPhoneNumberSid));
    }

    public IncomingPhoneNumber updateIncomingPhoneNumber(String accountSid, String incomingPhoneNumberSid, String friendlyName, String voiceUrl, HttpMethod voiceMethod, String voiceFallbackUrl, HttpMethod voiceFallbackMethod, Boolean voiceCallerIdLookup, String smsUrl, HttpMethod smsMethod, String smsFallbackUrl, HttpMethod smsFallbackMethod, String hangupCallback, HttpMethod hangupCallbackMethod, String heartbeatUrl, HttpMethod heartbeatMethod) throws TelapiException {
        return this.returnThrows(this.incomingPhoneNumberProxy.updateIncomingPhoneNumber(accountSid, incomingPhoneNumberSid, friendlyName, voiceUrl, voiceMethod, voiceFallbackUrl, voiceFallbackMethod, voiceCallerIdLookup, smsUrl, smsMethod, smsFallbackUrl, smsFallbackMethod, hangupCallback, hangupCallbackMethod, heartbeatUrl, heartbeatMethod));
    }

    public IncomingPhoneNumber updateIncomingPhoneNumber(IncomingPhoneNumberRequest ipnRequest) throws TelapiException {
        String accountSid = this.conf.getSid();
        if (ipnRequest.getAccountSid() != null) {
            accountSid = ipnRequest.getAccountSid();
        }
        return this.updateIncomingPhoneNumber(accountSid, ipnRequest.getIncomingPhoneNumberSid(), ipnRequest.getFriendlyName(), ipnRequest.getVoiceUrl(), ipnRequest.getVoiceMethod(), ipnRequest.getVoiceFallbackUrl(), ipnRequest.getVoiceFallbackMethod(), ipnRequest.getVoiceCallerIdLookup(), ipnRequest.getSmsUrl(), ipnRequest.getSmsMethod(), ipnRequest.getSmsFallbackUrl(), ipnRequest.getSmsFallbackMethod(), ipnRequest.getHangupCallback(), ipnRequest.getHangupCallbackMethod(), ipnRequest.getHeartbeatUrl(), ipnRequest.getHeartbeatMethod());
    }

    public IncomingPhoneNumber viewIncomingPhoneNumber(String incomingPhoneNumberSid) throws TelapiException {
        return this.viewIncomingPhoneNumber(this.conf.getSid(), incomingPhoneNumberSid);
    }

    public IncomingPhoneNumberList listIncomingPhoneNumbers(String phoneNumber, String friendlyName, Long page, Long pageSize) throws TelapiException {
        return this.listIncomingPhoneNumbers(this.conf.getSid(), phoneNumber, friendlyName, page, pageSize);
    }

    public IncomingPhoneNumberList listIncomingPhoneNumbers() throws TelapiException {
        return this.listIncomingPhoneNumbers(this.conf.getSid(), null, null, null, null);
    }

    public IncomingPhoneNumber addIncomingPhoneNumber(String phoneNumber, String areaCode) throws TelapiException {
        return this.addIncomingPhoneNumber(this.conf.getSid(), phoneNumber, areaCode);
    }

    public IncomingPhoneNumber deleteIncomingPhoneNumber(String incomingPhoneNumberSid) throws TelapiException {
        return this.deleteIncomingPhoneNumber(this.conf.getSid(), incomingPhoneNumberSid);
    }

    public IncomingPhoneNumber updateIncomingPhoneNumber(String incomingPhoneNumberSid, String friendlyName, String voiceUrl, HttpMethod voiceMethod, String voiceFallbackUrl, HttpMethod voiceFallbackMethod, Boolean voiceCallerIdLookup, String smsUrl, HttpMethod smsMethod, String smsFallbackUrl, HttpMethod smsFallbackMethod, String hangupCallback, HttpMethod hangupCallbackMethod, String heartbeatUrl, HttpMethod heartbeatMethod) throws TelapiException {
        return this.updateIncomingPhoneNumber(this.conf.getSid(), incomingPhoneNumberSid, friendlyName, voiceUrl, voiceMethod, voiceFallbackUrl, voiceFallbackMethod, voiceCallerIdLookup, smsUrl, smsMethod, smsFallbackUrl, smsFallbackMethod, hangupCallback, hangupCallbackMethod, heartbeatUrl, heartbeatMethod);
    }

    public AvailablePhoneNumberList listAvailablePhoneNumbers(String accountSid, String isoCountryCode, String areaCode, String contains, String inRegion, String inPostalCode, Long page, Long pageSize) throws TelapiException {
        return this.returnThrows(this.availablePhoneNumberProxy.listAvailablePhoneNumbers(accountSid, isoCountryCode, areaCode, contains, inRegion, inPostalCode, page, pageSize));
    }

    public AvailablePhoneNumberList listAvailablePhoneNumbers(String isoCountryCode, String areaCode, String contains, String inRegion, String inPostalCode, Long page, Long pageSize) throws TelapiException {
        return this.returnThrows(this.availablePhoneNumberProxy.listAvailablePhoneNumbers(this.conf.getSid(), isoCountryCode, areaCode, contains, inRegion, inPostalCode, page, pageSize));
    }

    public RecordingList listRecordings(String accountSid, Date dateCreatedGte, Date dateCreatedLt, Long page, Long pageSize) throws TelapiException {
        return this.returnThrows(this.recordingProxy.listRecordings(accountSid, this.getDateString(dateCreatedGte), this.getDateString(dateCreatedLt), page, pageSize));
    }

    public RecordingList listRecordings(Date dateCreatedGte, Date dateCreatedLt, Long page, Long pageSize) throws TelapiException {
        return this.listRecordings(this.conf.getSid(), dateCreatedGte, dateCreatedLt, page, pageSize);
    }

    public RecordingList listRecordings() throws TelapiException {
        return this.listRecordings(this.conf.getSid(), null, null, null, null);
    }

    public RecordingList listCallRecordings(String accountSid, String callSid, Date dateCreatedGte, Date dateCreatedLt, Long page, Long pageSize) throws TelapiException {
        return this.returnThrows(this.recordingProxy.listCallRecordings(accountSid, callSid, this.getDateString(dateCreatedGte), this.getDateString(dateCreatedLt), page, pageSize));
    }

    public RecordingList listCallRecordings(String callSid, Date dateCreatedGte, Date dateCreatedLt, Long page, Long pageSize) throws TelapiException {
        return this.listCallRecordings(this.conf.getSid(), callSid, dateCreatedGte, dateCreatedLt, page, pageSize);
    }

    public Recording viewRecording(String accountSid, String recordingSid) throws TelapiException {
        return this.returnThrows(this.recordingProxy.viewRecording(accountSid, recordingSid));
    }

    public Recording viewRecording(String recordingSid) throws TelapiException {
        return this.viewRecording(this.conf.getSid(), recordingSid);
    }

    public String getRecordingUrl(String accountSid, String recordingSid) throws TelapiException {
        ClientResponse<String> response = this.recordingProxy.getRecording(accountSid, recordingSid);
        String retVal = response.getLocation().getHref();
        this.returnThrows(response);
        return retVal;
    }

    public String getRecordingUrl(String recordingSid) throws TelapiException {
        return this.getRecordingUrl(this.conf.getSid(), recordingSid);
    }

    public NotificationList listNotifications(String accountSid, LogLevel log, Long page, Long pageSize) throws TelapiException {
        return this.returnThrows(this.notificationProxy.listNotifications(accountSid, log, page, pageSize));
    }

    public NotificationList listNotifications(LogLevel log, Long page, Long pageSize) throws TelapiException {
        return this.listNotifications(this.conf.getSid(), log, page, pageSize);
    }

    public NotificationList listNotifications() throws TelapiException {
        return this.listNotifications(this.conf.getSid(), null, null, null);
    }

    public NotificationList listCallNotifications(String accountSid, String callSid, LogLevel log, Long page, Long pageSize) throws TelapiException {
        return this.returnThrows(this.notificationProxy.listCallNotifications(accountSid, callSid, log, page, pageSize));
    }

    public NotificationList listCallNotifications(String callSid, LogLevel log, Long page, Long pageSize) throws TelapiException {
        return this.listCallNotifications(this.conf.getSid(), callSid, log, page, pageSize);
    }

    public Notification viewNotification(String accountSid, String notificationSid) throws TelapiException {
        return this.returnThrows(this.notificationProxy.viewNotification(accountSid, notificationSid));
    }

    public Notification viewNotification(String notificationSid) throws TelapiException {
        return this.viewNotification(this.conf.getSid(), notificationSid);
    }

    public Transcription viewTranscription(String accountSid, String transcriptionSid) throws TelapiException {
        return this.returnThrows(this.transcriptionProxy.viewTranscription(accountSid, transcriptionSid));
    }

    public String viewTranscriptionText(String accountSid, String transcriptionSid) throws TelapiException {
        return this.returnThrows(this.transcriptionProxy.viewTranscriptionText(accountSid, transcriptionSid));
    }

    public TranscriptionList listTranscriptions(String accountSid, TranscriptionStatus status, Date dateTranscribedGte, Date dateTranscribedLt, Long page, Long pageSize) throws TelapiException {
        return this.returnThrows(this.transcriptionProxy.listTranscriptions(accountSid, status, this.getDateString(dateTranscribedGte), this.getDateString(dateTranscribedLt), page, pageSize));
    }

    public TranscriptionList listRecordingTranscriptions(String accountSid, String recordingSid, TranscriptionStatus status, Date dateTranscribedGte, Date dateTranscribedLt, Long page, Long pageSize) throws TelapiException {
        return this.returnThrows(this.transcriptionProxy.listRecordingTranscriptions(accountSid, recordingSid, status, this.getDateString(dateTranscribedGte), this.getDateString(dateTranscribedLt), page, pageSize));
    }

    public Transcription transcribeRecording(String accountSid, String recordingSid, String transcribeCallback, HttpMethod callbackMethod, TranscriptionType quality) throws TelapiException {
        return this.returnThrows(this.transcriptionProxy.transcribeRecording(accountSid, recordingSid, transcribeCallback, callbackMethod, quality));
    }

    public Transcription transcribeAudioUrl(String accountSid, String audioUrl, String transcribeCallback, HttpMethod callbackMethod, TranscriptionType quality) throws TelapiException {
        return this.returnThrows(this.transcriptionProxy.transcribeAudioUrl(accountSid, audioUrl, transcribeCallback, callbackMethod, quality));
    }

    public Transcription viewTranscription(String transcriptionSid) throws TelapiException {
        return this.viewTranscription(this.conf.getSid(), transcriptionSid);
    }

    public String viewTranscriptionText(String transcriptionSid) throws TelapiException {
        return this.viewTranscriptionText(this.conf.getSid(), transcriptionSid);
    }

    public TranscriptionList listTranscriptions(TranscriptionStatus status, Date dateTranscribedGte, Date dateTranscribedLt, Long page, Long pageSize) throws TelapiException {
        return this.listTranscriptions(this.conf.getSid(), status, dateTranscribedGte, dateTranscribedLt, page, pageSize);
    }

    public TranscriptionList listTranscriptions() throws TelapiException {
        return this.listTranscriptions(this.conf.getSid(), null, null, null, null, null);
    }

    public TranscriptionList listRecordingTranscriptions(String recordingSid, TranscriptionStatus status, Date dateTranscribedGte, Date dateTranscribedLt, Long page, Long pageSize) throws TelapiException {
        return this.listRecordingTranscriptions(this.conf.getSid(), recordingSid, status, dateTranscribedGte, dateTranscribedLt, page, pageSize);
    }

    public Transcription transcribeRecording(String recordingSid, String transcribeCallback, HttpMethod callbackMethod, TranscriptionType quality) throws TelapiException {
        return this.transcribeRecording(this.conf.getSid(), recordingSid, transcribeCallback, callbackMethod, quality);
    }

    public Transcription transcribeAudioUrl(String audioUrl, String transcribeCallback, HttpMethod callbackMethod, TranscriptionType quality) throws TelapiException {
        return this.transcribeAudioUrl(this.conf.getSid(), audioUrl, transcribeCallback, callbackMethod, quality);
    }

    public CarrierLookupList carrierLookup(String accountSid, String phoneNumber) throws TelapiException {
        return this.returnThrows(this.carrierLookupProxy.carrierLookup(accountSid, phoneNumber));
    }

    public CarrierLookupList carrierLookup(String accountSid, List<String> phoneNumber) throws TelapiException {
        return this.returnThrows(this.carrierLookupProxy.carrierLookup(accountSid, phoneNumber));
    }

    public CnamDipList cnamLookup(String accountSid, String phoneNumber) throws TelapiException {
        return this.returnThrows(this.carrierLookupProxy.cnamLookup(accountSid, phoneNumber));
    }

    public CnamDipList cnamLookup(String accountSid, List<String> phoneNumbers) throws TelapiException {
        return this.returnThrows(this.carrierLookupProxy.cnamLookup(accountSid, phoneNumbers));
    }

    public CarrierLookupList carrierLookup(String phoneNumber) throws TelapiException {
        return this.carrierLookup(this.conf.getSid(), phoneNumber);
    }

    public CarrierLookupList carrierLookup(List<String> phoneNumber) throws TelapiException {
        return this.carrierLookup(this.conf.getSid(), phoneNumber);
    }

    public CnamDipList cnamLookup(String phoneNumber) throws TelapiException {
        return this.cnamLookup(this.conf.getSid(), phoneNumber);
    }

    public CnamDipList cnamLookup(List<String> phoneNumbers) throws TelapiException {
        return this.cnamLookup(this.conf.getSid(), phoneNumbers);
    }

    public FraudList listFraudControlResources(String accountSid, Long page, Long pageSize) throws TelapiException {
        return this.returnThrows(this.fraudControlProxy.listFraudControlResources(accountSid, page, pageSize));
    }

    public FraudList authorizeDestination(String accountSid, String countryCode, Boolean mobileEnabled, Boolean landlineEnabled, Boolean smsEnabled) throws TelapiException {
        return this.returnThrows(this.fraudControlProxy.authorizeDestination(accountSid, countryCode, mobileEnabled, landlineEnabled, smsEnabled));
    }

    public FraudList blockDestination(String accountSid, String countryCode, Boolean mobileEnabled, Boolean landlineEnabled, Boolean smsEnabled) throws TelapiException {
        return this.returnThrows(this.fraudControlProxy.blockDestination(accountSid, countryCode, mobileEnabled, landlineEnabled, smsEnabled));
    }

    public FraudList extendDestinationAuth(String accountSid, String countryCode, Boolean mobileEnabled, Boolean landlineEnabled, Boolean smsEnabled) throws TelapiException {
        return this.returnThrows(this.fraudControlProxy.extendDestinationAuth(accountSid, countryCode, mobileEnabled, landlineEnabled, smsEnabled));
    }

    public FraudList whitelistDestination(String accountSid, String countryCode, Boolean mobileEnabled, Boolean landlineEnabled, Boolean smsEnabled) throws TelapiException {
        return this.returnThrows(this.fraudControlProxy.whitelistDestination(accountSid, countryCode, mobileEnabled, landlineEnabled, smsEnabled));
    }

    public FraudList listFraudControlResources(Long page, Long pageSize) throws TelapiException {
        return this.listFraudControlResources(this.conf.getSid(), page, pageSize);
    }

    public FraudList listFraudControlResources() throws TelapiException {
        return this.listFraudControlResources(this.conf.getSid(), null, null);
    }

    public FraudList authorizeDestination(String countryCode, Boolean mobileEnabled, Boolean landlineEnabled, Boolean smsEnabled) throws TelapiException {
        return this.authorizeDestination(this.conf.getSid(), countryCode, mobileEnabled, landlineEnabled, smsEnabled);
    }

    public FraudList blockDestination(String countryCode, Boolean mobileEnabled, Boolean landlineEnabled, Boolean smsEnabled) throws TelapiException {
        return this.blockDestination(this.conf.getSid(), countryCode, mobileEnabled, landlineEnabled, smsEnabled);
    }

    public FraudList extendDestinationAuth(String countryCode, Boolean mobileEnabled, Boolean landlineEnabled, Boolean smsEnabled) throws TelapiException {
        return this.extendDestinationAuth(this.conf.getSid(), countryCode, mobileEnabled, landlineEnabled, smsEnabled);
    }

    public FraudList whitelistDestination(String countryCode, Boolean mobileEnabled, Boolean landlineEnabled, Boolean smsEnabled) throws TelapiException {
        return this.whitelistDestination(this.conf.getSid(), countryCode, mobileEnabled, landlineEnabled, smsEnabled);
    }
}

