/*
 * Decompiled with CFR 0.152.
 */
package com.telapi.api.configuration;

import com.telapi.api.configuration.TelapiConfiguration;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertiesFileTelapiConfiguration
extends Properties
implements TelapiConfiguration {
    private static final long serialVersionUID = -7348144965758395514L;
    Logger logger = Logger.getLogger(PropertiesFileTelapiConfiguration.class);

    public PropertiesFileTelapiConfiguration() {
        this("telapi.properties");
    }

    public PropertiesFileTelapiConfiguration(String propFileName) {
        URL url = ClassLoader.getSystemResource(propFileName);
        try {
            this.load(url.openStream());
        }
        catch (IOException e) {
            this.logger.error((Object)("Cannot load or find Telapi properties file on classpath: " + propFileName), (Throwable)e);
        }
    }

    public PropertiesFileTelapiConfiguration(FileInputStream is) {
        try {
            this.load(is);
        }
        catch (IOException e) {
            this.logger.error((Object)"Cannot load the specified Telapi properties file.");
        }
    }

    @Override
    public String getSid() {
        return this.getProperty("sid");
    }

    @Override
    public String getAuthToken() {
        return this.getProperty("authToken");
    }

    @Override
    public String getBaseUrl() {
        return this.getProperty("baseUrl", "https://api.telapi.com/");
    }

    @Override
    public String getProxyHost() {
        return this.getProperty("proxyHost", null);
    }

    @Override
    public String getProxyPort() {
        return this.getProperty("proxyPort", null);
    }

    @Override
    public String getProxyProtocol() {
        return this.getProperty("proxyProtocol", null);
    }
}

