/*
 * Decompiled with CFR 0.152.
 */
package com.telapi.api.inboundxml.elements;

import com.telapi.api.domain.enums.HttpMethod;
import com.telapi.api.inboundxml.elements.Conference;
import com.telapi.api.inboundxml.elements.DialElement;
import com.telapi.api.inboundxml.elements.Number;
import com.telapi.api.inboundxml.elements.ResponseElement;
import com.telapi.api.inboundxml.elements.Sip;
import com.telapi.api.inboundxml.parameters.ConferenceParameters;
import com.telapi.api.inboundxml.parameters.DialParameters;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.converters.extended.ToAttributedValueConverter;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="Dial")
@XStreamConverter(value=ToAttributedValueConverter.class, strings={"number"})
public class Dial
implements ResponseElement {
    @XStreamImplicit
    private List<DialElement> elements = new ArrayList<DialElement>();
    private String number;
    @XStreamAsAttribute
    private String action;
    @XStreamAsAttribute
    private String method;
    @XStreamAsAttribute
    private Long timeout;
    @XStreamAsAttribute
    private Boolean hangupOnStar;
    @XStreamAsAttribute
    private Long timeLimit;
    @XStreamAsAttribute
    private String callerId;
    @XStreamAsAttribute
    private Boolean hideCallerId;
    @XStreamAsAttribute
    private String callerName;
    @XStreamAsAttribute
    private String dialMusic;
    @XStreamAsAttribute
    private String callbackUrl;
    @XStreamAsAttribute
    private String callbackMethod;
    @XStreamAsAttribute
    private Boolean confirmSound;
    @XStreamAsAttribute
    private String digitsMatch;
    @XStreamAsAttribute
    private Boolean straightToVm;
    @XStreamAsAttribute
    private String heartbeatUrl;
    @XStreamAsAttribute
    private String heartbeatMethod;
    @XStreamAsAttribute
    private String forwardedFrom;

    protected Dial() {
    }

    public static Dial createDial(String number, String action, HttpMethod method, Long timeout, Boolean hangupOnStar, Long timeLimit, String callerId, Boolean hideCallerId, String dialMusic, String callbackUrl, HttpMethod callbackMethod, Boolean confirmSound, String digitsMatch, Boolean straightToVm, String heartbeatUrl, HttpMethod heartbeatMethod, String forwardedFrom) {
        Dial d = new Dial();
        d.number = number;
        d.action = action;
        d.method = method == null ? null : method.toString();
        d.timeout = timeout;
        d.hangupOnStar = hangupOnStar;
        d.timeLimit = timeLimit;
        d.callerId = callerId;
        d.hideCallerId = hideCallerId;
        d.dialMusic = dialMusic;
        d.callbackUrl = callbackUrl;
        d.callbackMethod = callbackMethod == null ? null : callbackMethod.toString();
        d.confirmSound = confirmSound;
        d.digitsMatch = digitsMatch;
        d.straightToVm = straightToVm;
        d.heartbeatUrl = heartbeatUrl;
        d.heartbeatMethod = heartbeatMethod == null ? null : heartbeatMethod.toString();
        d.forwardedFrom = forwardedFrom;
        return d;
    }

    public static Dial createDial(DialParameters params) {
        Dial d = Dial.createDial(params.getNumber(), params.getAction(), params.getMethod(), params.getTimeout(), params.getHangupOnStar(), params.getTimeLimit(), params.getCallerId(), params.getHideCallerId(), params.getDialMusic(), params.getCallbackUrl(), params.getCallbackMethod(), params.getConfirmSound(), params.getDigitsMatch(), params.getStraightToVm(), params.getHeartbeatUrl(), params.getHeartbeatMethod(), params.getForwardedFrom());
        return d;
    }

    public static Dial createDial(String number) {
        Dial d = new Dial();
        d.number = number;
        return d;
    }

    public static Dial createDial() {
        return new Dial();
    }

    public Dial number(String number, String sendDigits, String url, HttpMethod callbackMethod) {
        Number n = Number.createNumber(number, sendDigits, url, callbackMethod);
        this.elements.add(n);
        return this;
    }

    public Dial conference(String conferenceName, Boolean muted, Boolean beep, Boolean startConferenceOnEnter, Boolean endConferenceOnExit, Long maxParticipants, String waitUrl, HttpMethod waitMethod, Boolean hangupOnStar, String callbackUrl, HttpMethod callbackMethod, String waitSound, HttpMethod waitSoundMethod, String digitsMatch, Boolean stayAlone) {
        Conference c = Conference.createConference(conferenceName, muted, beep, startConferenceOnEnter, endConferenceOnExit, maxParticipants, waitUrl, waitMethod, hangupOnStar, callbackUrl, callbackMethod, waitSound, waitSoundMethod, digitsMatch, stayAlone);
        this.elements.add(c);
        return this;
    }

    public Dial conference(String conferenceName) {
        Conference c = Conference.createConference(conferenceName);
        this.elements.add(c);
        return this;
    }

    public Dial conference(ConferenceParameters params) {
        Conference c = Conference.createConference(params.getConferenceName(), params.getMuted(), params.getBeep(), params.getStartConferenceOnEnter(), params.getEndConferenceOnExit(), params.getMaxParticipants(), params.getWaitUrl(), params.getWaitMethod(), params.getHangupOnStar(), params.getCallbackUrl(), params.getCallbackMethod(), params.getWaitSound(), params.getWaitSoundMethod(), params.getDigitsMatch(), params.getStayAlone());
        this.elements.add(c);
        return this;
    }

    public Dial sip(String sipAddress, String sendDigits, String url, HttpMethod method) {
        Sip s = Sip.createSip(sipAddress, sendDigits, url, method);
        this.elements.add(s);
        return this;
    }

    public Dial sip(String sipAddress) {
        Sip s = Sip.createSip(sipAddress, null, null, null);
        this.elements.add(s);
        return this;
    }
}

