/*
 * Decompiled with CFR 0.152.
 */
package com.testmonitor.api;

import com.testmonitor.exceptions.NotFoundException;
import com.testmonitor.exceptions.ServerException;
import com.testmonitor.exceptions.UnprocessableEntityException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.json.JSONObject;

public class Connector {
    private final String token;
    private final String domain;
    private final String baseUrl;
    private final CloseableHttpClient httpClient;

    public Connector(String domain, String token) {
        this.token = token;
        this.domain = domain;
        this.baseUrl = this.baseUrl();
        this.httpClient = HttpClients.createDefault();
    }

    protected String baseUrl() {
        return "https://" + this.domain + "/api/v1/";
    }

    public JSONObject get(String uri) {
        HttpGet httpget = new HttpGet(this.baseUrl + uri.replace(" ", "%20"));
        return this.request((HttpUriRequestBase)httpget);
    }

    public JSONObject get(String uri, List<NameValuePair> params) {
        URIBuilder uriBuilder = null;
        try {
            uriBuilder = new URIBuilder(this.baseUrl + uri);
            uriBuilder.addParameters(params);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        HttpGet httpget = new HttpGet(uriBuilder.toString());
        httpget.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        return this.request((HttpUriRequestBase)httpget);
    }

    public JSONObject post(String uri, List<NameValuePair> params) {
        HttpPost httppost = new HttpPost(this.baseUrl + uri);
        httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        return this.request((HttpUriRequestBase)httppost);
    }

    public JSONObject put(String uri, List<NameValuePair> params) {
        HttpPut httpput = new HttpPut(this.baseUrl + uri);
        httpput.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        return this.request((HttpUriRequestBase)httpput);
    }

    public JSONObject postAttachment(String uri, File file) {
        HttpPost post = new HttpPost(this.baseUrl + uri);
        FileBody fileBody = new FileBody(file, ContentType.DEFAULT_BINARY);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.EXTENDED);
        builder.addPart("file", (ContentBody)fileBody);
        HttpEntity entity = builder.build();
        post.setEntity(entity);
        return this.request((HttpUriRequestBase)post);
    }

    public JSONObject request(HttpUriRequestBase httpUriRequestBase) {
        httpUriRequestBase.setHeader("Authorization", (Object)("Bearer " + this.token));
        httpUriRequestBase.setHeader("Accept", (Object)"application/json");
        HttpClientResponseHandler<String> responseHandler = new HttpClientResponseHandler<String>(){

            public String handleResponse(ClassicHttpResponse response) throws IOException, ParseException {
                int status = response.getCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    try {
                        return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                    }
                    catch (ParseException ex) {
                        throw new ClientProtocolException((Throwable)ex);
                    }
                }
                if (status == 500) {
                    throw new ServerException(status, EntityUtils.toString((HttpEntity)response.getEntity()));
                }
                if (status == 422) {
                    throw new UnprocessableEntityException(status, EntityUtils.toString((HttpEntity)response.getEntity()));
                }
                if (status == 404) {
                    throw new NotFoundException(status, EntityUtils.toString((HttpEntity)response.getEntity()));
                }
                throw new ClientProtocolException("Unexpected response status: " + status + "\n" + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        };
        try {
            String responseBody = (String)this.httpClient.execute((ClassicHttpRequest)httpUriRequestBase, (HttpClientResponseHandler)responseHandler);
            return new JSONObject(responseBody);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
            return new JSONObject();
        }
    }
}

