/*
 * Decompiled with CFR 0.152.
 */
package com.tmsps.ne4SpringBoot.base;

import com.alibaba.fastjson.JSON;
import com.tmsps.ne4SpringBoot.base.IBaseService;
import com.tmsps.ne4SpringBoot.base.Record;
import com.tmsps.ne4SpringBoot.exception.NEServiceException;
import com.tmsps.ne4SpringBoot.orm.ClassUtil;
import com.tmsps.ne4SpringBoot.orm.MySQLUtil;
import com.tmsps.ne4SpringBoot.orm.ORMUtil;
import com.tmsps.ne4SpringBoot.orm.model.DataModel;
import com.tmsps.ne4SpringBoot.page.Page;
import com.tmsps.ne4SpringBoot.utils.ChkUtil;
import com.tmsps.ne4SpringBoot.utils.GenerateUtil;
import com.tmsps.ne4SpringBoot.utils.StrUtil;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BaseMySQLService
implements IBaseService {
    @Autowired
    private JdbcTemplate jt;

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jt;
    }

    @Override
    public int saveObj(DataModel model) {
        log.debug("save the model" + model.toJsonString());
        if (ChkUtil.isNull((Object)model)) {
            log.error("\u4fdd\u5b58\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            throw new NEServiceException("\u4fdd\u5b58\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Field idField = ClassUtil.getIdField(model.getClass());
        Object idVal = ClassUtil.getClassVal(idField, model);
        if (ChkUtil.isNull(idVal) && idField.getType() == String.class) {
            idVal = GenerateUtil.getBase58ID();
            ClassUtil.setClassVal(idField, model, idVal);
        }
        List<Object> vals = ClassUtil.getValuesPar(model);
        String sql = MySQLUtil.getInsSQL(model.getClass());
        log.debug(sql);
        return this.jt.update(sql, vals.toArray());
    }

    @Override
    public int saveObj(DataModel model, boolean sync) {
        log.debug("save the model" + model.toJsonString());
        if (sync) {
            int flag = this.saveObj(model);
            model = this.findObjById(model.getPK(), model.getClass());
            return flag;
        }
        return this.saveObj(model);
    }

    @Override
    public int save(String tableName, Record record) {
        String insSQL = MySQLUtil.getInsSQL(record, tableName);
        if (!StrUtil.notBlank(insSQL)) {
            return 0;
        }
        return this.jt.update(insSQL, record.getValues().toArray());
    }

    @Override
    @Transactional
    public void saveObjs(List<DataModel> objs) {
        if (ChkUtil.listIsNull(objs)) {
            log.error("\u4fdd\u5b58\u7684\u5bf9\u8c61\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
            throw new NEServiceException("\u4fdd\u5b58\u7684\u5bf9\u8c61\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        objs.forEach(model -> this.saveObj((DataModel)model));
    }

    @Override
    public <T extends DataModel> T findObjById(Object idVal, final Class<? extends DataModel> clazz) {
        if (ChkUtil.isNull(idVal)) {
            log.warn("\u4e3b\u952e\u4e3anull,\u65e0\u6cd5\u67e5\u8be2,\u8fd4\u56denull");
            return null;
        }
        String sql = MySQLUtil.getSelectSQL(clazz, false);
        log.debug(sql);
        return (T)((DataModel)this.jt.query(sql, new Object[]{idVal}, new ResultSetExtractor<T>(){

            public T extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    Object obj = MySQLUtil.fillPojoByResultSet(rs, clazz);
                    return obj;
                }
                return null;
            }
        }));
    }

    @Override
    public <T extends DataModel> T findById(Object idVal, Class<? extends DataModel> clazz) {
        return this.findById(idVal, clazz);
    }

    @Override
    public Map<String, Object> findById(String tableName, String pkName, String pkVal) {
        List list = this.jt.queryForList(MySQLUtil.getSelectByIdSQL(tableName, pkName), new Object[]{pkVal});
        return list.size() == 1 ? (Map)list.get(0) : null;
    }

    @Override
    public Map<String, Object> findById(String tableName, String pkVal) {
        return this.jt.queryForMap(MySQLUtil.getSelectByIdSQL(tableName), new Object[]{pkVal});
    }

    @Override
    public List<Map<String, Object>> findList(String sql, Object[] vals) {
        log.debug("{},{}", (Object)sql, (Object)JSON.toJSONString((Object)vals));
        return this.jt.queryForList(sql, vals);
    }

    @Override
    public Map<String, Object> findObj(String sql, Object[] vals) {
        log.debug("{},{}", (Object)sql, (Object)JSON.toJSONString((Object)vals));
        List<Map<String, Object>> list = this.findList(sql, vals);
        if (ChkUtil.listIsNotNull(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Map<String, Object> findObj(String sql) {
        List<Map<String, Object>> list = this.findList(sql);
        if (ChkUtil.listIsNotNull(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T extends DataModel> T findObj(String sql, Class<? extends DataModel> clazz) {
        List<Map<String, Object>> list = this.findList(sql);
        if (ChkUtil.listIsNotNull(list)) {
            return ORMUtil.fillMapToBean(clazz, list.get(0));
        }
        return null;
    }

    @Override
    public <T extends DataModel> T findForObj(String sql, Class<? extends DataModel> clasz) {
        return this.findObj(sql, clasz);
    }

    @Override
    public List<Map<String, Object>> findList(String sql) {
        log.debug(sql);
        return this.jt.queryForList(sql);
    }

    @Override
    public <T extends DataModel> T findObj(String sql, Object[] vals, Class<? extends DataModel> modelClass) {
        return ORMUtil.fillMapToBean(modelClass, this.findObj(sql, vals));
    }

    @Override
    public int deleteObjById(String id, Class<? extends DataModel> clazz) {
        String sql = MySQLUtil.getDelRealSQL(clazz);
        return this.jt.update(sql, new Object[]{id});
    }

    @Override
    public int deleteByID(String pkColumn, String id, String tableName) {
        return this.jt.update(MySQLUtil.getDelRealSQL(tableName, pkColumn), new Object[]{id});
    }

    @Override
    public int updateObj(DataModel obj) {
        if (ChkUtil.isNull((Object)obj)) {
            log.error("\u4fee\u6539\u5931\u8d25\uff01\u5bf9\u8c61\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            return 0;
        }
        String sql = MySQLUtil.getUpdateSQL(obj.getClass());
        log.debug(sql);
        final List<Object> vals = ClassUtil.getValuesPar(obj);
        return this.jt.update(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement pstmt) throws SQLException {
                for (int i = 1; i < vals.size(); ++i) {
                    pstmt.setObject(i, vals.get(i));
                }
                pstmt.setObject(vals.size(), vals.get(0));
            }
        });
    }

    @Override
    public int updateChangeObj(DataModel obj) {
        return this.updateTemplateObj(obj);
    }

    @Override
    public int updateTemplateObj(DataModel obj) {
        if (ChkUtil.isNull((Object)obj)) {
            log.error("\u4fee\u6539\u5931\u8d25\uff01\u5bf9\u8c61\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            return 0;
        }
        String sql = MySQLUtil.getChangeUpdateSQL(obj);
        Map<Object, Object> clsky = ClassUtil.getClassKeyValNotNull(obj);
        Object[] objs = new Object[clsky.size()];
        int i = 0;
        for (Map.Entry<Object, Object> entry : clsky.entrySet()) {
            objs[i++] = entry.getValue();
        }
        log.debug(sql);
        return this.jt.update(sql, objs);
    }

    @Override
    public List<Map<String, Object>> findList(String sql, String sql_cnt, Object[] vals, Page page) {
        log.debug("{},{}", (Object)sql, (Object)sql_cnt);
        log.debug("{},{}", (Object)JSON.toJSONString((Object)vals), (Object)JSON.toJSONString((Object)page));
        List ret = null;
        int cnt = (Integer)this.jt.queryForObject(sql_cnt, vals, Integer.class);
        page.setTotalRow(cnt);
        page.setTotalPage((page.getTotalRow() - 1) / page.getPageSize() + 1);
        if (page.getPageNumber() > page.getTotalPage()) {
            page.setPageNumber(page.getTotalPage());
        }
        if (page.getPageNumber() <= 0) {
            page.setPageNumber(1);
        }
        sql = sql + " limit :start,:pageSize";
        sql = sql.replace(":start", page.getPageSize() * (page.getPageNumber() - 1) + "");
        sql = sql.replace(":pageSize", page.getPageSize() + "");
        ret = this.jt.queryForList(sql, vals);
        return ret;
    }

    @Override
    public List<Map<String, Object>> findList(String sql, Object[] vals, Page page) {
        String sql_cnt = MySQLUtil.getCntSql(sql);
        return this.findList(sql, sql_cnt, vals, page);
    }

    @Override
    public List<Map<String, Object>> findList(String sql, Page page) {
        return this.findList(sql, null, page);
    }

    @Override
    public int updObj(Class<?> clazz, Map<String, Object> parm, Map<String, Object> whereparm) {
        StringBuffer sb = new StringBuffer(" UPDATE ");
        sb.append(" " + ClassUtil.getClassName(clazz) + " ");
        sb.append(" SET ");
        ArrayList<Object> cxparm = new ArrayList<Object>();
        int i = 0;
        for (String key : parm.keySet()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(" " + key + " = ? ");
            ++i;
            cxparm.add(parm.get(key));
        }
        sb.append(" WHERE 1=1 ");
        if (ChkUtil.isNotNull(whereparm)) {
            for (String key : whereparm.keySet()) {
                sb.append(" AND " + key + " = ?  ");
                cxparm.add(whereparm.get(key));
            }
        }
        return this.jt.update(sb.toString(), cxparm.toArray());
    }

    @Override
    public Map<String, Object> getMap(String key, Object val) {
        return this.getMap(new String[]{key}, new Object[]{val});
    }

    @Override
    public Map<String, List<Object>> getSearchMap() {
        HashMap<String, List<Object>> cxparms = new HashMap<String, List<Object>>();
        cxparms.put("cname", new ArrayList());
        cxparms.put("cwhere", new ArrayList());
        cxparms.put("cval", new ArrayList());
        return cxparms;
    }

    @Override
    public Map<String, Object> getMap(String[] key, Object[] val) {
        HashMap<String, Object> mapobj = new HashMap<String, Object>();
        for (int i = 0; i < key.length; ++i) {
            mapobj.put(key[i], val[i]);
        }
        return mapobj;
    }

    @Override
    public Page pageinate(int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        if (pageNumber < 1 || pageSize < 1) {
            log.error("\u5f53\u524d\u9875\u9762\u9875\u6570\u548c\u9875\u9762\u8bb0\u5f55\u5c55\u793a\u6761\u6570\u4e0d\u80fd\u5c0f\u4e8e1");
            return new Page(pageNumber, pageSize);
        }
        long totalRow = 0L;
        int totalPage = 0;
        if (!StrUtil.notNull(paras)) {
            return this.pageinate(pageNumber, pageSize, select, sqlExceptSelect);
        }
        totalRow = (Long)this.jt.queryForObject("SELECT COUNT(1) " + sqlExceptSelect, paras, Long.class);
        totalPage = totalRow % (long)pageSize == 0L ? (int)(totalRow / (long)pageSize) : (int)(totalRow / (long)pageSize) + 1;
        log.debug("The TotalPage is :" + totalPage);
        String sql = MySQLUtil.getPageSQL(select, sqlExceptSelect);
        log.debug("SQL: " + sql);
        pageNumber = pageNumber >= totalPage ? totalPage : pageNumber;
        ArrayList<Object> objs = new ArrayList<Object>(Arrays.asList(paras));
        objs.add((pageNumber - 1) * pageSize < 0 ? 0 : (pageNumber - 1) * pageSize);
        objs.add(pageSize);
        List result = this.jt.queryForList(sql, objs.toArray());
        return new Page(result, pageNumber, pageSize, totalPage, ((Number)totalRow).intValue());
    }

    @Override
    public Page pageinate(int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        if (pageNumber < 1 || pageSize < 1) {
            log.error("\u5f53\u524d\u9875\u9762\u9875\u6570\u548c\u9875\u9762\u8bb0\u5f55\u5c55\u793a\u6761\u6570\u4e0d\u80fd\u5c0f\u4e8e1");
            return new Page(pageNumber, pageSize);
        }
        long totalRow = 0L;
        int totalPage = 0;
        totalRow = (Long)this.jt.queryForObject("SELECT COUNT(1) " + sqlExceptSelect, Long.class);
        totalPage = totalRow % (long)pageSize == 0L ? (int)(totalRow / (long)pageSize) : (int)(totalRow / (long)pageSize) + 1;
        log.debug("The TotalPage is :" + totalPage);
        String sql = MySQLUtil.getPageSQL(select, sqlExceptSelect);
        log.debug("SQL: {}", (Object)sql);
        pageNumber = pageNumber >= totalPage ? totalPage : pageNumber;
        List result = this.jt.queryForList(sql, new Object[]{(pageNumber - 1) * pageSize < 0 ? 0 : (pageNumber - 1) * pageSize, pageSize});
        return new Page(result, pageNumber, pageSize, totalPage, ((Number)totalRow).intValue());
    }
}

