/*
 * Decompiled with CFR 0.152.
 */
package com.tmsps.ne4SpringBoot.orm;

import com.tmsps.ne4SpringBoot.annotation.PK;
import com.tmsps.ne4SpringBoot.base.Record;
import com.tmsps.ne4SpringBoot.orm.ClassUtil;
import com.tmsps.ne4SpringBoot.orm.model.DataModel;
import com.tmsps.ne4SpringBoot.utils.StrUtil;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLUtil {
    static Logger log = LoggerFactory.getLogger(MySQLUtil.class);

    public static String getInsSQL(Class<?> clazz) {
        int i = 0;
        StringBuilder sb = new StringBuilder("insert into ");
        sb.append(ClassUtil.getClassName(clazz)).append("(");
        List<String> names = ClassUtil.getPropertyName(clazz);
        for (i = 0; i < names.size() - 1; ++i) {
            sb.append('`').append(names.get(i)).append("`,");
        }
        sb.append('`').append(names.get(names.size() - 1)).append('`');
        sb.append(") values (");
        for (i = 0; i < names.size() - 1; ++i) {
            sb.append("? , ");
        }
        sb.append("?)");
        log.debug(sb.toString());
        return sb.toString();
    }

    public static String getInsSQL(Record record, String tableName) {
        List<String> columnName = record.getColumnnName();
        if (columnName.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder("insert into ").append(tableName).append(" (");
        for (String column : columnName) {
            sb.append(column).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(") values (");
        for (int i = 0; i < columnName.size(); ++i) {
            sb.append("?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        log.debug(sb.toString());
        return sb.toString();
    }

    public static String getUpdateSQL(Class<?> clazz) {
        StringBuilder sb = new StringBuilder("update ");
        sb.append(ClassUtil.getClassName(clazz)).append(" set ");
        List<Field> names = ClassUtil.getClassFields(clazz);
        for (Field name : names) {
            if (name.isAnnotationPresent(PK.class)) continue;
            sb.append('`').append(name.getName() + "`= ?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" where ");
        sb.append(ClassUtil.getIdField(clazz).getName()).append(" = ?");
        log.debug(sb.toString());
        return sb.toString();
    }

    public static String getChangeUpdateSQL(Object obj) {
        StringBuilder sb = new StringBuilder("update ");
        String idFileld = ClassUtil.getIdField(obj.getClass()).getName();
        sb.append(ClassUtil.getClassName(obj.getClass())).append(" set ");
        Map<Object, Object> beanKeyVals = ClassUtil.getClassKeyValNotNull(obj);
        for (Map.Entry<Object, Object> entry : beanKeyVals.entrySet()) {
            if (idFileld.equals(entry.getKey())) continue;
            sb.append('`').append(entry.getKey() + "`= ?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" where ");
        sb.append(ClassUtil.getIdField(obj.getClass()).getName()).append(" = ?");
        log.debug(sb.toString());
        return sb.toString();
    }

    public static String getDelRealSQL(Class<?> clazz) {
        StringBuilder sb = new StringBuilder("delete from  ");
        sb.append(ClassUtil.getClassName(clazz)).append(" where ");
        Field id = ClassUtil.getIdField(clazz);
        sb.append(id.getName()).append(" = ?");
        log.debug(sb.toString());
        return sb.toString();
    }

    public static String getDelRealSQL(String tableName, String pkColumn) {
        StringBuilder sb = new StringBuilder("delete from ");
        sb.append(tableName).append(" where ");
        sb.append(pkColumn).append(" = ?");
        log.debug(sb.toString());
        return sb.toString();
    }

    public static String getSelectSQL(Class<?> clazz, boolean status) {
        StringBuilder sb = new StringBuilder("select * from  ");
        sb.append(ClassUtil.getClassName(clazz)).append(" where ");
        Field id = ClassUtil.getIdField(clazz);
        sb.append(id.getName()).append(" = ?");
        if (status) {
            sb.append(" and status = 0");
        }
        log.debug(sb.toString());
        return sb.toString();
    }

    public static String getSelectByIdSQL(String tableName, String pkName) {
        if (StrUtil.isBlank(pkName)) {
            return MySQLUtil.getSelectByIdSQL(tableName);
        }
        if (StrUtil.notBlank(tableName)) {
            StringBuilder sb = new StringBuilder("select * from ").append(tableName).append(" t");
            sb.append(" where t.").append(pkName).append(" = ?");
            log.debug(sb.toString());
            return sb.toString();
        }
        log.error("tableName and pkName is not null !!!");
        return null;
    }

    public static String getSelectByIdSQL(String tableName) {
        if (StrUtil.notBlank(tableName)) {
            StringBuilder sb = new StringBuilder("select * from ").append(tableName).append(" t");
            sb.append(" where t._id = ?");
            log.debug(sb.toString());
            return sb.toString();
        }
        log.error("tableName is not null !!!");
        return null;
    }

    public static String getCntSql(String sql) {
        if (sql == null) {
            return null;
        }
        StringBuilder sizeSql = new StringBuilder("SELECT COUNT(1) ");
        sizeSql.append(sql.substring(sql.toUpperCase().lastIndexOf("FROM")));
        log.debug(sizeSql.toString());
        return sizeSql.toString();
    }

    public static <T extends DataModel> T fillPojoByResultSet(ResultSet rs, Class<T> clazz) {
        try {
            DataModel obj = (DataModel)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            List<Field> fs = ClassUtil.getClassFields(clazz);
            for (Field field : fs) {
                Object val = rs.getObject(field.getName());
                ClassUtil.setClassVal(field, obj, val);
            }
            return (T)obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPageSQL(String select, String sqlExceptSelect) {
        StringBuilder sb = new StringBuilder(select);
        sb.append(" ").append(sqlExceptSelect);
        sb.append(" ").append("LIMIT ?,?");
        return sb.toString();
    }
}

