/*
 * Decompiled with CFR 0.152.
 */
package com.tmsps.ne4SpringBoot.utils.generator;

import com.tmsps.ne4SpringBoot.utils.generator.TableMeta;
import java.util.Map;
import org.springframework.util.StringUtils;

public class BeanGenerator {
    protected String packageTemplate = "package %s;\r\n\r\n";
    protected String importNotMapTemplate = "import com.tmsps.ne4SpringBoot.annotation.NotMap;\r\n";
    protected String importPKTemplate = "import com.tmsps.ne4SpringBoot.annotation.PK;\r\n";
    protected String importTableTemplate = "import com.tmsps.ne4SpringBoot.annotation.Table;\r\n";
    protected String importModelTemplate = "import com.tmsps.ne4SpringBoot.orm.model.DataModel;\r\n";
    protected String commentTemplate = "\r\n/**\r\n * Generated by ne4SpringBoot \r\n*/\r\n\r\n";
    protected String classTableTemplate = "@Table(TableName=\"%s\")\r\n";
    protected String classDefineTemplate = "public class %s extends DataModel {\r\n";
    protected String serialVersionUIDTemplate = "\r\n\t@NotMap\r\n\tprivate static final long serialVersionUID = 1L;\r\n";
    protected String pkTemplate = "\t@PK\r\n";
    protected String attributeTemplate = "\tprivate %s %s;\r\n";
    protected String setterTemplate = "\tpublic void set%s(%s %s) {%n \t\tthis.%s = %s;\r\n\t}\r\n\r\n";
    protected String getterTemplate = "\tpublic %s get%s() {%n\t\treturn %s;%n\t}\r\n\r\n";
    protected String endTemplate = "}";
    public String beanPackageName;

    public BeanGenerator(String beanPackageName) {
        this.beanPackageName = beanPackageName;
    }

    public void getBeanContent(TableMeta tableMeta) {
        String aType;
        String aName;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(this.packageTemplate, this.beanPackageName));
        sb.append(this.importNotMapTemplate);
        if (!tableMeta.idName.equals("") && tableMeta.idName.length() > 0) {
            sb.append(this.importPKTemplate);
        }
        sb.append(this.importTableTemplate);
        sb.append(this.importModelTemplate);
        sb.append(this.commentTemplate);
        sb.append(String.format(this.classTableTemplate, tableMeta.tableName));
        sb.append(String.format(this.classDefineTemplate, tableMeta.tableName));
        sb.append(this.serialVersionUIDTemplate);
        for (Map<String, String> colum : tableMeta.columInfo) {
            aName = colum.get("columnName");
            aType = colum.get("typeStr");
            if (!tableMeta.idName.equals("") && tableMeta.idName.equals(aName)) {
                sb.append(this.pkTemplate);
                sb.append(String.format(this.attributeTemplate, aType, aName));
                continue;
            }
            sb.append(String.format(this.attributeTemplate, aType, aName));
        }
        for (Map<String, String> colum : tableMeta.columInfo) {
            aName = colum.get("columnName");
            aType = colum.get("typeStr");
            sb.append(String.format(this.setterTemplate, StringUtils.capitalize((String)aName), aType, aName, aName, aName));
        }
        for (Map<String, String> colum : tableMeta.columInfo) {
            aName = colum.get("columnName");
            aType = colum.get("typeStr");
            sb.append(String.format(this.getterTemplate, aType, StringUtils.capitalize((String)aName), aName));
        }
        sb.append(this.endTemplate);
        tableMeta.beanContent = sb.toString();
    }
}

