/*
 * Decompiled with CFR 0.152.
 */
package com.tmsps.ne4SpringBoot.utils.generator;

import com.tmsps.ne4SpringBoot.utils.ChkUtil;
import com.tmsps.ne4SpringBoot.utils.generator.TableMeta;
import com.tmsps.ne4SpringBoot.utils.generator.TypeMapping;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GeUtils {
    protected TypeMapping typeMapping = new TypeMapping();
    protected Connection conn;

    public GeUtils(Connection conn) {
        this.conn = conn;
    }

    public String getPath() {
        String path = null;
        try {
            path = GeUtils.class.getResource("/").toURI().getPath();
            path = new File(path).getParentFile().getParentFile().getCanonicalPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }

    public Connection getConnection() {
        if (ChkUtil.isNull((Object)this.conn)) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u94fe\u63a5\u4e3a\u7a7a");
        }
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wirtToFile(TableMeta tableMeta, String beanOutputDir) throws IOException {
        File dir = new File(beanOutputDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String target = beanOutputDir + File.separator + tableMeta.tableName + ".java";
        try (FileWriter fw = new FileWriter(target);){
            fw.write(tableMeta.beanContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableMeta> getTableMetas() {
        ArrayList<TableMeta> tablesMeta = new ArrayList<TableMeta>();
        Connection conn = this.conn;
        DatabaseMetaData dbMeta = null;
        ResultSet rest = null;
        ResultSetMetaData rsmd = null;
        String sql = "select * from %s where 1=2";
        try {
            dbMeta = conn.getMetaData();
            rest = dbMeta.getTables(null, null, null, new String[]{"TABLE", "VIEW"});
            while (rest.next()) {
                String tableName;
                TableMeta tm = new TableMeta();
                tm.tableName = tableName = rest.getString("TABLE_NAME");
                ResultSet rs2 = dbMeta.getPrimaryKeys(null, null, tableName);
                while (rs2.next()) {
                    tm.idName = rs2.getString(4);
                }
                rs2.close();
                Statement stm = conn.createStatement();
                ResultSet rs = stm.executeQuery(String.format(sql, tableName));
                rsmd = rs.getMetaData();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    HashMap<String, String> column = new HashMap<String, String>();
                    String columnName = rsmd.getColumnName(i);
                    String colClassName = rsmd.getColumnClassName(i);
                    String typeStr = this.typeMapping.getType(colClassName);
                    column.put("columnName", columnName);
                    column.put("columnType", colClassName);
                    column.put("typeStr", typeStr);
                    tm.columInfo.add(column);
                }
                rs.close();
                stm.close();
                tablesMeta.add(tm);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rest != null) {
                    rest.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return tablesMeta;
    }
}

