/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.dashboard.entities.Dashboard;
import com.trigyn.jws.dashboard.entities.DashboardRoleAssociation;
import com.trigyn.jws.dashboard.service.DashletService;
import com.trigyn.jws.dashboard.vo.DashboardVO;
import com.trigyn.jws.dashboard.vo.DashletVO;
import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.dbutils.spi.IUserDetailsService;
import com.trigyn.jws.templating.service.DBTemplatingService;
import com.trigyn.jws.templating.utils.TemplatingUtils;
import com.trigyn.jws.templating.vo.TemplateVO;
import com.trigyn.jws.webstarter.service.DashboardCrudService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
public class DashboardCrudController {
    private static final Logger logger = LogManager.getLogger(DashboardCrudController.class);
    @Autowired
    private DBTemplatingService templatingService = null;
    @Autowired
    private TemplatingUtils templateEngine = null;
    @Autowired
    private DashboardCrudService dashboardCrudService = null;
    @Autowired
    private DashletService dashletServive = null;
    @Autowired
    private IUserDetailsService userDetails = null;
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;

    @GetMapping(value={"/dlm"}, produces={"text/html"})
    public String dashletMasterListing() throws Exception {
        TemplateVO templateVO = this.templatingService.getTemplateByName("dashlet-listing");
        HashMap<String, String> modelMap = new HashMap<String, String>();
        String environment = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "profile");
        modelMap.put("environment", environment);
        return this.templateEngine.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), modelMap);
    }

    @GetMapping(value={"/dbm"}, produces={"text/html"})
    public String dashboardMasterListing() throws Exception {
        TemplateVO templateVO = this.templatingService.getTemplateByName("dashboard-listing");
        return this.templateEngine.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), new HashMap());
    }

    @PostMapping(value={"/aedb"}, produces={"text/html"})
    public String addEditDashboardDetails(@RequestParam(value="dashboard-id") String dashboardId) throws Exception {
        HashMap<String, Map<String, String>> templateMap = new HashMap<String, Map<String, String>>();
        Dashboard dashboard = new Dashboard();
        if (dashboardId != null && !dashboardId.isEmpty() && !dashboardId.equals("")) {
            dashboard = this.dashboardCrudService.findDashboardByDashboardId(dashboardId);
            List<DashboardRoleAssociation> dashletRoleAssociation = this.dashboardCrudService.findDashboardRoleByDashboardId(dashboardId);
            if (!CollectionUtils.isEmpty(dashletRoleAssociation)) {
                dashboard.setDashboardRoles(dashletRoleAssociation);
            }
        } else {
            dashboard.setDashboardRoles(new ArrayList());
        }
        Map<String, String> contextDetails = this.dashboardCrudService.findContextDetails();
        templateMap.put("contextDetails", contextDetails);
        templateMap.put("dashboard", (Map<String, String>)dashboard);
        TemplateVO templateVO = this.templatingService.getTemplateByName("dashboard-manage-details");
        return this.templateEngine.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), templateMap);
    }

    @PostMapping(value={"/sdb"}, produces={"application/json"})
    public ResponseEntity<Boolean> saveDashboard(@RequestBody DashboardVO dashboardVO, @RequestHeader(value="user-id", required=true) String userId) throws Exception {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        try {
            this.dashboardCrudService.saveDashboardDetails(dashboardVO, userId);
            return new ResponseEntity((Object)true, (MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)false, (MultiValueMap)httpHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/aedl"}, produces={"text/html"})
    public String createEditDashlet(@RequestParam(value="dashlet-id") String dashletId) throws Exception {
        HashMap<String, Object> templateMap = new HashMap<String, Object>();
        DashletVO dashletVO = this.dashletServive.getDashletDetailsById(dashletId);
        Map componentsMap = this.dashletServive.findComponentTypes("COMPONENT_TYPE");
        Map<String, String> contextDetailsMap = this.dashboardCrudService.findContextDetails();
        templateMap.put("dashletVO", dashletVO);
        templateMap.put("componentMap", componentsMap);
        templateMap.put("contextDetailsMap", contextDetailsMap);
        TemplateVO templateVO = this.templatingService.getTemplateByName("dashlet-manage-details");
        return this.templateEngine.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), templateMap);
    }

    @PostMapping(value={"/sdl"}, produces={"application/json"})
    public ResponseEntity<Boolean> saveDashlet(@RequestHeader(value="user-id", required=true) String userId, @RequestBody DashletVO dashletVO) throws Exception {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        try {
            this.dashboardCrudService.saveDashlet(userId, dashletVO);
            return new ResponseEntity((Object)true, (MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)false, (MultiValueMap)httpHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/ddl"})
    public void downloadAllDashletsToLocalDirectory(HttpSession session, HttpServletRequest request) throws Exception {
        this.dashboardCrudService.downloadDashlets();
    }

    @PostMapping(value={"/udl"})
    public void uploadAllDashletsToDB(HttpSession session, HttpServletRequest request) throws Exception {
        this.dashboardCrudService.uploadDashlets();
    }
}

