/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.menu.service.ModuleService;
import com.trigyn.jws.menu.vo.ModuleDetailsVO;
import com.trigyn.jws.templating.service.DBTemplatingService;
import com.trigyn.jws.templating.utils.TemplatingUtils;
import com.trigyn.jws.templating.vo.TemplateVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
public class MenuCrudController {
    private static final Logger logger = LogManager.getLogger(MenuCrudController.class);
    @Autowired
    private ModuleService moduleService = null;
    @Autowired
    private DBTemplatingService templateService = null;
    @Autowired
    private TemplatingUtils templateEngine = null;

    @PostMapping(value={"/aem"}, produces={"text/html"})
    public String addEditModule(@RequestParam(value="module-id") String moduleId) throws Exception {
        HashMap<String, Object> templateMap = new HashMap<String, Object>();
        ModuleDetailsVO moduleDetailsVO = this.moduleService.getModuleDetails(moduleId);
        List moduleListingVOList = this.moduleService.getAllModules(moduleId);
        List moduleTargetLookupVOList = this.moduleService.getAllModuleLookUp();
        templateMap.put("moduleDetailsVO", moduleDetailsVO);
        templateMap.put("moduleListingVOList", moduleListingVOList);
        templateMap.put("moduleTargetLookupVOList", moduleTargetLookupVOList);
        TemplateVO templateVO = this.templateService.getTemplateByName("addEditModule");
        return this.templateEngine.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), templateMap);
    }

    @GetMapping(value={"/ltlm"}, produces={"application/json"})
    public List<Map<String, Object>> getTargetTypes(@RequestHeader(value="target-lookup-id", required=true) Integer targetTypeId) throws Exception {
        return this.moduleService.getTargetTypes(targetTypeId);
    }

    @GetMapping(value={"/cms"})
    @ResponseBody
    public String checkSequenceNumber(@RequestHeader(name="parent-module-id", required=false) String parentModuleId, @RequestHeader(name="sequence", required=true) Integer sequence) throws Exception {
        try {
            return this.moduleService.getModuleIdBySequence(parentModuleId, sequence);
        }
        catch (Exception e) {
            return "Error occurred";
        }
    }

    @GetMapping(value={"/cmurl"})
    @ResponseBody
    public String checkModuleURL(@RequestHeader(name="module-url", required=false) String moduleURL) throws Exception {
        return this.moduleService.getModuleIdByURL(moduleURL);
    }

    @PostMapping(value={"/sm"}, produces={"application/json"})
    public ResponseEntity<String> saveModule(@RequestBody ModuleDetailsVO moduleDetailsVO) throws Exception {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        try {
            String moduleId = this.moduleService.saveModuleDetails(moduleDetailsVO);
            return new ResponseEntity((Object)moduleId, (MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (MultiValueMap)httpHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

