/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.utils;

import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.dbutils.utils.FileUtilities;
import com.trigyn.jws.dynarest.dao.JwsDynarestDAO;
import com.trigyn.jws.dynarest.entities.JwsDynamicRestDaoDetail;
import com.trigyn.jws.dynarest.entities.JwsDynamicRestDetail;
import com.trigyn.jws.webstarter.utils.DownloadUploadModule;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DynaRestmodule
implements DownloadUploadModule {
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;
    @Autowired
    private JwsDynarestDAO dynarestDAO = null;
    @Autowired
    private FileUtilities fileUtilities = null;

    @Override
    public void downloadCodeToLocal() throws Exception {
        List dynamicRestDetails = this.dynarestDAO.getAllDynamicRestDetails();
        String templateDirectory = "DynamicRest";
        String ftlCustomExtension = ".tgn";
        String serviceLogic = "serviceLogic";
        String saveQuery = "saveQuery-";
        Object folderLocation = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "template-storage-path");
        folderLocation = (String)folderLocation + File.separator + templateDirectory;
        for (JwsDynamicRestDetail currentDynamicRestDetail : dynamicRestDetails) {
            boolean isCheckSumChanged = false;
            String formName = currentDynamicRestDetail.getJwsMethodName();
            String formFolder = (String)folderLocation + File.separator + formName;
            if (!new File(formFolder).exists()) {
                File fileDirectory = new File(formFolder);
                fileDirectory.mkdirs();
            }
            String serviceLogicChecksum = this.fileUtilities.checkFileContents(serviceLogic, formFolder, currentDynamicRestDetail.getJwsServiceLogic(), currentDynamicRestDetail.getJwsServiceLogicChecksum(), ftlCustomExtension);
            if (serviceLogic != null) {
                isCheckSumChanged = true;
                currentDynamicRestDetail.setJwsServiceLogicChecksum(serviceLogicChecksum);
            }
            for (JwsDynamicRestDaoDetail daoDetail : currentDynamicRestDetail.getJwsDynamicRestDaoDetails()) {
                String sequence = saveQuery + daoDetail.getJwsQuerySequence();
                String checksum = this.fileUtilities.checkFileContents(sequence, formFolder, daoDetail.getJwsDaoQueryTemplate(), daoDetail.getChecksum(), ftlCustomExtension);
                if (checksum == null) continue;
                isCheckSumChanged = true;
                daoDetail.setChecksum(checksum);
            }
            if (!isCheckSumChanged) continue;
            this.dynarestDAO.saveJwsDynamicRestDetail(currentDynamicRestDetail);
        }
    }

    @Override
    public void uploadCodeToLocal() throws Exception {
        File[] directories;
        final String ftlCustomExtension = ".tgn";
        String templateDirectory = "DynamicRest";
        String serviceLogic = "serviceLogic";
        String saveQuery = "saveQuery-";
        Object folderLocation = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "template-storage-path");
        File directory = new File((String)(folderLocation = (String)folderLocation + File.separator + templateDirectory));
        if (!directory.exists()) {
            throw new Exception("No such directory present");
        }
        FilenameFilter textFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(ftlCustomExtension);
            }
        };
        for (File currentDirectory : directories = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File current, String name) {
                return new File(current, name).isDirectory();
            }
        })) {
            File[] directoryFiles;
            Integer filesPresent;
            String serviceLogicCheckSum = null;
            String currentDirectoryName = currentDirectory.getName();
            JwsDynamicRestDetail dynamicRestDetail = this.dynarestDAO.getDynamicRestDetailsByName(currentDirectoryName);
            if (dynamicRestDetail == null) {
                dynamicRestDetail = new JwsDynamicRestDetail();
                dynamicRestDetail.setJwsRequestTypeId(Integer.valueOf(2));
                dynamicRestDetail.setJwsResponseProducerTypeId(Integer.valueOf(7));
                dynamicRestDetail.setJwsRbacId(Integer.valueOf(1));
                dynamicRestDetail.setJwsPlatformId(Integer.valueOf(1));
                dynamicRestDetail.setJwsDynamicRestUrl("/test");
                dynamicRestDetail.setJwsMethodName(currentDirectoryName);
                dynamicRestDetail.setJwsMethodDescription("Uploaded from Local Directory");
            }
            if ((filesPresent = Integer.valueOf((directoryFiles = currentDirectory.listFiles(textFilter)).length)) >= 2) {
                File serviceLogicFile = new File(currentDirectory.getAbsolutePath() + File.separator + serviceLogic + ftlCustomExtension);
                if (!serviceLogicFile.exists()) {
                    throw new Exception("serviceLogic file is mandatory  for saving dynamic rest detail" + currentDirectoryName);
                }
                serviceLogicCheckSum = this.fileUtilities.generateFileChecksum(serviceLogicFile);
                if (!serviceLogicCheckSum.equalsIgnoreCase(dynamicRestDetail.getJwsServiceLogicChecksum())) {
                    dynamicRestDetail.setJwsServiceLogic(this.fileUtilities.readContentsOfFile(serviceLogicFile.getAbsolutePath()));
                    dynamicRestDetail.setJwsServiceLogicChecksum(serviceLogicCheckSum);
                }
                this.dynarestDAO.saveJwsDynamicRestDetail(dynamicRestDetail);
                if (dynamicRestDetail.getJwsDynamicRestDaoDetails() != null) {
                    this.dynarestDAO.deleteDAOQueries(dynamicRestDetail.getJwsDynamicRestId());
                }
                ArrayList<JwsDynamicRestDaoDetail> dynamicRestDaoDetails = new ArrayList<JwsDynamicRestDaoDetail>();
                int i = 0;
                for (File file : directoryFiles) {
                    Integer saveQueryFiles = filesPresent - 1;
                    if (saveQueryFiles >= 1) {
                        if (!file.getName().contains(saveQuery)) continue;
                        JwsDynamicRestDaoDetail daoDetail = new JwsDynamicRestDaoDetail();
                        File saveQueryFile = new File(currentDirectory.getAbsolutePath() + File.separator + saveQuery + ++i + ftlCustomExtension);
                        if (!saveQueryFile.exists()) {
                            throw new Exception("saveQuery file sequence is incorrect" + currentDirectoryName);
                        }
                        daoDetail.setJwsDynamicRestDetailId(dynamicRestDetail.getJwsDynamicRestId());
                        daoDetail.setJwsResultVariableName("test");
                        daoDetail.setChecksum(this.fileUtilities.generateFileChecksum(saveQueryFile));
                        daoDetail.setJwsQuerySequence(Integer.valueOf(i));
                        daoDetail.setJwsDaoQueryTemplate(this.fileUtilities.readContentsOfFile(saveQueryFile.getAbsolutePath()));
                        dynamicRestDaoDetails.add(daoDetail);
                        this.dynarestDAO.saveJwsDynamicRestDAO(daoDetail);
                        continue;
                    }
                    throw new Exception("saveQuery file is mandatory  for saving rest details" + currentDirectoryName);
                }
                continue;
            }
            throw new Exception("Invalid count of files for saving dynamic rest details" + currentDirectoryName);
        }
    }
}

