/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.utils;

import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.dbutils.utils.FileUtilities;
import com.trigyn.jws.dynamicform.dao.DynamicFormCrudDAO;
import com.trigyn.jws.dynamicform.dao.IDynamicFormQueriesRepository;
import com.trigyn.jws.dynamicform.entities.DynamicForm;
import com.trigyn.jws.dynamicform.entities.DynamicFormSaveQuery;
import com.trigyn.jws.webstarter.utils.DownloadUploadModule;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DynamicFormModule
implements DownloadUploadModule {
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;
    @Autowired
    private IDynamicFormQueriesRepository dynamicFormQueriesRepository = null;
    @Autowired
    private FileUtilities fileUtilities = null;
    @Autowired
    private DynamicFormCrudDAO dynamicFormDAO = null;

    @Override
    public void downloadCodeToLocal() throws Exception {
        List formList = this.dynamicFormDAO.getAllDynamicForms();
        String templateDirectory = "DynamicForm";
        String ftlCustomExtension = ".tgn";
        String selectQuery = "selectQuery";
        String htmlBody = "hmtlQuery";
        String saveQuery = "saveQuery-";
        Object folderLocation = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "template-storage-path");
        folderLocation = (String)folderLocation + File.separator + templateDirectory;
        for (DynamicForm dynamicForm : formList) {
            String htmlBodyCheckSum;
            String selectCheckSum;
            boolean isCheckSumChanged = false;
            String formName = dynamicForm.getFormName();
            String formFolder = (String)folderLocation + File.separator + formName;
            if (!new File(formFolder).exists()) {
                File fileDirectory = new File(formFolder);
                fileDirectory.mkdirs();
            }
            if ((selectCheckSum = this.fileUtilities.checkFileContents(selectQuery, formFolder, dynamicForm.getFormSelectQuery(), dynamicForm.getFormSelectChecksum(), ftlCustomExtension)) != null) {
                isCheckSumChanged = true;
                dynamicForm.setFormSelectChecksum(selectCheckSum);
            }
            if ((htmlBodyCheckSum = this.fileUtilities.checkFileContents(htmlBody, formFolder, dynamicForm.getFormBody(), dynamicForm.getFormBodyChecksum(), ftlCustomExtension)) != null) {
                isCheckSumChanged = true;
                dynamicForm.setFormBodyChecksum(htmlBodyCheckSum);
            }
            for (DynamicFormSaveQuery formSaveQuery : dynamicForm.getDynamicFormSaveQueries()) {
                String sequence = saveQuery + formSaveQuery.getSequence();
                String checksum = this.fileUtilities.checkFileContents(sequence, formFolder, formSaveQuery.getDynamicFormSaveQuery(), formSaveQuery.getChecksum(), ftlCustomExtension);
                if (checksum == null) continue;
                isCheckSumChanged = true;
                formSaveQuery.setChecksum(checksum);
            }
            if (!isCheckSumChanged) continue;
            this.dynamicFormDAO.saveDynamicFormData(dynamicForm);
        }
    }

    @Override
    public void uploadCodeToLocal() throws Exception {
        File[] directories;
        String user = "admin";
        final String ftlCustomExtension = ".tgn";
        String templateDirectory = "DynamicForm";
        String selectQuery = "selectQuery";
        String htmlBody = "hmtlQuery";
        String saveQuery = "saveQuery-";
        Object folderLocation = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "template-storage-path");
        File directory = new File((String)(folderLocation = (String)folderLocation + File.separator + templateDirectory));
        if (!directory.exists()) {
            throw new Exception("No such directory present");
        }
        FilenameFilter textFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(ftlCustomExtension);
            }
        };
        for (File currentDirectory : directories = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File current, String name) {
                return new File(current, name).isDirectory();
            }
        })) {
            ArrayList<DynamicFormSaveQuery> dynamicFormSaveQueries;
            File[] directoryFiles;
            Integer filesPresent;
            String selectCheckSum = null;
            String htmlCheckSum = null;
            String currentDirectoryName = currentDirectory.getName();
            DynamicForm dynamicForm = this.dynamicFormDAO.getFormDetailsByName(currentDirectoryName);
            if (dynamicForm == null) {
                dynamicForm = new DynamicForm();
                dynamicForm.setCreatedBy(user);
                dynamicForm.setCreatedDate(new Date());
                dynamicForm.setFormName(currentDirectoryName);
                dynamicForm.setFormDescription("Uploaded from Local Directory");
            }
            if ((filesPresent = Integer.valueOf((directoryFiles = currentDirectory.listFiles(textFilter)).length)) >= 3) {
                File selectFile = new File(currentDirectory.getAbsolutePath() + File.separator + selectQuery + ftlCustomExtension);
                File hmtlBodyFile = new File(currentDirectory.getAbsolutePath() + File.separator + htmlBody + ftlCustomExtension);
                if (!selectFile.exists() || !hmtlBodyFile.exists()) {
                    throw new Exception("selectQuery  file not and hmtlQueryfile are mandatory  for saving dynamic form" + currentDirectoryName);
                }
                selectCheckSum = this.fileUtilities.generateFileChecksum(selectFile);
                if (!selectCheckSum.equalsIgnoreCase(dynamicForm.getFormSelectChecksum())) {
                    dynamicForm.setFormSelectQuery(this.fileUtilities.readContentsOfFile(selectFile.getAbsolutePath()));
                    dynamicForm.setFormSelectChecksum(selectCheckSum);
                }
                if (!(htmlCheckSum = this.fileUtilities.generateFileChecksum(hmtlBodyFile)).equalsIgnoreCase(dynamicForm.getFormBodyChecksum())) {
                    dynamicForm.setFormBody(this.fileUtilities.readContentsOfFile(hmtlBodyFile.getAbsolutePath()));
                    dynamicForm.setFormBodyChecksum(htmlCheckSum);
                }
                this.dynamicFormDAO.saveDynamicFormData(dynamicForm);
                if (dynamicForm.getDynamicFormSaveQueries() != null) {
                    this.dynamicFormDAO.deleteFormQueries(dynamicForm.getFormId());
                }
                dynamicFormSaveQueries = new ArrayList<DynamicFormSaveQuery>();
                int i = 0;
                for (File file : directoryFiles) {
                    Integer saveQueryFiles = filesPresent - 2;
                    if (saveQueryFiles >= 1) {
                        if (!file.getName().contains(saveQuery)) continue;
                        DynamicFormSaveQuery formSaveQuery = new DynamicFormSaveQuery();
                        File saveQueryFile = new File(currentDirectory.getAbsolutePath() + File.separator + saveQuery + ++i + ftlCustomExtension);
                        if (saveQueryFile.exists()) {
                            formSaveQuery.setDynamicFormId(dynamicForm.getFormId());
                            formSaveQuery.setChecksum(this.fileUtilities.generateFileChecksum(saveQueryFile));
                            formSaveQuery.setSequence(Integer.valueOf(i));
                            formSaveQuery.setDynamicFormSaveQuery(this.fileUtilities.readContentsOfFile(saveQueryFile.getAbsolutePath()));
                            dynamicFormSaveQueries.add(formSaveQuery);
                            continue;
                        }
                        throw new Exception("saveQuery file sequence is incorrect" + currentDirectoryName);
                    }
                    throw new Exception("saveQuery file is mandatory  for saving dynamic form" + currentDirectoryName);
                }
            } else {
                throw new Exception("Invalid count of files for saving dynamic form" + currentDirectoryName);
            }
            this.dynamicFormQueriesRepository.saveAll(dynamicFormSaveQueries);
        }
    }
}

