/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.utils;

import com.trigyn.jws.dashboard.dao.DashletDAO;
import com.trigyn.jws.dashboard.entities.Dashlet;
import com.trigyn.jws.dashboard.repository.interfaces.IDashletRepository;
import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.dbutils.utils.FileUtilities;
import com.trigyn.jws.webstarter.utils.DownloadUploadModule;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DashletModule
implements DownloadUploadModule {
    @Autowired
    private DashletDAO dashletDAO = null;
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;
    @Autowired
    private FileUtilities fileUtilities = null;
    @Autowired
    private IDashletRepository iDashletRepository = null;

    @Override
    public void downloadCodeToLocal() throws Exception {
        List dashlets = this.dashletDAO.getAllDashlets();
        String ftlCustomExtension = ".tgn";
        String templateDirectory = "Dashlets";
        String selectQuery = "selectQuery";
        String htmlBody = "hmtlQuery";
        Object folderLocation = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "template-storage-path");
        folderLocation = (String)folderLocation + File.separator + templateDirectory;
        for (Dashlet dashlet : dashlets) {
            String dashletQueryCheckSum;
            String dashletBodySum;
            boolean isCheckSumChanged = false;
            String dashletName = dashlet.getDashletName();
            String formFolder = (String)folderLocation + File.separator + dashletName;
            if (!new File(formFolder).exists()) {
                File fileDirectory = new File(formFolder);
                fileDirectory.mkdirs();
            }
            if ((dashletBodySum = this.fileUtilities.checkFileContents(htmlBody, formFolder, dashlet.getDashletBody(), dashlet.getDashletBodyChecksum(), ftlCustomExtension)) != null) {
                isCheckSumChanged = true;
                dashlet.setDashletBodyChecksum(dashletBodySum);
            }
            if ((dashletQueryCheckSum = this.fileUtilities.checkFileContents(selectQuery, formFolder, dashlet.getDashletQuery(), dashlet.getDashletQueryChecksum(), ftlCustomExtension)) != null) {
                isCheckSumChanged = true;
                dashlet.setDashletQueryChecksum(dashletQueryCheckSum);
            }
            if (!isCheckSumChanged) continue;
            this.iDashletRepository.save((Object)dashlet);
        }
    }

    @Override
    public void uploadCodeToLocal() throws Exception {
        File[] directories;
        String user = "admin";
        final String ftlCustomExtension = ".tgn";
        String templateDirectory = "Dashlets";
        String selectQuery = "selectQuery";
        String htmlBody = "hmtlQuery";
        Object folderLocation = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "template-storage-path");
        File directory = new File((String)(folderLocation = (String)folderLocation + File.separator + templateDirectory));
        if (!directory.exists()) {
            throw new Exception("No such directory present");
        }
        FilenameFilter textFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(ftlCustomExtension);
            }
        };
        for (File currentDirectory : directories = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File current, String name) {
                return new File(current, name).isDirectory();
            }
        })) {
            File[] directoryFiles;
            Integer filesPresent;
            String selectCheckSum = null;
            String htmlCheckSum = null;
            String currentDirectoryName = currentDirectory.getName();
            Dashlet dashlet = this.dashletDAO.getDashletByName(currentDirectoryName);
            if (dashlet == null) {
                dashlet = new Dashlet();
                dashlet.setCreatedBy(user);
                dashlet.setCreatedDate(new Date());
                dashlet.setDashletName(currentDirectoryName);
                dashlet.setDashletTitle("Uploaded from Local Directory");
            }
            if ((filesPresent = Integer.valueOf((directoryFiles = currentDirectory.listFiles(textFilter)).length)) == 2) {
                File selectFile = new File(currentDirectory.getAbsolutePath() + File.separator + selectQuery + ftlCustomExtension);
                File hmtlBodyFile = new File(currentDirectory.getAbsolutePath() + File.separator + htmlBody + ftlCustomExtension);
                if (!selectFile.exists() || !hmtlBodyFile.exists()) {
                    throw new Exception("selectQuery  file not and hmtlQueryfile are mandatory  for saving dashlet" + currentDirectoryName);
                }
                selectCheckSum = this.fileUtilities.generateFileChecksum(selectFile);
                if (!selectCheckSum.equalsIgnoreCase(dashlet.getDashletQueryChecksum())) {
                    dashlet.setDashletQuery(this.fileUtilities.readContentsOfFile(selectFile.getAbsolutePath()));
                    dashlet.setDashletQueryChecksum(selectCheckSum);
                }
                if (!(htmlCheckSum = this.fileUtilities.generateFileChecksum(hmtlBodyFile)).equalsIgnoreCase(dashlet.getDashletBodyChecksum())) {
                    dashlet.setDashletBody(this.fileUtilities.readContentsOfFile(hmtlBodyFile.getAbsolutePath()));
                    dashlet.setDashletBodyChecksum(htmlCheckSum);
                }
            } else {
                throw new Exception("Invalid count of files for saving dashlet" + currentDirectoryName);
            }
            this.iDashletRepository.save((Object)dashlet);
        }
    }
}

