/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.templating.service.DBTemplatingService;
import com.trigyn.jws.templating.utils.TemplatingUtils;
import com.trigyn.jws.templating.vo.TemplateVO;
import com.trigyn.jws.webstarter.service.TemplateCrudService;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
public class TemplateCrudController {
    private static final Logger logger = LogManager.getLogger(TemplateCrudController.class);
    @Autowired
    private DBTemplatingService dbTemplatingService = null;
    @Autowired
    private DBTemplatingService templateService = null;
    @Autowired
    private TemplatingUtils templateEngine = null;
    @Autowired
    private TemplateCrudService templateCrudService = null;
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;

    @GetMapping(value={"/te"}, produces={"text/html"})
    public String templatePage() throws Exception {
        TemplateVO templateVO = this.templateService.getTemplateByName("template-listing");
        HashMap<String, String> modelMap = new HashMap<String, String>();
        String environment = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "profile");
        modelMap.put("environment", environment);
        return this.templateEngine.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), modelMap);
    }

    @GetMapping(value={"/aet"}, produces={"text/html"})
    public String velocityTemplateEditor(HttpServletRequest request) throws Exception {
        TemplateVO templateVO = this.dbTemplatingService.getTemplateByName("template-manage-details");
        String templateId = request.getParameter("vmMasterId");
        HashMap<String, TemplateVO> vmTemplateData = new HashMap<String, TemplateVO>();
        if (templateId != null) {
            TemplateVO templateDetails = this.dbTemplatingService.getVelocityDataById(templateId);
            vmTemplateData.put("templateDetails", templateDetails);
        }
        return this.templateEngine.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), vmTemplateData);
    }

    @RequestMapping(value={"/ctd"})
    @ResponseBody
    public String checkTemplateData(HttpServletRequest request, HttpServletResponse response) {
        String templateName = request.getParameter("templateName");
        String templateId = null;
        try {
            templateId = this.templateCrudService.checkVelocityData(templateName);
            return templateId;
        }
        catch (Exception e) {
            return null;
        }
    }

    @PostMapping(value={"/std"})
    public void saveTemplateData(HttpSession session, HttpServletRequest request) throws Exception {
        this.dbTemplatingService.saveTemplateData(request);
    }

    @PostMapping(value={"/dtl"})
    public void downloadAllTemplatesToLocalDirectory(HttpSession session, HttpServletRequest request) throws Exception {
        this.templateCrudService.downloadTemplates();
    }

    @PostMapping(value={"/utd"})
    public void uploadAllTemplatesToDB(HttpSession session, HttpServletRequest request) throws Exception {
        this.templateCrudService.uploadTemplates();
    }
}

