/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.dynamicform.service.DynamicFormService;
import com.trigyn.jws.templating.service.MenuService;
import com.trigyn.jws.webstarter.service.DynamicFormCrudService;
import com.trigyn.jws.webstarter.utils.Constant;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
@PreAuthorize(value="hasPermission('module','Form Builder')")
public class DynamicFormCrudController {
    private static final Logger logger = LogManager.getLogger(DynamicFormCrudController.class);
    @Autowired
    private DynamicFormCrudService dynamicFormCrudService = null;
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;
    @Autowired
    private DynamicFormService dynamicFormService = null;
    @Autowired
    private MenuService menuService = null;

    @PostMapping(value={"/aedf"}, produces={"text/html"})
    public String addEditForm(@RequestParam(value="form-id") String formId, HttpServletResponse httpServletResponse) throws IOException {
        try {
            return this.dynamicFormCrudService.addEditForm(formId);
        }
        catch (Exception exception) {
            logger.error("Error ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
            return null;
        }
    }

    @PostMapping(value={"/gfsq"}, produces={"application/json"})
    public List<Map<String, Object>> getAllFormQueriesById(HttpServletRequest httpServletRequest) throws Exception {
        String formId = httpServletRequest.getParameter("formId");
        return this.dynamicFormCrudService.getAllFormQueriesById(formId);
    }

    @PostMapping(value={"/sdfd"}, consumes={"application/x-www-form-urlencoded"})
    public String saveDynamicFormDetails(@RequestBody MultiValueMap<String, String> formData) throws Exception {
        return this.dynamicFormCrudService.saveDynamicFormDetails(formData, Constant.MASTER_SOURCE_VERSION_TYPE);
    }

    @GetMapping(value={"/dfl"}, produces={"text/html"})
    public String dynamicFormMasterListing(HttpServletResponse httpServletResponse) throws IOException {
        try {
            HashMap<String, String> modelMap = new HashMap<String, String>();
            String environment = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "profile");
            modelMap.put("environment", environment);
            return this.menuService.getTemplateWithSiteLayout("dynamic-form-listing", modelMap);
        }
        catch (Exception exception) {
            logger.error("Error ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
            return null;
        }
    }

    @PostMapping(value={"/dfte"}, produces={"application/json"})
    public Map<String, String> createDefaultFormByTableName(HttpServletRequest httpServletRequest) throws Exception {
        String tableName = httpServletRequest.getParameter("tableName");
        List tableDetails = this.dynamicFormService.getTableDetailsByTableName(tableName);
        return this.dynamicFormService.createDefaultFormByTableName(tableName, tableDetails);
    }

    @GetMapping(value={"/cdd"})
    @ResponseBody
    public String checkDynamicFormData(HttpServletRequest request, HttpServletResponse response) {
        String formName = request.getParameter("formName");
        String formId = null;
        formId = this.dynamicFormCrudService.checkFormName(formName);
        return formId;
    }

    @PostMapping(value={"/ddf"})
    public void downloadAllFormsToLocalDirectory(HttpSession session, HttpServletRequest request) throws Exception {
        this.dynamicFormCrudService.downloadDynamicFormsTemplate(null);
    }

    @PostMapping(value={"/udf"})
    public void uploadAllFormsToDB(HttpSession session, HttpServletRequest request) throws Exception {
        this.dynamicFormCrudService.uploadFormsToDB(null);
    }

    @PostMapping(value={"/ddfbi"})
    public void downloadFormByIdToLocalDirectory(HttpSession session, HttpServletRequest request) throws Exception {
        String formId = request.getParameter("formId");
        this.dynamicFormCrudService.downloadDynamicFormsTemplate(formId);
    }

    @PostMapping(value={"/udfbn"})
    public void uploadFormsByNameToDB(HttpSession session, HttpServletRequest request) throws Exception {
        String formName = request.getParameter("formName");
        this.dynamicFormCrudService.uploadFormsToDB(formName);
    }
}

