/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.templating.service.MenuService;
import com.trigyn.jws.webstarter.service.DynarestCrudService;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
@PreAuthorize(value="hasPermission('module','REST API Builder')")
public class DynarestCrudController {
    private static final Logger logger = LogManager.getLogger(DynarestCrudController.class);
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;
    @Autowired
    private DynarestCrudService dynarestCrudService = null;
    @Autowired
    private MenuService menuService = null;

    @GetMapping(value={"/dynl"}, produces={"text/html"})
    public String loadDynarestListing(HttpServletRequest httpServletRequest) throws Exception {
        HashMap<String, CharSequence> modelMap = new HashMap<String, CharSequence>();
        String environment = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "profile");
        modelMap.put("environment", environment);
        String uri = httpServletRequest.getRequestURI();
        String url = httpServletRequest.getRequestURL().toString();
        StringBuilder urlPrefix = new StringBuilder();
        url = url.replace(uri, "");
        urlPrefix.append(url).append("/api/");
        modelMap.put("urlPrefix", urlPrefix);
        return this.menuService.getTemplateWithSiteLayout("dynarest-details-listing", modelMap);
    }

    @PostMapping(value={"/sdq"}, consumes={"application/x-www-form-urlencoded"})
    public String saveDynamicRestSaveQueries(@RequestBody MultiValueMap<String, String> formData) throws Exception {
        this.dynarestCrudService.deleteDAOQueries(formData);
        return this.dynarestCrudService.saveDAOQueries(formData);
    }
}

