/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.google.gson.Gson;
import com.trigyn.jws.templating.service.MenuService;
import com.trigyn.jws.webstarter.service.HelpManualService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
public class HelpManualController {
    private static final Logger logger = LogManager.getLogger(HelpManualController.class);
    @Autowired
    private MenuService menuService = null;
    @Autowired
    private HelpManualService helpManualService = null;

    @GetMapping(value={"/help"}, produces={"text/html"})
    public String manualListingPage(HttpServletResponse httpServletResponse) throws IOException {
        try {
            return this.menuService.getTemplateWithSiteLayout("manual-type-template", new HashMap());
        }
        catch (Exception exception) {
            logger.error("Error while loding manual page ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
            return null;
        }
    }

    @GetMapping(value={"/ehme"}, produces={"text/html"})
    public String manualEntityListingPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            String manualType = httpServletRequest.getParameter("mt");
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("mt", manualType);
            return this.menuService.getTemplateWithSiteLayout("manual-entry-template", parameterMap);
        }
        catch (Exception exception) {
            logger.error("Error while loding manual page ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
            return null;
        }
    }

    @PostMapping(value={"/shmt"}, produces={"text/html"})
    public void saveManualType(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            String manualId = httpServletRequest.getParameter("manualId") == "" ? null : httpServletRequest.getParameter("manualId");
            String name = httpServletRequest.getParameter("name");
            this.helpManualService.saveManualType(manualId, name);
        }
        catch (Exception exception) {
            logger.error("Error while loding manual page ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
        }
    }

    @PostMapping(value={"/smfd"}, produces={"application/json"})
    public void saveFileManualDetails(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            String manualEntryId = httpServletRequest.getParameter("manualEntryId") == "" ? null : httpServletRequest.getParameter("manualEntryId");
            String entryName = httpServletRequest.getParameter("entryName");
            String manualId = httpServletRequest.getParameter("manualId");
            List fileIds = (List)new Gson().fromJson(httpServletRequest.getParameter("fileIds"), List.class);
            this.helpManualService.saveFileForManualEntry(manualEntryId, manualId, entryName, fileIds);
        }
        catch (Exception exception) {
            logger.error("Error while loding manual page ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
        }
    }

    @PostMapping(value={"/shmd"}, produces={"application/json"})
    public void saveManualEntryDetails(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            Map<String, Object> parameters = this.validateAndProcessRequestParams(httpServletRequest);
            this.helpManualService.saveManualEntryDetails(parameters);
        }
        catch (Exception exception) {
            logger.error("Error while loding manual page ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
        }
    }

    @GetMapping(value={"manual"}, produces={"text/html"})
    public String showManual(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            String manualType = httpServletRequest.getParameter("mt");
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("mt", manualType);
            return this.menuService.getTemplateWithSiteLayout("manual-display", parameterMap);
        }
        catch (Exception exception) {
            logger.error("Error while loding manual page ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
            return null;
        }
    }

    private Map<String, Object> validateAndProcessRequestParams(HttpServletRequest httpServletRequest) {
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        for (String requestParamKey : httpServletRequest.getParameterMap().keySet()) {
            requestParams.put(requestParamKey, httpServletRequest.getParameter(requestParamKey));
        }
        return requestParams;
    }
}

