/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.templating.service.MenuService;
import com.trigyn.jws.webstarter.entities.MasterModule;
import com.trigyn.jws.webstarter.service.ExportService;
import com.trigyn.jws.webstarter.service.MasterModuleService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
public class ImportExportController {
    private static final Logger logger = LogManager.getLogger(ImportExportController.class);
    @Autowired
    private MasterModuleService masterModuleService = null;
    @Autowired
    private MenuService menuService = null;
    @Autowired
    private ExportService exportService = null;

    @GetMapping(value={"/vexp"}, produces={"text/html"})
    public String viewExport(HttpServletRequest request, HttpServletResponse httpServletResponse) throws IOException {
        try {
            HashMap<String, List<MasterModule>> vmTemplateData = new HashMap<String, List<MasterModule>>();
            List<MasterModule> moduleVOList = this.masterModuleService.getModules();
            vmTemplateData.put("moduleVOList", moduleVOList);
            return this.menuService.getTemplateWithSiteLayout("export-config", vmTemplateData);
        }
        catch (Exception exception) {
            logger.error("Error ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
            return null;
        }
    }

    @RequestMapping(value={"/ecd"})
    @ResponseBody
    public String exportConfigData(@RequestBody Map<String, String> map, HttpServletRequest request, HttpServletResponse httpServletResponse) throws Exception {
        return this.exportService.exportConfigData(request, httpServletResponse, map);
    }

    @RequestMapping(value={"/downloadExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadExport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String filePath = request.getParameter("filePath");
        this.exportService.downloadExport(request, response, filePath);
    }
}

