/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.templating.service.MenuService;
import com.trigyn.jws.usermanagement.entities.JwsUser;
import com.trigyn.jws.usermanagement.vo.JwsEntityRoleAssociationVO;
import com.trigyn.jws.usermanagement.vo.JwsEntityRoleVO;
import com.trigyn.jws.usermanagement.vo.JwsMasterModulesVO;
import com.trigyn.jws.usermanagement.vo.JwsRoleMasterModulesAssociationVO;
import com.trigyn.jws.usermanagement.vo.JwsRoleVO;
import com.trigyn.jws.usermanagement.vo.JwsUserVO;
import com.trigyn.jws.webstarter.service.UserManagementService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.devtools.restart.Restarter;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
public class JwsUserManagementController {
    @Autowired
    private MenuService menuService = null;
    @Autowired
    private UserManagementService userManagementService = null;

    @GetMapping(value={"/um"})
    public String userManagement() throws Exception {
        return this.userManagementService.loadUserManagement();
    }

    @GetMapping(value={"/rl"})
    public String roleListing() throws Exception {
        HashMap mapDetails = new HashMap();
        return this.menuService.getTemplateWithSiteLayout("role-listing", mapDetails);
    }

    @PostMapping(value={"/srd"})
    public Boolean saveRole(@RequestBody JwsRoleVO roleData) throws Exception {
        this.userManagementService.saveRoleData(roleData);
        return true;
    }

    @PostMapping(value={"/aedr"})
    public String addEditRole(@RequestParam(value="roleId") String roleId, HttpServletResponse httpServletResponse) throws IOException {
        try {
            return this.userManagementService.addEditRole(roleId);
        }
        catch (Exception exception) {
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
            return null;
        }
    }

    @GetMapping(value={"/mrm"})
    public String manageRoleModules() throws Exception {
        return this.userManagementService.manageRoleModules();
    }

    @PostMapping(value={"/srm"})
    public Boolean saveRoleModules(@RequestBody JwsRoleMasterModulesAssociationVO roleModule, HttpServletResponse httpServletResponse) throws IOException {
        try {
            return this.userManagementService.saveRoleModules(roleModule);
        }
        catch (Exception exception) {
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
            return null;
        }
    }

    @GetMapping(value={"/ul"})
    public String userListing() throws Exception {
        HashMap mapDetails = new HashMap();
        return this.menuService.getTemplateWithSiteLayout("jws-user-listing", mapDetails);
    }

    @PostMapping(value={"/sud"})
    public Boolean saveUser(@RequestBody JwsUserVO userData) throws Exception {
        this.userManagementService.saveUserData(userData);
        return true;
    }

    @PostMapping(value={"/aedu"})
    public String addEditUser(@RequestParam(value="userId") String userId, HttpServletResponse httpServletResponse) throws IOException {
        try {
            boolean isProfilePage = false;
            return this.userManagementService.addEditUser(userId, isProfilePage);
        }
        catch (Exception exception) {
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
            return null;
        }
    }

    @PostMapping(value={"/sat"})
    public Boolean saveAuthenticationType(@RequestParam(value="authenticationEnabled") String authenticationEnabled, @RequestParam(value="authenticationTypeId") String authenticationTypeId, @RequestParam(value="propertyJson") String propertyJson, @RequestParam(value="regexObj") String regexObj) throws Exception {
        this.userManagementService.updatePropertyMasterValuesAndAuthProperties(authenticationEnabled, authenticationTypeId, propertyJson, regexObj);
        return true;
    }

    @GetMapping(value={"/profile"})
    public String profilePage() throws Exception {
        return this.userManagementService.getProfilePage();
    }

    @GetMapping(value={"/mer"})
    public String manageEntityRoles() throws Exception {
        return this.userManagementService.manageEntityRoles();
    }

    @PostMapping(value={"/suer"})
    public Boolean saveUpdateEntityRole(@RequestBody List<JwsEntityRoleAssociationVO> entityDataList) throws Exception {
        this.userManagementService.saveUpdateEntityRole(entityDataList);
        return true;
    }

    @GetMapping(value={"/modules"})
    public List<JwsMasterModulesVO> getModules() throws Exception {
        return this.userManagementService.getModules();
    }

    @GetMapping(value={"/restart"})
    public void restart() {
        Restarter.getInstance().restart();
    }

    @PostMapping(value={"/mp"})
    public String managePermissions() throws Exception {
        HashMap mapDetails = new HashMap();
        return this.menuService.getTemplateWithSiteLayout("manage-permission", mapDetails);
    }

    @PostMapping(value={"/ser"})
    public Boolean saveEntityRole(@RequestBody JwsEntityRoleVO entityRoles) throws Exception {
        this.userManagementService.deleteAndSaveEntityRole(entityRoles);
        return true;
    }

    @GetMapping(value={"/ler"}, produces={"application/json"})
    public List<JwsRoleVO> getEntityRole(@RequestParam(value="entityId") String entityId, @RequestParam(value="moduleId") String moduleId) throws Exception {
        return this.userManagementService.getEntityRoles(entityId, moduleId);
    }

    @GetMapping(value={"/cee"})
    public boolean checkEmailExist(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        boolean emailExist = true;
        String email = request.getParameter("email");
        JwsUser existingUser = this.userManagementService.findByEmailIgnoreCase(email);
        if (existingUser == null) {
            emailExist = false;
        }
        return emailExist;
    }

    @GetMapping(value={"/gif"}, produces={"application/json"})
    public String getInputFieldsByProperty(HttpServletRequest request) throws Exception {
        String propertyName = request.getParameter("inputId");
        return this.userManagementService.getInputFieldsByProperty(propertyName);
    }
}

