/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.templating.service.DBTemplatingService;
import com.trigyn.jws.templating.utils.TemplatingUtils;
import com.trigyn.jws.templating.vo.TemplateVO;
import com.trigyn.jws.usermanagement.entities.JwsAuthenticationType;
import com.trigyn.jws.usermanagement.entities.JwsConfirmationToken;
import com.trigyn.jws.usermanagement.entities.JwsUser;
import com.trigyn.jws.usermanagement.entities.JwsUserRoleAssociation;
import com.trigyn.jws.usermanagement.repository.JwsAuthenticationTypeRepository;
import com.trigyn.jws.usermanagement.repository.JwsConfirmationTokenRepository;
import com.trigyn.jws.usermanagement.repository.JwsUserRepository;
import com.trigyn.jws.usermanagement.repository.JwsUserRoleAssociationRepository;
import com.trigyn.jws.usermanagement.security.config.ApplicationSecurityDetails;
import com.trigyn.jws.usermanagement.security.config.CaptchaUtil;
import com.trigyn.jws.usermanagement.utils.Constants;
import com.trigyn.jws.usermanagement.vo.JwsUserVO;
import com.trigyn.jws.webstarter.service.SendMailService;
import com.trigyn.jws.webstarter.service.UserManagementService;
import com.trigyn.jws.webstarter.utils.Email;
import java.awt.Dimension;
import java.io.OutputStream;
import java.util.HashMap;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/cf"})
public class JwsUserRegistrationController {
    @Autowired
    private JwsUserRepository userRepository = null;
    @Autowired
    private JwsConfirmationTokenRepository confirmationTokenRepository = null;
    @Autowired
    private PasswordEncoder passwordEncoder = null;
    @Autowired
    private JwsUserRoleAssociationRepository userRoleAssociationRepository = null;
    @Autowired
    private ApplicationSecurityDetails applicationSecurityDetails = null;
    @Autowired
    private JwsAuthenticationTypeRepository authenticationTypeRepository = null;
    @Autowired
    private UserManagementService userManagementService = null;
    @Autowired
    private DBTemplatingService templatingService = null;
    @Autowired
    private TemplatingUtils templatingUtils = null;
    @Autowired
    private SendMailService sendMailService = null;

    @GetMapping(value={"/login"})
    @ResponseBody
    public String userLoginPage(HttpServletRequest request, HttpSession session, HttpServletResponse response) throws Exception {
        HashMap<String, Object> mapDetails = new HashMap<String, Object>();
        String queryString = request.getQueryString();
        if (StringUtils.isNotEmpty((CharSequence)request.getQueryString())) {
            mapDetails.put("queryString", queryString);
        }
        if (!this.applicationSecurityDetails.getIsAuthenticationEnabled().booleanValue()) {
            response.sendError(HttpStatus.FORBIDDEN.value(), "You dont have rights to access these module");
            return null;
        }
        this.userManagementService.getConfigurableDetails(mapDetails);
        TemplateVO templateVO = this.templatingService.getTemplateByName("jws-login");
        return this.templatingUtils.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), mapDetails);
    }

    @GetMapping(value={"/register"})
    @ResponseBody
    public String userRegistrationPage(HttpServletResponse response) throws Exception {
        HashMap<String, Object> mapDetails = new HashMap<String, Object>();
        String enableRegistrationPropertyName = "enableRegistration";
        if (this.applicationSecurityDetails.getIsAuthenticationEnabled().booleanValue()) {
            Integer authType = Integer.parseInt(this.applicationSecurityDetails.getAuthenticationType());
            JwsAuthenticationType authenticationType = (JwsAuthenticationType)this.authenticationTypeRepository.findById((Object)authType).orElseThrow(() -> new Exception("No auth type found with id : " + authType));
            JSONArray jsonArray = new JSONArray(authenticationType.getAuthenticationProperties());
            JSONObject jsonObject = null;
            if ((jsonObject = this.getJsonObjectFromPropertyValue(jsonObject, jsonArray, enableRegistrationPropertyName)) != null && jsonObject.getString("value").equalsIgnoreCase("false")) {
                response.sendError(HttpStatus.FORBIDDEN.value(), "You dont have rights to access these module");
            }
        } else {
            response.sendError(HttpStatus.FORBIDDEN.value(), "You dont have rights to access these module");
            return null;
        }
        this.userManagementService.getConfigurableDetails(mapDetails);
        TemplateVO templateVO = this.templatingService.getTemplateByName("jws-register");
        return this.templatingUtils.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), mapDetails);
    }

    @PostMapping(value={"/register"})
    @ResponseBody
    public String registerUser(HttpServletRequest request, JwsUserVO user, HttpServletResponse response) throws Exception {
        HashMap<String, Object> mapDetails = new HashMap<String, Object>();
        String viewName = null;
        JwsUser existingUser = this.userRepository.findByEmailIgnoreCase(user.getEmail());
        if (!this.applicationSecurityDetails.getIsAuthenticationEnabled().booleanValue()) {
            response.sendError(HttpStatus.FORBIDDEN.value(), "You dont have rights to access these module");
            return null;
        }
        this.userManagementService.getConfigurableDetails(mapDetails);
        if (existingUser != null) {
            mapDetails.put("error", "This email already exists!");
            mapDetails.put("firstName", user.getFirstName().trim());
            mapDetails.put("lastName", user.getLastName().trim());
            viewName = "jws-register";
        } else {
            HttpSession session = request.getSession();
            if (mapDetails.get("enableCaptcha").toString().equalsIgnoreCase("true") && session.getAttribute("captcha") != null && !user.getCaptcha().equals(session.getAttribute("captcha").toString())) {
                mapDetails.put("error", "Please verify captcha!");
                mapDetails.put("firstName", user.getFirstName().trim());
                mapDetails.put("lastName", user.getLastName().trim());
                viewName = "jws-register";
                TemplateVO templateVO = this.templatingService.getTemplateByName(viewName);
                return this.templatingUtils.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), mapDetails);
            }
            if (this.userManagementService.validatePassword(user.getPassword()).booleanValue()) {
                user.setPassword(this.passwordEncoder.encode((CharSequence)user.getPassword()));
                user.setIsActive(Constants.INACTIVE);
                user.setForcePasswordChange(Constants.INACTIVE);
                JwsUser userEntityFromVo = user.convertVOToEntity(user);
                userEntityFromVo.setForcePasswordChange(Constants.INACTIVE);
                this.userRepository.save((Object)userEntityFromVo);
                JwsConfirmationToken confirmationToken = new JwsConfirmationToken(userEntityFromVo);
                this.confirmationTokenRepository.save((Object)confirmationToken);
                Email email = new Email();
                email.setInternetAddressToArray(InternetAddress.parse((String)user.getEmail()));
                email.setSubject("Complete Registration!");
                email.setMailFrom("admin@jquiver.com");
                email.setBody("To confirm your account, please click here : http://localhost:8080/cf/confirm-account?token=" + confirmationToken.getConfirmationToken());
                System.out.println(email.getBody());
                this.sendMailService.sendTestMail(email);
                mapDetails.put("emailId", user.getEmail());
                viewName = "jws-successfulRegisteration";
            } else {
                viewName = "jws-register";
                mapDetails.put("firstName", user.getFirstName().trim());
                mapDetails.put("lastName", user.getLastName().trim());
                mapDetails.put("emailId", user.getEmail());
                mapDetails.put("errorPassword", "Password must contain atleast 6 characters including UPPER/lowercase/Special charcters and numbers!");
            }
        }
        TemplateVO templateVO = this.templatingService.getTemplateByName(viewName);
        return this.templatingUtils.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), mapDetails);
    }

    private JSONObject getJsonObjectFromPropertyValue(JSONObject jsonObject, JSONArray jsonArray, String propertyName) throws JSONException {
        for (int i = 0; i < jsonArray.length() && !(jsonObject = jsonArray.getJSONObject(i)).get("name").toString().equalsIgnoreCase(propertyName); ++i) {
            jsonObject = null;
        }
        return jsonObject;
    }

    @GetMapping(value={"/confirm-account"})
    @ResponseBody
    public String confirmUserAccount(ModelAndView modelAndView, @RequestParam(value="token") String confirmationToken, HttpServletResponse response) throws Exception {
        HashMap mapDetails = new HashMap();
        String viewName = null;
        if (this.applicationSecurityDetails.getIsAuthenticationEnabled().booleanValue()) {
            JwsConfirmationToken token = this.confirmationTokenRepository.findByConfirmationToken(confirmationToken);
            if (token == null) {
                response.sendError(HttpStatus.BAD_REQUEST.value(), "The link is invalid or broken!");
                return null;
            }
            JwsUser user = this.userRepository.findByEmailIgnoreCase(token.getUserRegistration().getEmail());
            user.setIsActive(Constants.ISACTIVE);
            this.userRepository.save((Object)user);
            JwsUserRoleAssociation adminRoleAssociation = new JwsUserRoleAssociation();
            adminRoleAssociation.setUserId(user.getUserId());
            adminRoleAssociation.setRoleId("2ace542e-0c63-11eb-9cf5-f48e38ab9348");
            this.userRoleAssociationRepository.save((Object)adminRoleAssociation);
            StringBuffer sb = new StringBuffer("First Name :" + user.getFirstName().trim());
            sb.append("Last Name :" + user.getLastName().trim());
            sb.append("Email :" + user.getEmail().trim());
            viewName = "jws-accountVerified";
            TemplateVO templateVO = this.templatingService.getTemplateByName(viewName);
            return this.templatingUtils.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), mapDetails);
        }
        response.sendError(HttpStatus.FORBIDDEN.value(), "You dont have rights to access these module");
        return null;
    }

    @GetMapping(value={"/captcha"})
    public void loadCaptcha(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        String captchaStr = CaptchaUtil.getCaptchaString();
        System.out.println(captchaStr);
        int width = 130;
        int height = 59;
        HttpSession session = request.getSession();
        session.setAttribute("captcha", (Object)captchaStr);
        ServletOutputStream outputStream = response.getOutputStream();
        CaptchaUtil.generateCaptcha((Dimension)new Dimension(width, height), (String)captchaStr, (OutputStream)outputStream);
        outputStream.close();
    }
}

