/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trigyn.jws.resourcebundle.service.ResourceBundleService;
import com.trigyn.jws.resourcebundle.vo.ResourceBundleVO;
import com.trigyn.jws.templating.service.MenuService;
import com.trigyn.jws.webstarter.utils.Constant;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
public class ResourceBundleCrudController {
    private static final Logger logger = LogManager.getLogger(ResourceBundleCrudController.class);
    @Autowired
    private ResourceBundleService resourceBundleService = null;
    @Autowired
    private MenuService menuService = null;

    @GetMapping(value={"/rb"}, produces={"text/html"})
    public String dbResourceBundleListing(HttpServletResponse httpServletResponse) throws IOException {
        try {
            HashMap<String, List> templateMap = new HashMap<String, List>();
            List languageVOList = this.resourceBundleService.getLanguagesList();
            templateMap.put("languageVOList", languageVOList);
            return this.menuService.getTemplateWithSiteLayout("resource-bundle-listing", templateMap);
        }
        catch (Exception exception) {
            logger.error("Error ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
            return null;
        }
    }

    @PostMapping(value={"/aerb"})
    public String dbResourceJsp(@RequestParam(value="resource-key") String resourceBundleKey) throws Exception {
        HashMap<String, Object> templateMap = new HashMap<String, Object>();
        if (resourceBundleKey != null) {
            Map resourceBundleVOMap = this.resourceBundleService.getResourceBundleVOMap(resourceBundleKey);
            templateMap.put("resourceBundleVOMap", resourceBundleVOMap);
        }
        List languageVOList = this.resourceBundleService.getLanguagesList();
        templateMap.put("languageVOList", languageVOList);
        templateMap.put("resourceBundleKey", resourceBundleKey);
        return this.menuService.getTemplateWithSiteLayout("resource-bundle-manage-details", templateMap);
    }

    @GetMapping(value={"/crbk"}, produces={"application/json"})
    public ResponseEntity<Boolean> checkResourceData(@RequestParam(value="resourceKey") String resourceBundleKey) throws Exception {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        try {
            Boolean keyAlreadyExist = this.resourceBundleService.checkResourceKeyExist(resourceBundleKey);
            return new ResponseEntity((Object)keyAlreadyExist, (MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            logger.error("Error ", (Throwable)e);
            return new ResponseEntity((Object)true, (MultiValueMap)httpHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/srb"}, produces={"application/json"})
    public ResponseEntity<Boolean> saveResourceDetails(@RequestBody List<ResourceBundleVO> dbResourceList) throws Exception {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        try {
            this.resourceBundleService.saveResourceBundleDetails(dbResourceList, Constant.MASTER_SOURCE_VERSION_TYPE);
            return new ResponseEntity((Object)true, (MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            logger.error("Error ", (Throwable)e);
            return new ResponseEntity((Object)false, (MultiValueMap)httpHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/srbv"}, produces={"application/json"})
    public void saveResourceDetailsByVersion(HttpServletRequest a_httpServletRequest, HttpServletResponse a_httpServletResponse) throws Exception {
        TypeReference<List<ResourceBundleVO>> resourceBundleType = new TypeReference<List<ResourceBundleVO>>(){};
        String modifiedContent = a_httpServletRequest.getParameter("modifiedContent");
        ObjectMapper objectMapper = new ObjectMapper();
        List resourceBundleList = (List)objectMapper.readValue(modifiedContent, (TypeReference)resourceBundleType);
        this.resourceBundleService.saveResourceBundleDetails(resourceBundleList, Constant.REVISION_SOURCE_VERSION_TYPE);
    }
}

