/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.templating.service.DBTemplatingService;
import com.trigyn.jws.templating.service.MenuService;
import com.trigyn.jws.templating.vo.TemplateVO;
import com.trigyn.jws.webstarter.service.TemplateCrudService;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
@PreAuthorize(value="hasPermission('module','Templating')")
public class TemplateCrudController {
    private static final Logger logger = LogManager.getLogger(TemplateCrudController.class);
    @Autowired
    private DBTemplatingService dbTemplatingService = null;
    @Autowired
    private TemplateCrudService templateCrudService = null;
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;
    @Autowired
    private MenuService menuService = null;

    @GetMapping(value={"/te"}, produces={"text/html"})
    public String templatePage(HttpServletResponse httpServletResponse) throws IOException {
        try {
            HashMap<String, String> modelMap = new HashMap<String, String>();
            String environment = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "profile");
            modelMap.put("environment", environment);
            return this.menuService.getTemplateWithSiteLayout("template-listing", modelMap);
        }
        catch (Exception exception) {
            logger.error("Error ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
            return null;
        }
    }

    @GetMapping(value={"/aet"}, produces={"text/html"})
    public String velocityTemplateEditor(HttpServletRequest request, HttpServletResponse httpServletResponse) throws IOException {
        try {
            String templateId = request.getParameter("vmMasterId");
            HashMap<String, TemplateVO> vmTemplateData = new HashMap<String, TemplateVO>();
            if (!StringUtils.isBlank((CharSequence)templateId)) {
                TemplateVO templateDetails = this.dbTemplatingService.getVelocityDataById(templateId);
                templateDetails.setTemplate("");
                vmTemplateData.put("templateDetails", templateDetails);
            }
            return this.menuService.getTemplateWithSiteLayout("template-manage-details", vmTemplateData);
        }
        catch (Exception exception) {
            logger.error("Error ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
            return null;
        }
    }

    @RequestMapping(value={"/ctd"})
    @ResponseBody
    public String checkTemplateData(HttpServletRequest request, HttpServletResponse response) {
        String templateName = request.getParameter("templateName");
        String templateId = null;
        try {
            templateId = this.templateCrudService.checkVelocityData(templateName);
            return templateId;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @GetMapping(value={"/gtbi"})
    public String getTemplateByTemplateId(HttpServletRequest request) throws Exception {
        String templateId = request.getParameter("templateId");
        TemplateVO templateDetails = this.dbTemplatingService.getVelocityDataById(templateId);
        return templateDetails.getTemplate();
    }

    @PostMapping(value={"/std"})
    public String saveTemplateData(HttpSession session, HttpServletRequest request) throws Exception {
        return this.dbTemplatingService.saveTemplateData(request);
    }

    @PostMapping(value={"/stdv"})
    public void saveTemplateDataByVersion(HttpServletRequest a_httpServletRequest, HttpServletResponse a_httpServletResponse) throws Exception {
        String modifiedContent = a_httpServletRequest.getParameter("modifiedContent");
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        TemplateVO templateVO = (TemplateVO)objectMapper.readValue(modifiedContent, TemplateVO.class);
        this.dbTemplatingService.saveTemplate(templateVO);
    }

    @PostMapping(value={"/dtl"})
    public void downloadAllTemplatesToLocalDirectory(HttpSession session, HttpServletRequest request) throws Exception {
        this.templateCrudService.downloadTemplates(null);
    }

    @PostMapping(value={"/utd"})
    public void uploadAllTemplatesToDB(HttpSession session, HttpServletRequest request) throws Exception {
        this.templateCrudService.uploadTemplates(null);
    }

    @PostMapping(value={"/dtbi"})
    public void downloadTemplateByIdToLocalDirectory(HttpSession session, HttpServletRequest request) throws Exception {
        String templateId = request.getParameter("templateId");
        this.templateCrudService.downloadTemplates(templateId);
    }

    @PostMapping(value={"/utdbi"})
    public void uploadTemplateByNameToDB(HttpSession session, HttpServletRequest request) throws Exception {
        String templateName = request.getParameter("templateName");
        this.templateCrudService.uploadTemplates(templateName);
    }
}

