/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.dao;

import com.trigyn.jws.dbutils.repository.DBConnection;
import com.trigyn.jws.webstarter.entities.ManualEntryDetails;
import com.trigyn.jws.webstarter.entities.ManualEntryFileAssociation;
import java.util.HashMap;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HelpManualDAO
extends DBConnection {
    @Autowired
    public HelpManualDAO(DataSource dataSource) {
        super(dataSource);
    }

    public void updateManualDetails(String manualId, String name) {
        String updateQuery = "UPDATE manual_type SET name = :name WHERE manual_id = :manualId";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("name", name);
        paramMap.put("manualId", manualId);
        this.namedParameterJdbcTemplate.update(updateQuery, paramMap);
    }

    public void insertManualDetails(String manualId, String name) {
        String insertQuery = "INSERT INTO manual_type(manual_id, name, is_system_manual) VALUES (UUID(), :name ,0)";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("name", name);
        this.namedParameterJdbcTemplate.update(insertQuery, paramMap);
    }

    public String getManualDetailByIdAndName(String manualId, String entryName) {
        String getManualDetails = "SELECT manual_entry_id FROM manual_entry WHERE manual_type = :manualId AND entry_name = :entryName";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("manualId", manualId);
        paramMap.put("entryName", entryName);
        String manualEntryName = null;
        manualEntryName = (String)this.namedParameterJdbcTemplate.queryForObject(getManualDetails, paramMap, String.class);
        return manualEntryName;
    }

    public void saveFileAssociation(ManualEntryFileAssociation entryFileAssociation) {
        this.getCurrentSession().saveOrUpdate((Object)entryFileAssociation);
    }

    public void deleteFilesByManualEntryId(String manualEntryId) {
        String deleteQuery = "DELETE FROM manual_entry_file_association WHERE manual_entry_id = :manualEntryId";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("manualEntryId", manualEntryId);
        this.namedParameterJdbcTemplate.update(deleteQuery, paramMap);
    }

    public void saveManualEntry(ManualEntryDetails manualEntryDetails) {
        this.getCurrentSession().saveOrUpdate((Object)manualEntryDetails);
    }
}

