/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.exception;

import com.trigyn.jws.dbutils.repository.IModuleListingRepository;
import com.trigyn.jws.dbutils.repository.ModuleDAO;
import com.trigyn.jws.dbutils.vo.ModuleDetailsVO;
import com.trigyn.jws.templating.service.DBTemplatingService;
import com.trigyn.jws.templating.service.MenuService;
import com.trigyn.jws.templating.vo.TemplateVO;
import com.trigyn.jws.webstarter.controller.MasterModuleController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class URLExceptionHandler
implements ErrorController {
    @Autowired
    private DBTemplatingService templateService = null;
    @Autowired
    private IModuleListingRepository iModuleListingRepository = null;
    @Autowired
    private ModuleDAO moduleDAO = null;
    @Autowired
    private MenuService menuService = null;
    @Autowired
    private MasterModuleController masterModuleController = null;
    private static final String HOME_PAGE_MODULE = "home-module";

    @RequestMapping(value={"/error"})
    public String errorHandler(HttpServletRequest httpServletRequest) throws Exception {
        Object status = httpServletRequest.getAttribute("javax.servlet.error.status_code");
        Exception exception = (Exception)httpServletRequest.getAttribute("javax.servlet.error.exception");
        TemplateVO templateVO = this.templateService.getTemplateByName("error-page");
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        if (status != null) {
            Integer statusCode = Integer.parseInt(status.toString());
            parameterMap.put("statusCode", statusCode);
            String url = httpServletRequest.getAttribute("javax.servlet.error.request_uri").toString().replace(httpServletRequest.getContextPath(), "");
            if (url.contains("webjars")) {
                return "";
            }
            if (statusCode.intValue() == HttpStatus.NOT_FOUND.value()) {
                String fallbackTemplate;
                if ("/".equals(url)) {
                    url = HOME_PAGE_MODULE;
                }
                if ((fallbackTemplate = this.masterModuleController.loadTemplate(httpServletRequest, url)) == null) {
                    return this.menuService.getTemplateWithSiteLayout(templateVO.getTemplateName(), parameterMap);
                }
                return fallbackTemplate;
            }
            if (exception != null) {
                parameterMap.put("errorMessage", "<#noparse>" + exception.getCause() + "</#noparse>");
            } else {
                parameterMap.put("errorMessage", "<#noparse>" + httpServletRequest.getAttribute("javax.servlet.error.message") + "</#noparse>");
            }
        }
        return this.menuService.getTemplateWithSiteLayout(templateVO.getTemplateName(), parameterMap);
    }

    private TemplateVO getTemplateIfAssociatedWithURL(String requestedURL) throws Exception {
        TemplateVO templateVO = null;
        ModuleDetailsVO moduleDetailsVO = this.iModuleListingRepository.getTargetTypeDetails(requestedURL);
        if (moduleDetailsVO != null) {
            List targetTypeMapList = new ArrayList();
            targetTypeMapList = this.moduleDAO.findTargetTypeDetails(moduleDetailsVO.getTargetLookupId(), moduleDetailsVO.getTargetTypeId());
            if (!CollectionUtils.isEmpty(targetTypeMapList)) {
                String templateName = ((Map)targetTypeMapList.get(0)).get("targetTypeName").toString();
                templateVO = this.templateService.getTemplateByName(templateName);
            }
        }
        return templateVO;
    }

    public String getErrorPath() {
        return null;
    }
}

