/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.dbutils.service.DownloadUploadModule;
import com.trigyn.jws.dbutils.service.ModuleVersionService;
import com.trigyn.jws.dbutils.utils.FileUtilities;
import com.trigyn.jws.dynamicform.dao.DynamicFormCrudDAO;
import com.trigyn.jws.dynamicform.dao.IDynamicFormQueriesRepository;
import com.trigyn.jws.dynamicform.entities.DynamicForm;
import com.trigyn.jws.dynamicform.entities.DynamicFormSaveQuery;
import com.trigyn.jws.templating.service.MenuService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;

@Service
@Transactional
public class DynamicFormCrudService {
    @Autowired
    private DynamicFormCrudDAO dynamicFormDAO = null;
    @Autowired
    private IDynamicFormQueriesRepository dynamicFormQueriesRepository = null;
    @Autowired
    private DownloadUploadModule<DynamicForm> downloadUploadModule = null;
    @Autowired
    private ModuleVersionService moduleVersionService = null;
    @Autowired
    private MenuService menuService = null;
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;
    @Autowired
    private FileUtilities fileUtilities = null;

    @Transactional(readOnly=true)
    public String addEditForm(String formId) throws Exception {
        HashMap templateMap = new HashMap();
        DynamicForm dynamicForm = new DynamicForm();
        if (StringUtils.isNotEmpty((CharSequence)formId)) {
            dynamicForm = this.dynamicFormDAO.findDynamicFormById(formId);
            dynamicForm.setFormBody("<#noparse>" + dynamicForm.getFormBody() + "</#noparse>");
            dynamicForm.setFormSelectQuery("<#noparse>" + dynamicForm.getFormSelectQuery() + "</#noparse>");
        } else {
            List tables = this.dynamicFormDAO.getAllTablesListInSchema();
            templateMap.put("tables", tables);
        }
        templateMap.put("dynamicForm", dynamicForm);
        return this.menuService.getTemplateWithSiteLayout("dynamic-form-manage-details", templateMap);
    }

    @Transactional(readOnly=false)
    public String saveDynamicFormDetails(MultiValueMap<String, String> formData, Integer sourceTypeId) throws Exception {
        DynamicForm dynamicForm = new DynamicForm();
        ArrayList<DynamicFormSaveQuery> dynamicFormSaveQueries = new ArrayList<DynamicFormSaveQuery>();
        String formId = ((String)formData.getFirst((Object)"formId")).toString();
        if (StringUtils.isNotEmpty((CharSequence)formId)) {
            dynamicForm = this.dynamicFormDAO.findDynamicFormById(formId);
        } else {
            dynamicForm.setCreatedBy("admin");
            dynamicForm.setCreatedDate(new Date());
        }
        String formName = (String)formData.getFirst((Object)"formName");
        if (!StringUtils.isBlank((CharSequence)formName)) {
            dynamicForm.setFormName(formName);
        }
        dynamicForm.setFormDescription(((String)formData.getFirst((Object)"formDescription")).toString());
        dynamicForm.setFormSelectQuery(((String)formData.getFirst((Object)"formSelectQuery")).toString());
        dynamicForm.setFormBody(((String)formData.getFirst((Object)"formBody")).toString());
        dynamicForm.setDynamicFormSaveQueries(dynamicFormSaveQueries);
        this.dynamicFormDAO.saveDynamicFormData(dynamicForm);
        List<DynamicFormSaveQuery> formSaveQueries = this.saveDynamicFormQueries(formData, dynamicForm.getFormId(), dynamicFormSaveQueries, formId);
        dynamicForm.setDynamicFormSaveQueries(formSaveQueries);
        String environment = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "profile");
        if (environment.equalsIgnoreCase("dev")) {
            String downloadFolderLocation = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "template-storage-path");
            this.downloadUploadModule.downloadCodeToLocal((Object)dynamicForm, downloadFolderLocation);
        }
        this.moduleVersionService.saveModuleVersion((Object)dynamicForm, null, (Object)dynamicForm.getFormId(), "dynamic_form", sourceTypeId);
        return dynamicForm.getFormId();
    }

    private List<DynamicFormSaveQuery> saveDynamicFormQueries(MultiValueMap<String, String> formData, String dynamicFormId, List<DynamicFormSaveQuery> dynamicFormSaveQueries, String formId) throws JsonProcessingException, JsonMappingException, Exception {
        String queriesList = (String)formData.getFirst((Object)"formSaveQuery");
        List queries = (List)new ObjectMapper().readValue(queriesList, List.class);
        this.dynamicFormDAO.deleteFormQueriesByIds(formId);
        for (int queryCounter = 0; queryCounter < queries.size(); ++queryCounter) {
            DynamicFormSaveQuery dynamicFormSaveQuery = new DynamicFormSaveQuery();
            dynamicFormSaveQuery.setDynamicFormId(dynamicFormId);
            dynamicFormSaveQuery.setDynamicFormSaveQuery((String)queries.get(queryCounter));
            dynamicFormSaveQuery.setSequence(Integer.valueOf(queryCounter + 1));
            dynamicFormSaveQueries.add(dynamicFormSaveQuery);
        }
        return this.dynamicFormQueriesRepository.saveAll(dynamicFormSaveQueries);
    }

    public List<Map<String, Object>> getAllFormQueriesById(String formId) throws Exception {
        ArrayList<Map<String, Object>> dynamicFormList = new ArrayList<Map<String, Object>>();
        List dynamicFormSaveQueryList = this.dynamicFormDAO.findDynamicFormQueriesById(formId);
        DynamicForm dynamicForm = this.dynamicFormDAO.findDynamicFormById(formId);
        for (DynamicFormSaveQuery dynamicFormSaveQuery : dynamicFormSaveQueryList) {
            HashMap<String, Object> formSaveQueryMap = new HashMap<String, Object>();
            formSaveQueryMap.put("formQueryId", dynamicFormSaveQuery.getDynamicFormQueryId());
            formSaveQueryMap.put("formSaveQuery", dynamicFormSaveQuery.getDynamicFormSaveQuery());
            formSaveQueryMap.put("sequence", dynamicFormSaveQuery.getSequence());
            dynamicFormList.add(formSaveQueryMap);
        }
        HashMap<String, String> formSaveQueryMap = new HashMap<String, String>();
        formSaveQueryMap.put("formBody", dynamicForm.getFormBody());
        dynamicFormList.add(formSaveQueryMap);
        return dynamicFormList;
    }

    @Transactional(readOnly=true)
    public String checkFormName(String formName) {
        return this.dynamicFormDAO.checkFormName(formName);
    }

    public void downloadDynamicFormsTemplate(String formId) throws Exception {
        String downloadFolderLocation = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "template-storage-path");
        if (!StringUtils.isBlank((CharSequence)formId)) {
            DynamicForm dynamicForm = this.dynamicFormDAO.findDynamicFormById(formId);
            this.downloadUploadModule.downloadCodeToLocal((Object)dynamicForm, downloadFolderLocation);
        } else {
            this.downloadUploadModule.downloadCodeToLocal(null, downloadFolderLocation);
        }
    }

    public void uploadFormsToDB(String formName) throws Exception {
        this.downloadUploadModule.uploadCodeToDB(formName);
    }
}

