/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.dbutils.service.ModuleVersionService;
import com.trigyn.jws.dbutils.utils.FileUtilities;
import com.trigyn.jws.dynarest.dao.JwsDynamicRestDAORepository;
import com.trigyn.jws.dynarest.dao.JwsDynamicRestDetailsRepository;
import com.trigyn.jws.dynarest.dao.JwsDynarestDAO;
import com.trigyn.jws.dynarest.entities.JwsDynamicRestDaoDetail;
import com.trigyn.jws.dynarest.service.JwsDynamicRestDetailService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

@Service
@Transactional
public class DynarestCrudService {
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;
    @Autowired
    private FileUtilities fileUtilities = null;
    @Autowired
    private JwsDynamicRestDetailsRepository dynamicRestDetailsRepository = null;
    @Autowired
    private JwsDynamicRestDAORepository dynamicRestDAORepository = null;
    @Autowired
    private JwsDynarestDAO dynarestDAO = null;
    @Autowired
    private JwsDynamicRestDetailService dynamicRestDetailService = null;
    @Autowired
    private ModuleVersionService moduleVersionService = null;

    public String getContentForDevEnvironment(String formName, String fileName) throws Exception {
        String ftlCustomExtension = ".tgn";
        String templateDirectory = "DynamicRest";
        Object folderLocation = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "template-storage-path");
        File directory = new File((String)(folderLocation = (String)folderLocation + File.separator + templateDirectory + File.separator + formName));
        if (!directory.exists()) {
            throw new Exception("No such directory present");
        }
        File selectFile = new File((String)folderLocation + File.separator + fileName + ftlCustomExtension);
        if (selectFile.exists()) {
            return this.fileUtilities.readContentsOfFile(selectFile.getAbsolutePath());
        }
        throw new Exception("Please download the forms from dynamic form  listing  " + formName);
    }

    @Transactional(readOnly=false)
    public String saveDAOQueries(MultiValueMap<String, String> formData) throws Exception {
        String dynarestUrl = (String)formData.getFirst((Object)"dynarestUrl");
        String dynarestMethodName = (String)formData.getFirst((Object)"dynarestMethodName");
        String daoDetailsIds = (String)formData.getFirst((Object)"daoDetailsIds");
        String variableName = (String)formData.getFirst((Object)"variableName");
        String queryType = (String)formData.getFirst((Object)"queryType");
        String daoQueryDetails = (String)formData.getFirst((Object)"daoQueryDetails");
        String dynamicRestId = this.dynamicRestDetailsRepository.findByJwsDynamicRestId(dynarestUrl, dynarestMethodName);
        ObjectMapper objectMapper = new ObjectMapper();
        TypeReference<List<Integer>> listOfInteger = new TypeReference<List<Integer>>(){};
        List daoDetailsIdList = new ArrayList();
        List variableNameList = (List)objectMapper.readValue(variableName, List.class);
        List queryTypeList = (List)objectMapper.readValue(queryType, (TypeReference)listOfInteger);
        List daoQueryDetailsList = (List)objectMapper.readValue(daoQueryDetails, List.class);
        if (!StringUtils.isBlank((CharSequence)daoDetailsIds)) {
            daoDetailsIdList = (List)new ObjectMapper().readValue(daoDetailsIds, (TypeReference)listOfInteger);
        }
        ArrayList<JwsDynamicRestDaoDetail> dynamicRestDaoDetailsList = new ArrayList<JwsDynamicRestDaoDetail>();
        if (!CollectionUtils.isEmpty((Collection)daoQueryDetailsList)) {
            for (int counter = 0; counter < variableNameList.size(); ++counter) {
                JwsDynamicRestDaoDetail dynamicRestDaoDetail = new JwsDynamicRestDaoDetail();
                if (!CollectionUtils.isEmpty(daoDetailsIdList) && daoDetailsIdList.size() > counter) {
                    dynamicRestDaoDetail.setJwsDaoDetailsId((Integer)daoDetailsIdList.get(counter));
                }
                dynamicRestDaoDetail.setJwsDynamicRestDetailId(dynamicRestId);
                dynamicRestDaoDetail.setJwsResultVariableName((String)variableNameList.get(counter));
                dynamicRestDaoDetail.setQueryType((Integer)queryTypeList.get(counter));
                dynamicRestDaoDetail.setJwsDaoQueryTemplate((String)daoQueryDetailsList.get(counter));
                dynamicRestDaoDetail.setJwsQuerySequence(Integer.valueOf(counter + 1));
                dynamicRestDaoDetailsList.add(dynamicRestDaoDetail);
            }
            this.dynamicRestDAORepository.saveAll(dynamicRestDaoDetailsList);
        }
        return dynamicRestId;
    }

    @Transactional(readOnly=false)
    public void deleteDAOQueries(MultiValueMap<String, String> formData) throws Exception {
        String dynarestUrl = (String)formData.getFirst((Object)"dynarestUrl");
        String dynarestMethodName = (String)formData.getFirst((Object)"dynarestMethodName");
        String daoDetailsIds = (String)formData.getFirst((Object)"daoDetailsIds");
        ObjectMapper objectMapper = new ObjectMapper();
        TypeReference<List<Integer>> listOfInteger = new TypeReference<List<Integer>>(){};
        List daoDetailsIdList = new ArrayList();
        if (!StringUtils.isBlank((CharSequence)daoDetailsIds)) {
            daoDetailsIdList = (List)objectMapper.readValue(daoDetailsIds, (TypeReference)listOfInteger);
        }
        String dynamicRestId = this.dynamicRestDetailsRepository.findByJwsDynamicRestId(dynarestUrl, dynarestMethodName);
        this.dynarestDAO.deleteDAOQueriesById(dynamicRestId, daoDetailsIdList);
    }
}

