/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.service;

import com.trigyn.jws.dashboard.entities.Dashboard;
import com.trigyn.jws.dashboard.entities.Dashlet;
import com.trigyn.jws.dashboard.service.DashletModule;
import com.trigyn.jws.dbutils.entities.ModuleListing;
import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.dbutils.spi.IUserDetailsService;
import com.trigyn.jws.dbutils.vo.UserDetailsVO;
import com.trigyn.jws.dynamicform.entities.DynamicForm;
import com.trigyn.jws.dynamicform.entities.FileUploadConfig;
import com.trigyn.jws.dynamicform.service.DynamicFormModule;
import com.trigyn.jws.dynarest.entities.JwsDynamicRestDetail;
import com.trigyn.jws.gridutils.entities.GridDetails;
import com.trigyn.jws.notification.entities.GenericUserNotification;
import com.trigyn.jws.resourcebundle.entities.ResourceBundle;
import com.trigyn.jws.templating.entities.TemplateMaster;
import com.trigyn.jws.templating.service.TemplateModule;
import com.trigyn.jws.typeahead.entities.Autocomplete;
import com.trigyn.jws.usermanagement.entities.JwsEntityRoleAssociation;
import com.trigyn.jws.webstarter.dao.ImportExportCrudDAO;
import com.trigyn.jws.webstarter.utils.FileUtil;
import com.trigyn.jws.webstarter.utils.XMLUtil;
import com.trigyn.jws.webstarter.utils.ZipUtil;
import com.trigyn.jws.webstarter.xml.AutocompleteXMLVO;
import com.trigyn.jws.webstarter.xml.DashboardXMLVO;
import com.trigyn.jws.webstarter.xml.DynaRestXMLVO;
import com.trigyn.jws.webstarter.xml.FileManagerXMLVO;
import com.trigyn.jws.webstarter.xml.GenericUserNotificationXMLVO;
import com.trigyn.jws.webstarter.xml.GridXMLVO;
import com.trigyn.jws.webstarter.xml.PermissionXMLVO;
import com.trigyn.jws.webstarter.xml.ResourceBundleXMLVO;
import com.trigyn.jws.webstarter.xml.SiteLayoutXMLVO;
import com.trigyn.jws.webstarter.xml.XMLVO;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=false)
public class ExportService {
    private static final Logger logger = LogManager.getLogger(ExportService.class);
    @Autowired
    private ImportExportCrudDAO importExportCrudDAO = null;
    @Autowired
    private TemplateModule templateDownloadUploadModule = null;
    @Autowired
    @Qualifier(value="dynamic-form")
    private DynamicFormModule dynamicFormDownloadUploadModule = null;
    @Autowired
    @Qualifier(value="dashlet")
    private DashletModule dashletDownloadUploadModule = null;
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;
    private Map<String, String> moduleListMap = null;
    @Autowired
    private IUserDetailsService detailsService = null;
    private String version = null;
    private String userName = null;

    public String exportConfigData(HttpServletRequest request, HttpServletResponse response, Map<String, String> out) throws Exception {
        this.version = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "version");
        UserDetailsVO detailsVO = this.detailsService.getUserDetails();
        this.userName = detailsVO.getUserName();
        String systemPath = System.getProperty("user.dir");
        String tempDownloadPath = FileUtil.generateTemporaryFilePath("exportTempPath");
        new File(tempDownloadPath).mkdir();
        this.moduleListMap = new HashMap<String, String>();
        String htmlTableJSON = "";
        for (Map.Entry<String, String> obj : out.entrySet()) {
            XMLVO xmlVO = null;
            String moduleType = obj.getKey();
            String exportData = obj.getValue();
            JSONObject jsonObject = new JSONObject(exportData);
            if ("htmlTableJSON".equals(moduleType)) {
                htmlTableJSON = exportData;
            } else {
                xmlVO = this.retrieveDBData(moduleType, jsonObject, tempDownloadPath);
            }
            if (xmlVO == null) continue;
            XMLUtil.marshaling(xmlVO, moduleType, tempDownloadPath);
        }
        XMLUtil.generateMetadataXML(this.moduleListMap, null, tempDownloadPath, this.version, this.userName, htmlTableJSON);
        String zipFilePath = ZipUtil.zipDirectory(tempDownloadPath, systemPath);
        return zipFilePath;
    }

    public void downloadExport(HttpServletRequest request, HttpServletResponse response, String filePath) throws Exception {
        FileUtil.downloadFile(request, response, filePath);
    }

    private XMLVO retrieveDBData(String moduleType, JSONObject jsonObject, String downloadFolderLocation) throws Exception {
        ArrayList<String> systemConfigIncludeList = new ArrayList<String>();
        ArrayList<String> customConfigExcludeList = new ArrayList<String>();
        ArrayList<Integer> systemConfigIncludeListInt = new ArrayList<Integer>();
        ArrayList<Integer> customConfigExcludeListInt = new ArrayList<Integer>();
        if (moduleType.equals("DYNA_REST")) {
            int i;
            JSONArray jsonArray = (JSONArray)jsonObject.get("systemConfigIncludeList");
            for (i = 0; i < jsonArray.length(); ++i) {
                systemConfigIncludeListInt.add(jsonArray.getInt(i));
            }
            jsonArray = (JSONArray)jsonObject.get("customConfigExcludeList");
            for (i = 0; i < jsonArray.length(); ++i) {
                customConfigExcludeListInt.add(jsonArray.getInt(i));
            }
            if (customConfigExcludeList.size() == 0) {
                customConfigExcludeListInt.add(0);
            }
        } else {
            int i;
            JSONArray jsonArray = (JSONArray)jsonObject.get("systemConfigIncludeList");
            for (i = 0; i < jsonArray.length(); ++i) {
                systemConfigIncludeList.add(jsonArray.getString(i));
            }
            jsonArray = (JSONArray)jsonObject.get("customConfigExcludeList");
            for (i = 0; i < jsonArray.length(); ++i) {
                customConfigExcludeList.add(jsonArray.getString(i));
            }
            if (customConfigExcludeList.size() == 0) {
                customConfigExcludeList.add("");
            }
        }
        if (moduleType.equals("Grid")) {
            return this.retrieveGridExportData(systemConfigIncludeList, customConfigExcludeList, moduleType);
        }
        if (moduleType.equals("ResourceBundle")) {
            return this.retrieveRBExportData(systemConfigIncludeList, customConfigExcludeList, moduleType);
        }
        if (moduleType.equals("Autocomplete")) {
            return this.retrieveAutocompleteExportData(systemConfigIncludeList, customConfigExcludeList, moduleType);
        }
        if (moduleType.equals("Notification")) {
            return this.retrieveNotificationExportData(customConfigExcludeList, moduleType);
        }
        if (moduleType.equals("Dashboard")) {
            return this.downloadDashboardExportData(systemConfigIncludeList, customConfigExcludeList, moduleType);
        }
        if (moduleType.equals("FileManager")) {
            return this.retrieveFileManagerExportData(customConfigExcludeList, moduleType);
        }
        if (moduleType.equals("DynaRest")) {
            return this.downloadDashletExportData(systemConfigIncludeListInt, customConfigExcludeListInt, moduleType);
        }
        if (moduleType.equals("Permission")) {
            return this.retrievePermissionExportData(systemConfigIncludeList, moduleType);
        }
        if (moduleType.equals("SiteLayout")) {
            return this.retrieveSiteLayoutExportData(systemConfigIncludeList, moduleType);
        }
        if (moduleType.equals("Templates")) {
            return this.downloadTemplateExportData(systemConfigIncludeList, customConfigExcludeList, downloadFolderLocation, moduleType);
        }
        if (moduleType.equals("Dashlets")) {
            return this.downloadDashletExportData(systemConfigIncludeList, customConfigExcludeList, downloadFolderLocation, moduleType);
        }
        if (moduleType.equals("DynamicForm")) {
            return this.downloadDynamicFormExportData(systemConfigIncludeList, customConfigExcludeList, downloadFolderLocation, moduleType);
        }
        return null;
    }

    private XMLVO retrieveGridExportData(List<String> systemConfigIncludeList, List<String> customConfigExcludeList, String moduleType) throws Exception {
        List<Object> exportableList = this.importExportCrudDAO.getAllExportableData("FROM GridDetails AS gd WHERE (gd.gridId NOT IN :excludeCustomConfigList AND gd.gridTypeId = :customConfigType) OR (gd.gridId IN :includeSystemConfigList AND gd.gridTypeId = :systemConfigType)", systemConfigIncludeList, 2, customConfigExcludeList, 1);
        GridXMLVO gridXMLVO = null;
        if (exportableList != null && !exportableList.isEmpty()) {
            gridXMLVO = new GridXMLVO();
            for (Object obj : exportableList) {
                gridXMLVO.getGridDetails().add(((GridDetails)obj).getObject());
            }
            this.moduleListMap.put(moduleType.toLowerCase(), "XML");
        }
        return gridXMLVO;
    }

    private XMLVO retrieveRBExportData(List<String> systemConfigIncludeList, List<String> customConfigExcludeList, String moduleType) throws Exception {
        List<Object> exportableList = this.importExportCrudDAO.getRBExportableData("FROM ResourceBundle AS rb WHERE (rb.id.resourceKey NOT IN :excludeCustomConfigList AND rb.id.resourceKey not like :customConfigType) OR (rb.id.resourceKey IN :includeSystemConfigList AND rb.id.resourceKey like :systemConfigType)", systemConfigIncludeList, customConfigExcludeList);
        ResourceBundleXMLVO resourceBundleXMLVO = null;
        if (exportableList != null && !exportableList.isEmpty()) {
            resourceBundleXMLVO = new ResourceBundleXMLVO();
            for (Object obj : exportableList) {
                resourceBundleXMLVO.getResourceBundleDetails().add(((ResourceBundle)obj).getObject());
            }
            this.moduleListMap.put(moduleType.toLowerCase(), "XML");
        }
        return resourceBundleXMLVO;
    }

    private XMLVO retrieveAutocompleteExportData(List<String> systemConfigIncludeList, List<String> customConfigExcludeList, String moduleType) throws Exception {
        List<Object> exportableList = this.importExportCrudDAO.getAllExportableData("FROM Autocomplete AS au WHERE (au.autocompleteId NOT IN :excludeCustomConfigList AND au.acTypeId = :customConfigType) OR (au.autocompleteId IN :includeSystemConfigList AND au.acTypeId = :systemConfigType)", systemConfigIncludeList, 2, customConfigExcludeList, 1);
        AutocompleteXMLVO autocompleteXMLVO = null;
        if (exportableList != null && !exportableList.isEmpty()) {
            autocompleteXMLVO = new AutocompleteXMLVO();
            for (Object obj : exportableList) {
                autocompleteXMLVO.getAutocompleteDetails().add(((Autocomplete)obj).getObject());
            }
            this.moduleListMap.put(moduleType.toLowerCase(), "XML");
        }
        return autocompleteXMLVO;
    }

    private XMLVO retrieveNotificationExportData(List<String> customConfigExcludeList, String moduleType) throws Exception {
        List<Object> exportableList = this.importExportCrudDAO.getAllExportableData("FROM GenericUserNotification AS gun WHERE gun.notificationId NOT IN :excludeCustomConfigList", null, null, customConfigExcludeList, null);
        GenericUserNotificationXMLVO genericUserNotificationXMLVO = null;
        if (exportableList != null && !exportableList.isEmpty()) {
            genericUserNotificationXMLVO = new GenericUserNotificationXMLVO();
            for (Object obj : exportableList) {
                genericUserNotificationXMLVO.getGenericUserNotificationDetails().add(((GenericUserNotification)obj).getObject());
            }
            this.moduleListMap.put(moduleType.toLowerCase(), "XML");
        }
        return genericUserNotificationXMLVO;
    }

    private XMLVO downloadDashboardExportData(List<String> systemConfigIncludeList, List<String> customConfigExcludeList, String moduleType) throws Exception {
        List<Object> exportableList = this.importExportCrudDAO.getAllExportableData("FROM Dashboard AS db WHERE (db.dashboardId NOT IN :excludeCustomConfigList AND db.dashboardType = :customConfigType) OR (db.dashboardId IN :includeSystemConfigList AND db.dashboardType = :systemConfigType)", systemConfigIncludeList, 2, customConfigExcludeList, 1);
        DashboardXMLVO dashboardXMLVO = null;
        if (exportableList != null && !exportableList.isEmpty()) {
            dashboardXMLVO = new DashboardXMLVO();
            for (Object obj : exportableList) {
                dashboardXMLVO.getDashboardDetails().add(((Dashboard)obj).getObject());
            }
            this.moduleListMap.put(moduleType.toLowerCase(), "XML");
        }
        return dashboardXMLVO;
    }

    private XMLVO retrieveFileManagerExportData(List<String> customConfigExcludeList, String moduleType) throws Exception {
        List<Object> exportableList = this.importExportCrudDAO.getAllExportableData("FROM FileUploadConfig AS fu WHERE fu.fileUploadConfigId NOT IN :excludeCustomConfigList", null, null, customConfigExcludeList, null);
        FileManagerXMLVO fileManagerXMLVO = null;
        if (exportableList != null && !exportableList.isEmpty()) {
            fileManagerXMLVO = new FileManagerXMLVO();
            for (Object obj : exportableList) {
                fileManagerXMLVO.getFileUploadDetails().add(((FileUploadConfig)obj).getObject());
            }
            this.moduleListMap.put(moduleType.toLowerCase(), "XML");
        }
        return fileManagerXMLVO;
    }

    private XMLVO downloadDashletExportData(List<Integer> systemConfigIncludeListInt, List<Integer> customConfigExcludeListInt, String moduleType) throws Exception {
        List<Object> exportableList = this.importExportCrudDAO.getExportableDataWithIntegerList("FROM JwsDynamicRestDetail AS dr WHERE (dr.jwsDynamicRestId NOT IN :excludeCustomConfigList AND dr.jwsRequestTypeId = :customConfigType) OR (dr.jwsDynamicRestId IN :includeSystemConfigList AND dr.jwsRequestTypeId = :systemConfigType)", systemConfigIncludeListInt, 2, customConfigExcludeListInt, 1);
        DynaRestXMLVO dynaRestXMLVO = null;
        if (exportableList != null && !exportableList.isEmpty()) {
            dynaRestXMLVO = new DynaRestXMLVO();
            for (Object obj : exportableList) {
                dynaRestXMLVO.getDynaRestDetails().add(((JwsDynamicRestDetail)obj).getObject());
            }
            this.moduleListMap.put(moduleType.toLowerCase(), "XML");
        }
        return dynaRestXMLVO;
    }

    private XMLVO retrievePermissionExportData(List<String> systemConfigIncludeList, String moduleType) throws Exception {
        List<Object> exportableList = this.importExportCrudDAO.getAllExportableData("FROM JwsEntityRoleAssociation AS jr WHERE jr.entityRoleId IN :includeSystemConfigList", systemConfigIncludeList, null, null, null);
        PermissionXMLVO permissionXMLVO = null;
        if (exportableList != null && !exportableList.isEmpty()) {
            permissionXMLVO = new PermissionXMLVO();
            for (Object obj : exportableList) {
                permissionXMLVO.getJwsRoleDetails().add(((JwsEntityRoleAssociation)obj).getObject());
            }
            this.moduleListMap.put(moduleType.toLowerCase(), "XML");
        }
        return permissionXMLVO;
    }

    private XMLVO retrieveSiteLayoutExportData(List<String> systemConfigIncludeList, String moduleType) throws Exception {
        List<Object> exportableList = this.importExportCrudDAO.getAllExportableData("FROM ModuleListing AS ml WHERE ml.moduleId IN :includeSystemConfigList", systemConfigIncludeList, null, null, null);
        SiteLayoutXMLVO siteLayoutXMLVO = null;
        if (exportableList != null && !exportableList.isEmpty()) {
            siteLayoutXMLVO = new SiteLayoutXMLVO();
            for (Object obj : exportableList) {
                siteLayoutXMLVO.getModuleListingDetails().add(((ModuleListing)obj).getObject());
            }
            this.moduleListMap.put(moduleType.toLowerCase(), "XML");
        }
        return siteLayoutXMLVO;
    }

    private XMLVO downloadTemplateExportData(List<String> systemConfigIncludeList, List<String> customConfigExcludeList, String downloadFolderLocation, String moduleType) throws Exception {
        List<Object> exportableList = this.importExportCrudDAO.getAllExportableData("FROM TemplateMaster AS tm WHERE (tm.templateId NOT IN :excludeCustomConfigList AND tm.templateTypeId = :customConfigType) OR (tm.templateId IN :includeSystemConfigList AND tm.templateTypeId = :systemConfigType)", systemConfigIncludeList, 2, customConfigExcludeList, 1);
        if (exportableList != null && !exportableList.isEmpty()) {
            for (Object obj : exportableList) {
                this.templateDownloadUploadModule.downloadCodeToLocal((TemplateMaster)obj, downloadFolderLocation);
            }
            this.moduleListMap.put(moduleType.toLowerCase(), "FOLDER");
            XMLUtil.generateMetadataXML(null, this.templateDownloadUploadModule.getModuleDetailsMap(), downloadFolderLocation + File.separator + "Templates", this.version, this.userName, "");
        }
        return null;
    }

    private XMLVO downloadDashletExportData(List<String> systemConfigIncludeList, List<String> customConfigExcludeList, String downloadFolderLocation, String moduleType) throws Exception {
        List<Object> exportableList = this.importExportCrudDAO.getAllExportableData("FROM Dashlet AS dl WHERE (dl.dashletId NOT IN :excludeCustomConfigList AND dl.dashletTypeId = :customConfigType) OR (dl.dashletId IN :includeSystemConfigList AND dl.dashletTypeId = :systemConfigType)", systemConfigIncludeList, 2, customConfigExcludeList, 1);
        if (exportableList != null && !exportableList.isEmpty()) {
            for (Object obj : exportableList) {
                this.dashletDownloadUploadModule.downloadCodeToLocal((Dashlet)obj, downloadFolderLocation);
            }
            this.moduleListMap.put(moduleType.toLowerCase(), "FOLDER");
            XMLUtil.generateMetadataXML(null, this.dashletDownloadUploadModule.getModuleDetailsMap(), downloadFolderLocation + File.separator + "Dashlets", this.version, this.userName, "");
        }
        return null;
    }

    private XMLVO downloadDynamicFormExportData(List<String> systemConfigIncludeList, List<String> customConfigExcludeList, String downloadFolderLocation, String moduleType) throws Exception {
        List<Object> exportableList = this.importExportCrudDAO.getAllExportableData("FROM DynamicForm AS df WHERE (df.formId NOT IN :excludeCustomConfigList AND df.formTypeId = :customConfigType) OR (df.formId IN :includeSystemConfigList AND df.formTypeId = :systemConfigType)", systemConfigIncludeList, 2, customConfigExcludeList, 1);
        if (exportableList != null && !exportableList.isEmpty()) {
            for (Object obj : exportableList) {
                this.dynamicFormDownloadUploadModule.downloadCodeToLocal((DynamicForm)obj, downloadFolderLocation);
            }
            this.moduleListMap.put(moduleType.toLowerCase(), "FOLDER");
            XMLUtil.generateMetadataXML(null, this.dynamicFormDownloadUploadModule.getModuleDetailsMap(), downloadFolderLocation + File.separator + "DynamicForm", this.version, this.userName, "");
        }
        return null;
    }
}

