/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.trigyn.jws.dbutils.service.ModuleService;
import com.trigyn.jws.dbutils.utils.Constant;
import com.trigyn.jws.dbutils.vo.ModuleDetailsVO;
import com.trigyn.jws.dynamicform.dao.DynamicFormCrudDAO;
import com.trigyn.jws.dynamicform.dao.IDynamicFormQueriesRepository;
import com.trigyn.jws.dynamicform.entities.DynamicForm;
import com.trigyn.jws.dynamicform.entities.DynamicFormSaveQuery;
import com.trigyn.jws.dynamicform.service.DynamicFormService;
import com.trigyn.jws.gridutils.dao.GridUtilsDAO;
import com.trigyn.jws.gridutils.entities.GridDetails;
import com.trigyn.jws.gridutils.utility.Constants;
import com.trigyn.jws.resourcebundle.service.ResourceBundleService;
import com.trigyn.jws.resourcebundle.vo.ResourceBundleVO;
import com.trigyn.jws.templating.entities.TemplateMaster;
import com.trigyn.jws.templating.service.DBTemplatingService;
import com.trigyn.jws.templating.service.MenuService;
import com.trigyn.jws.templating.utils.TemplatingUtils;
import com.trigyn.jws.templating.vo.TemplateVO;
import com.trigyn.jws.usermanagement.repository.JwsMasterModulesRepository;
import com.trigyn.jws.usermanagement.utils.Constants;
import com.trigyn.jws.usermanagement.vo.JwsEntityRoleVO;
import com.trigyn.jws.webstarter.service.UserManagementService;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

@Service
@Transactional(readOnly=false)
public class MasterCreatorService {
    @Autowired
    private DynamicFormCrudDAO dynamicFormDAO = null;
    @Autowired
    private MenuService menuService = null;
    @Autowired
    private GridUtilsDAO gridUtilsDAO = null;
    @Autowired
    private DynamicFormService dynamicFormService = null;
    @Autowired
    private IDynamicFormQueriesRepository dynamicFormQueriesRepository = null;
    @Autowired
    private DBTemplatingService dbTemplatingService = null;
    @Autowired
    private TemplatingUtils templatingUtils = null;
    @Autowired
    private ModuleService moduleService = null;
    @Autowired
    private ResourceBundleService resourceBundleService = null;
    @Autowired
    private JwsMasterModulesRepository jwsMasterModulesRepository = null;
    @Autowired
    private UserManagementService userManagementService = null;

    public String getModuleDetails(HttpServletRequest httpServletRequest) throws Exception {
        HashMap<String, Object> templateMap = new HashMap<String, Object>();
        List tables = this.dynamicFormDAO.getAllTablesListInSchema();
        List views = this.dynamicFormDAO.getAllViewsListInSchema();
        List moduleListingVOList = this.moduleService.getAllParentModules("");
        String uri = httpServletRequest.getRequestURI();
        String url = httpServletRequest.getRequestURL().toString();
        StringBuilder urlPrefix = new StringBuilder();
        url = url.replace(uri, "");
        urlPrefix.append(url).append("/view/");
        templateMap.put("urlPrefix", urlPrefix);
        if (!CollectionUtils.isEmpty((Collection)views)) {
            tables.addAll(views);
        }
        templateMap.put("tables", tables);
        templateMap.put("tables", tables);
        templateMap.put("moduleListingVOList", moduleListingVOList);
        return this.menuService.getTemplateWithSiteLayout("master-creator", templateMap);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Map<String, Object> initMasterCreationScript(MultiValueMap<String, String> inputDetails) throws Exception {
        HashMap<String, Object> createdMasterDetails = new HashMap<String, Object>();
        Map<String, Object> formData = this.processFormData((String)inputDetails.getFirst((Object)"formData"));
        ModuleDetailsVO menuData = this.processMenu((String)inputDetails.getFirst((Object)"menuDetails"));
        DynamicForm dynamicForm = this.createDynamicFormDetails(inputDetails, formData);
        GridDetails gridDetails = this.createGridDetailsInfo(formData);
        TemplateMaster templateMaster = this.saveTemplateMasterDetails(inputDetails, gridDetails.getGridId(), dynamicForm.getFormId(), formData);
        menuData.setTargetTypeId(templateMaster.getTemplateId());
        menuData.setTargetLookupId(Integer.valueOf(5));
        menuData.setSequence(this.moduleService.getMaxSequenceByParent(menuData.getTargetTypeId()));
        String menuId = this.moduleService.saveModuleDetails(menuData);
        menuData.setModuleId(menuId);
        createdMasterDetails.put("dynamicForm", dynamicForm);
        createdMasterDetails.put("gridDetails", gridDetails);
        createdMasterDetails.put("templateMaster", templateMaster);
        createdMasterDetails.put("menuData", menuData);
        return createdMasterDetails;
    }

    @Transactional(readOnly=false)
    public void saveEntityRolesForMasterGenerator(Map<String, Object> createdObjDetails, List<String> roleIds) {
        DynamicForm dynamicForm = (DynamicForm)createdObjDetails.get("dynamicForm");
        GridDetails gridDetails = (GridDetails)createdObjDetails.get("gridDetails");
        TemplateMaster templateMaster = (TemplateMaster)createdObjDetails.get("templateMaster");
        ModuleDetailsVO menuData = (ModuleDetailsVO)createdObjDetails.get("menuData");
        JwsEntityRoleVO jwsDynamicEntity = new JwsEntityRoleVO();
        jwsDynamicEntity.setEntityId(dynamicForm.getFormId());
        jwsDynamicEntity.setEntityName(dynamicForm.getFormName());
        jwsDynamicEntity.setRoleIds(roleIds);
        String dynamicModuleId = this.jwsMasterModulesRepository.findBymoduleName(Constants.Modules.DYNAMICFORM.getModuleName()).getModuleId();
        jwsDynamicEntity.setModuleId(dynamicModuleId);
        this.userManagementService.deleteAndSaveEntityRole(jwsDynamicEntity);
        JwsEntityRoleVO jwsGridEntity = new JwsEntityRoleVO();
        jwsGridEntity.setEntityId(gridDetails.getGridId());
        jwsGridEntity.setEntityName(gridDetails.getGridName());
        jwsGridEntity.setRoleIds(roleIds);
        String gridModuleId = this.jwsMasterModulesRepository.findBymoduleName(Constants.Modules.GRIDUTILS.getModuleName()).getModuleId();
        jwsGridEntity.setModuleId(gridModuleId);
        this.userManagementService.deleteAndSaveEntityRole(jwsGridEntity);
        JwsEntityRoleVO jwsTemplateEntity = new JwsEntityRoleVO();
        jwsTemplateEntity.setEntityId(templateMaster.getTemplateId());
        jwsTemplateEntity.setEntityName(templateMaster.getTemplateName());
        jwsTemplateEntity.setRoleIds(roleIds);
        String templateModuleId = this.jwsMasterModulesRepository.findBymoduleName(Constants.Modules.TEMPLATING.getModuleName()).getModuleId();
        jwsTemplateEntity.setModuleId(templateModuleId);
        this.userManagementService.deleteAndSaveEntityRole(jwsTemplateEntity);
        if (StringUtils.isNotBlank((CharSequence)menuData.getModuleId())) {
            JwsEntityRoleVO jwsMenuEntity = new JwsEntityRoleVO();
            jwsMenuEntity.setEntityId(menuData.getModuleId());
            jwsMenuEntity.setEntityName(menuData.getModuleName());
            jwsMenuEntity.setRoleIds(roleIds);
            String menuModuleId = this.jwsMasterModulesRepository.findBymoduleName(Constants.Modules.SITELAYOUT.getModuleName()).getModuleId();
            jwsMenuEntity.setModuleId(menuModuleId);
            this.userManagementService.deleteAndSaveEntityRole(jwsMenuEntity);
        }
    }

    private ModuleDetailsVO processMenu(String menuDetails) {
        Gson gson = new Gson();
        JsonParser parser = new JsonParser();
        JsonObject object = (JsonObject)parser.parse(menuDetails);
        ModuleDetailsVO moduleDetailsVO = (ModuleDetailsVO)gson.fromJson((JsonElement)object, ModuleDetailsVO.class);
        moduleDetailsVO.setIsInsideMenu(Constant.IS_INSIDE_MENU);
        return moduleDetailsVO;
    }

    private Map<String, Object> processFormData(String formData) {
        ArrayList masterDetails = Lists.newArrayList((Object[])formData.split("&"));
        HashMap<String, Object> masterDetailsMap = new HashMap<String, Object>();
        for (String details : masterDetails) {
            String[] fieldDetails = details.split("=");
            if (fieldDetails.length != 2) continue;
            masterDetailsMap.put(fieldDetails[0], URLDecoder.decode(fieldDetails[1]));
        }
        return masterDetailsMap;
    }

    private DynamicForm createDynamicFormDetails(MultiValueMap<String, String> inputDetails, Map<String, Object> formData) throws Exception {
        String tableName = formData.get("selectTable").toString();
        String primaryKey = formData.get("primaryKey").toString();
        String moduleName = formData.get("moduleName") + "-form";
        String description = formData.get("moduleName") + " Form";
        List formDetailsString = (List)new ObjectMapper().convertValue(inputDetails.get((Object)"formDetails"), List.class);
        String jsonString = ((String)formDetailsString.get(0)).toString();
        List formDetails = (List)new ObjectMapper().readValue(jsonString, List.class);
        for (Map map : formDetails) {
            this.saveResourseKey(map);
        }
        String selectQuery = this.generateSelectQueryForForm(tableName, formDetails, primaryKey);
        Map<String, String> dynamicFormDetails = this.generateHtmlTemplate(tableName, formDetails);
        String saveQuery = dynamicFormDetails.get("save-template");
        String htmlTemplate = dynamicFormDetails.get("form-template");
        DynamicForm dynamicForm = new DynamicForm();
        dynamicForm.setFormDescription(description);
        dynamicForm.setFormSelectQuery(selectQuery);
        dynamicForm.setFormBody(htmlTemplate);
        dynamicForm.setFormName(moduleName);
        dynamicForm.setCreatedBy("admin");
        dynamicForm.setCreatedDate(new Date());
        this.dynamicFormDAO.saveDynamicFormData(dynamicForm);
        DynamicFormSaveQuery dynamicFormSaveQuery = new DynamicFormSaveQuery();
        dynamicFormSaveQuery.setSequence(Integer.valueOf(1));
        dynamicFormSaveQuery.setDynamicFormId(dynamicForm.getFormId());
        dynamicFormSaveQuery.setDynamicFormSaveQuery(saveQuery);
        this.dynamicFormQueriesRepository.save((Object)dynamicFormSaveQuery);
        return dynamicForm;
    }

    private void saveResourseKey(Map<String, Object> map) throws Exception {
        Boolean keyAlreadyExist;
        String i18nResourceKey = map.get("i18nResourceKey").toString();
        String displayName = map.get("displayName").toString();
        if (!i18nResourceKey.isBlank() && !(keyAlreadyExist = this.resourceBundleService.checkResourceKeyExist(i18nResourceKey)).booleanValue()) {
            ArrayList<ResourceBundleVO> dbResourceList = new ArrayList<ResourceBundleVO>();
            ResourceBundleVO resourceBundleVO = new ResourceBundleVO();
            resourceBundleVO.setLanguageId(Integer.valueOf(1));
            resourceBundleVO.setResourceKey(i18nResourceKey);
            resourceBundleVO.setText(displayName);
            dbResourceList.add(resourceBundleVO);
            this.resourceBundleService.saveResourceBundleDetails(dbResourceList, Integer.valueOf(1));
        }
    }

    private Map<String, String> generateHtmlTemplate(String tableName, List<Map<String, Object>> formDetails) {
        List tableDetails = this.dynamicFormDAO.getTableDetailsByTableName(tableName);
        Iterator itr = tableDetails.iterator();
        Set matchedColumns = formDetails.stream().map(column -> column.get("column").toString()).collect(Collectors.toSet());
        while (itr.hasNext()) {
            Map columnDetails = (Map)itr.next();
            String columnName = columnDetails.get("tableColumnName").toString();
            if (!Boolean.FALSE.equals(matchedColumns.contains(columnName))) continue;
            itr.remove();
        }
        Map templateDetails = this.dynamicFormService.createDefaultFormByTableName(tableName, tableDetails);
        return templateDetails;
    }

    private String generateSelectQueryForForm(String tableName, List<Map<String, Object>> formDetails, String primaryKey) {
        StringBuilder selectQuery = new StringBuilder("SELECT ");
        StringJoiner columns = new StringJoiner(",");
        for (Map<String, Object> details : formDetails) {
            columns.add(details.get("column").toString());
        }
        selectQuery.append(columns.toString()).append(" FROM ").append(tableName).append(" WHERE ");
        StringJoiner whereClause = new StringJoiner(" AND ");
        ArrayList primaryKeys = Lists.newArrayList((Object[])primaryKey.split(","));
        for (String key : primaryKeys) {
            String value = key + " = \\\"${" + key.replaceAll("_", "") + "}\\\"";
            whereClause.add(value.replace("\\", ""));
        }
        selectQuery.append(whereClause.toString());
        return selectQuery.toString();
    }

    private GridDetails createGridDetailsInfo(Map<String, Object> formData) {
        String moduleName = formData.get("moduleName") + "Grid".replaceAll("-", "");
        String description = formData.get("moduleName") + " Listing";
        String tableName = formData.get("selectTable").toString();
        String columns = formData.get("columns").toString();
        GridDetails details = new GridDetails(moduleName, moduleName, description, tableName, columns, Integer.valueOf(Constants.queryImplementationType.VIEW.getType()));
        return this.gridUtilsDAO.saveGridDetails(details);
    }

    private TemplateMaster saveTemplateMasterDetails(MultiValueMap<String, String> inputDetails, String gridId, String formId, Map<String, Object> formData) throws Exception {
        List gridDetailsString = (List)new ObjectMapper().convertValue(inputDetails.get((Object)"gridDetails"), List.class);
        String moduleName = formData.get("moduleName") + "-template";
        String jsonString = ((String)gridDetailsString.get(0)).toString();
        List gridDetails = (List)new ObjectMapper().readValue(jsonString, List.class);
        String primaryKey = formData.get("primaryKey").toString();
        List primaryKeysIds = Lists.newArrayList((Object[])primaryKey.split(",")).stream().map(element -> element.replaceAll("_", "")).collect(Collectors.toList());
        HashMap<String, String> details = new HashMap<String, String>();
        for (String ids : primaryKeysIds) {
            details.put(ids, "");
        }
        ArrayList primaryKeys = Lists.newArrayList((Object[])primaryKey.split(","));
        HashMap<String, Object> templateMap = new HashMap<String, Object>();
        templateMap.put("formId", formId);
        templateMap.put("gridId", gridId);
        templateMap.put("primaryKeysIds", primaryKeysIds);
        templateMap.put("primaryKeys", primaryKeys);
        templateMap.put("gridDetails", gridDetails);
        templateMap.put("primaryKeyObject", new ObjectMapper().writeValueAsString(details));
        TemplateVO templateVO = this.dbTemplatingService.getTemplateByName("system-listing-template");
        String template = this.templatingUtils.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), templateMap);
        TemplateMaster templateMaster = new TemplateMaster();
        templateMaster.setTemplateName(moduleName);
        templateMaster.setTemplate(template);
        templateMaster.setUpdatedDate(new Date());
        templateMaster.setCreatedBy("admin");
        templateMaster.setUpdatedBy("admin");
        return this.dbTemplatingService.saveTemplateMaster(templateMaster);
    }

    public List<Map<String, Object>> getTableDetails(String tableName) {
        return this.dynamicFormDAO.getTableInformationByName(tableName);
    }
}

