/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.trigyn.jws.dbutils.service.ModuleVersionService;
import com.trigyn.jws.dbutils.service.PropertyMasterService;
import com.trigyn.jws.dynamicform.service.DynamicFormService;
import com.trigyn.jws.typeahead.service.TypeAheadService;
import com.trigyn.jws.webstarter.service.DynamicFormCrudService;
import com.trigyn.jws.webstarter.service.DynarestCrudService;
import com.trigyn.jws.webstarter.utils.Constant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class ModuleRevisionService {
    @Autowired
    private ModuleVersionService moduleVersionService = null;
    @Autowired
    private DynamicFormService dynamicFormService = null;
    @Autowired
    private TypeAheadService typeAheadService = null;
    @Autowired
    private DynamicFormCrudService dynamicFormCrudService = null;
    @Autowired
    private PropertyMasterService propertyMasterService = null;
    @Autowired
    private DynarestCrudService dynarestCrudService = null;

    public void saveModuleVersioning(MultiValueMap<String, String> formData, Integer sourceTypeId) throws Exception {
        HashMap versioningData = new HashMap();
        String primaryKey = null;
        String entityName = null;
        for (Map.Entry formDataMap : formData.entrySet()) {
            versioningData.put((String)formDataMap.getKey(), ((List)formDataMap.getValue()).get(0));
        }
        if (versioningData.get("primaryKey") != null) {
            primaryKey = versioningData.get("primaryKey").toString();
        }
        if (versioningData.get("entityName") != null) {
            entityName = versioningData.get("entityName").toString();
        }
        this.moduleVersionService.saveModuleVersion(versioningData, null, (Object)primaryKey, entityName, sourceTypeId);
    }

    public void saveUpdatedContent(HttpServletRequest a_httpServletRequest) throws Exception {
        String modifiedContent = a_httpServletRequest.getParameter("modifiedContent");
        String moduleType = a_httpServletRequest.getParameter("moduleType");
        ObjectMapper objectMapper = new ObjectMapper();
        Map formData = (Map)objectMapper.readValue(modifiedContent, Map.class);
        LinkedMultiValueMap multivalueMap = new LinkedMultiValueMap();
        for (Map.Entry formDataMap : formData.entrySet()) {
            ArrayList<String> multiValueString = new ArrayList<String>();
            if (formDataMap.getValue() == null) continue;
            Object formValue = formDataMap.getValue();
            multiValueString.add(formValue.toString());
            multivalueMap.put((Object)((String)formDataMap.getKey()), multiValueString);
        }
        if (moduleType.equals(Constant.ModuleType.AUTOCOMPLETE.getModuleType())) {
            this.typeAheadService.saveAutocompleteDetails((MultiValueMap)multivalueMap, Constant.REVISION_SOURCE_VERSION_TYPE);
        } else if (moduleType.equals(Constant.ModuleType.DYNAMICFORM.getModuleType())) {
            this.dynamicFormCrudService.saveDynamicFormDetails((MultiValueMap<String, String>)multivalueMap, Constant.REVISION_SOURCE_VERSION_TYPE);
        } else {
            this.dynamicFormService.saveDynamicForm((MultiValueMap)multivalueMap);
            if (moduleType.equals(Constant.ModuleType.DYNAREST.getModuleType())) {
                this.dynarestCrudService.deleteDAOQueries((MultiValueMap<String, String>)multivalueMap);
                this.dynarestCrudService.saveDAOQueries((MultiValueMap<String, String>)multivalueMap);
            }
            this.saveModuleVersioning((MultiValueMap<String, String>)multivalueMap, Constant.REVISION_SOURCE_VERSION_TYPE);
        }
    }

    public Map<String, Object> getModuleVersioningData(HttpServletRequest a_httpServletRequest) throws Exception {
        String moduleType = a_httpServletRequest.getParameter("moduleType");
        String entityId = a_httpServletRequest.getParameter("entityId");
        String saveUrl = a_httpServletRequest.getParameter("saveUrl");
        String previousPageUrl = a_httpServletRequest.getParameter("previousPageUrl");
        String formId = a_httpServletRequest.getParameter("formId");
        String dateFormat = this.propertyMasterService.getDateFormatByName("system", "system", "jws-date-format", "db");
        List versionVOs = this.moduleVersionService.fetchModuleVersionDetails(entityId);
        String moduleName = a_httpServletRequest.getParameter("moduleName");
        HashMap<String, Object> templateMap = new HashMap<String, Object>();
        templateMap.put("moduleType", moduleType);
        templateMap.put("entityId", entityId);
        templateMap.put("revesionDetailsVOs", versionVOs);
        templateMap.put("moduleName", moduleName);
        templateMap.put("formId", formId);
        templateMap.put("saveUrl", saveUrl);
        templateMap.put("dateFormat", dateFormat);
        templateMap.put("previousPageUrl", previousPageUrl);
        return templateMap;
    }
}

