/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.service;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.trigyn.jws.dbutils.service.PropertyMasterService;
import com.trigyn.jws.templating.service.DBTemplatingService;
import com.trigyn.jws.webstarter.dao.SendMailDAO;
import com.trigyn.jws.webstarter.entities.MailHistory;
import com.trigyn.jws.webstarter.utils.Email;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SendMailService {
    @Autowired
    private DBTemplatingService dbTemplatingService = null;
    @Autowired
    private PropertyMasterService propertyMasterService = null;
    @Autowired
    private SendMailDAO sendMailDao = null;

    @Async
    public CompletableFuture<Boolean> sendTestMail(Email mail) throws Exception {
        String smtpAuth;
        String jsonString = this.propertyMasterService.findPropertyMasterValue("mail-configuration");
        Map mailMap = (Map)new Gson().fromJson(jsonString, new TypeToken<Map<String, String>>(){}.getType());
        class SMTPAuthenticator
        extends Authenticator {
            String username = "";
            String password = "";

            protected SMTPAuthenticator(String username, String password) {
                this.username = username;
                this.password = password;
            }

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(this.username, this.password);
            }
        }
        SMTPAuthenticator authenticator = null;
        Session session = null;
        Properties prop = new Properties();
        String stmpPort = (String)mailMap.get("smtpPort");
        String smtpSecurityProtocal = (String)mailMap.get("smtpSecurityProtocal");
        prop.setProperty("mail.smtp.host", (String)mailMap.get("smtpHost"));
        prop.setProperty("mail.smtp.port", stmpPort);
        if (smtpSecurityProtocal != null && smtpSecurityProtocal != "") {
            if (smtpSecurityProtocal.equals("SSL")) {
                prop.setProperty("mail.smtp.socketFactory.port", stmpPort);
                prop.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                prop.setProperty("mail.smtp.socketFactory.fallback", "true");
                prop.setProperty("mail.smtp.ssl.trust", "*");
            } else if (smtpSecurityProtocal.equals("TLS")) {
                prop.setProperty("mail.smtp.starttls.enable", "true");
            }
        }
        if ((smtpAuth = (String)mailMap.get("isAuthenticated")) != null && smtpAuth != "" && smtpAuth.equals("true")) {
            prop.put("mail.smtp.auth", Boolean.TRUE);
            prop.setProperty("mail.smtp.user", (String)mailMap.get("userName"));
            prop.setProperty("mail.smtp.password", (String)mailMap.get("password"));
            authenticator = new SMTPAuthenticator((String)mailMap.get("userName"), (String)mailMap.get("password"));
            session = Session.getInstance((Properties)prop, (Authenticator)authenticator);
        } else {
            session = Session.getDefaultInstance((Properties)prop, null);
            prop.put("mail.smtp.auth", Boolean.FALSE);
        }
        Boolean isSent = true;
        MimeMessage message = new MimeMessage(session);
        MimeMultipart mimeMultipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        Object mailBody = "";
        String fromMailId = mail.getMailFrom();
        String fromMailName = mail.getMailFromName();
        Boolean isReplyToDifferentMail = mail.getIsReplyToDifferentMail();
        InternetAddress replyToDifferentEmailId = mail.getReplyToDifferentMailId();
        InternetAddress[] mailToList = mail.getInternetAddressToArray();
        InternetAddress[] ccList = mail.getInternetAddressCCArray();
        InternetAddress[] bccList = mail.getInternetAddressBCCArray();
        Boolean isMailFooterRequired = mail.getIsMailFooterEnabled();
        String mailFooter = mail.getMailFooter();
        try {
            if (fromMailId == null || fromMailId == "" || !SendMailService.isValidEmailAddressFromStringValidation(fromMailId)) {
                message.setFrom("fromMailId@notFound.com");
                throw new Exception("Invalid/No From Emailid entered" + fromMailId);
            }
            message.setFrom((Address)new InternetAddress(fromMailId, fromMailName));
            if (isReplyToDifferentMail != null && isReplyToDifferentMail.equals(Boolean.TRUE)) {
                if (SendMailService.isValidEmailInternetAddress(replyToDifferentEmailId)) {
                    message.setReplyTo(new Address[]{replyToDifferentEmailId});
                } else {
                    message.setReplyTo((Address[])InternetAddress.parse((String)"inVallidOrNoREPLYTOMailId@required.com"));
                    throw new Exception("Invalid/No Reply to  Emailid entered " + replyToDifferentEmailId);
                }
            }
            if (mailToList == null) {
                message.addRecipients(Message.RecipientType.TO, "atleastOneTOMailId@required.com");
                throw new Exception("To mail id missing  ");
            }
            message.addRecipients(Message.RecipientType.TO, (Address[])mailToList);
            if (ccList != null) {
                message.addRecipients(Message.RecipientType.CC, (Address[])ccList);
            }
            if (bccList != null) {
                message.addRecipients(Message.RecipientType.BCC, (Address[])bccList);
            }
            if (mail.getSubject() != null && mail.getSubject() != "") {
                message.setSubject(mail.getSubject());
            }
            if (mail.getBody() != null && mail.getBody() != "") {
                mailBody = mail.getBody();
            }
            if (isMailFooterRequired != null && isMailFooterRequired.equals(Boolean.TRUE) && mailFooter != "") {
                mailBody = (String)mailBody + "\t<br>" + mail.getMailFooter();
            }
            messageBodyPart.setContent(mailBody, "text/html; charset=utf-8");
            mimeMultipart.addBodyPart((BodyPart)messageBodyPart);
            if (mail.getAttachementsArray() != null && !mail.getAttachementsArray().isEmpty()) {
                for (File attachedFile : mail.getAttachementsArray()) {
                    MimeBodyPart atachmentBodyPart = new MimeBodyPart();
                    FileDataSource source = new FileDataSource(attachedFile);
                    atachmentBodyPart.setDataHandler(new DataHandler((DataSource)source));
                    atachmentBodyPart.setFileName(attachedFile.getName());
                    mimeMultipart.addBodyPart((BodyPart)atachmentBodyPart);
                }
            }
            message.setSentDate(new Date());
            message.setContent((Multipart)mimeMultipart);
            Transport.send((Message)message);
        }
        catch (Exception e) {
            isSent = false;
            e.printStackTrace();
            if (mailBody != "") {
                messageBodyPart.setContent(mailBody, "text/html; charset=utf-8");
            } else if (mail.getBody() != null && mail.getBody() != "") {
                messageBodyPart.setContent((Object)mail.getBody(), "text/html; charset=utf-8");
            } else {
                messageBodyPart.setContent((Object)"", "text/html; charset=utf-8");
            }
            mimeMultipart.addBodyPart((BodyPart)messageBodyPart);
            message.setContent((Multipart)mimeMultipart);
            try {
                String emailEMLFile = UUID.randomUUID().toString();
                String filePath = "d:/" + emailEMLFile + "_Mail.eml";
                message.writeTo((OutputStream)new FileOutputStream(new File(filePath)));
                MailHistory mailHistory = new MailHistory();
                String uuidGenerated = UUID.randomUUID().toString();
                mailHistory.setFailedMailId(uuidGenerated);
                if (fromMailId == null) {
                    mailHistory.setMailSentBy("fromMailId@notFound.com");
                } else {
                    mailHistory.setMailSentBy(fromMailId.toString());
                }
                if (mailToList == null) {
                    mailHistory.setMailSentTo("atleastOneTOMailId@required.com");
                } else {
                    mailHistory.setMailSentTo(mailToList.toString());
                }
                mailHistory.setMailFaliedTime(Calendar.getInstance());
                mailHistory.setEmlFilePath(filePath);
                this.sendMailDao.saveFailedMails(mailHistory);
            }
            catch (IOException | MessagingException e1) {
                isSent = false;
                e1.printStackTrace();
            }
        }
        return CompletableFuture.completedFuture(isSent);
    }

    public static boolean isValidEmailAddressFromStringValidation(String email) {
        boolean result = true;
        try {
            InternetAddress emailAddr = new InternetAddress(email);
            emailAddr.validate();
        }
        catch (AddressException ex) {
            result = false;
        }
        return result;
    }

    private static boolean isValidEmailInternetAddress(InternetAddress emailAddr) {
        boolean result = true;
        try {
            emailAddr.validate();
        }
        catch (AddressException ex) {
            result = false;
        }
        return result;
    }

    @Async
    public CompletableFuture<Boolean> sendTestMail(Email mail, String jsonString) throws Exception {
        String mailFooterString;
        String smtpAuth;
        Map mailMap = (Map)new Gson().fromJson(jsonString, new TypeToken<Map<String, String>>(){}.getType());
        class SMTPAuthenticator
        extends Authenticator {
            String username = "";
            String password = "";

            protected SMTPAuthenticator(String username, String password) {
                this.username = username;
                this.password = password;
            }

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(this.username, this.password);
            }
        }
        SMTPAuthenticator authenticator = null;
        Session session = null;
        Properties prop = new Properties();
        String stmpPort = (String)mailMap.get("smtpPort");
        String smtpSecurityProtocal = (String)mailMap.get("smtpSecurityProtocal");
        prop.setProperty("mail.smtp.host", (String)mailMap.get("smtpHost"));
        prop.setProperty("mail.smtp.port", stmpPort);
        if (smtpSecurityProtocal != null && smtpSecurityProtocal != "") {
            if (smtpSecurityProtocal.equals("SSL")) {
                prop.setProperty("mail.smtp.socketFactory.port", stmpPort);
                prop.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                prop.setProperty("mail.smtp.socketFactory.fallback", "true");
                prop.setProperty("mail.smtp.ssl.trust", "*");
            } else if (smtpSecurityProtocal.equals("TLS")) {
                prop.setProperty("mail.smtp.starttls.enable", "true");
            }
        }
        if ((smtpAuth = (String)mailMap.get("isAuthenticated")) != null && smtpAuth != "" && smtpAuth.equals("true")) {
            prop.put("mail.smtp.auth", Boolean.TRUE);
            prop.setProperty("mail.smtp.user", (String)mailMap.get("userName"));
            prop.setProperty("mail.smtp.password", (String)mailMap.get("password"));
            authenticator = new SMTPAuthenticator((String)mailMap.get("userName"), (String)mailMap.get("password"));
            session = Session.getInstance((Properties)prop, (Authenticator)authenticator);
        } else {
            session = Session.getDefaultInstance((Properties)prop, null);
            prop.put("mail.smtp.auth", Boolean.FALSE);
        }
        Boolean isSent = true;
        MimeMessage message = new MimeMessage(session);
        MimeMultipart mimeMultipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        Object mailBody = "";
        String fromMailId = mailMap.get("mailFrom") != null && mailMap.get("mailFrom") != "" ? (String)mailMap.get("mailFrom") : mail.getMailFrom();
        String fromMailName = mailMap.get("mailFromName") != null && mailMap.get("mailFromName") != "" ? (String)mailMap.get("mailFromName") : mail.getMailFromName();
        String isReply = (String)mailMap.get("isReplyToDifferentMail");
        Boolean isReplyToDifferentMail = isReply != null && !isReply.isEmpty() ? Boolean.parseBoolean(isReply) : false;
        if (!isReplyToDifferentMail.booleanValue() && mail.getIsReplyToDifferentMail() != null) {
            isReplyToDifferentMail = mail.getIsReplyToDifferentMail();
        }
        String replyEmailAddress = mailMap.get("replyToDifferentMailId") != null && !((String)mailMap.get("replyToDifferentMailId")).isEmpty() ? (String)mailMap.get("replyToDifferentMailId") : "";
        InternetAddress replyToDifferentEmailId = null;
        replyToDifferentEmailId = isReplyToDifferentMail != false && replyEmailAddress != "" ? new InternetAddress(replyEmailAddress) : mail.getReplyToDifferentMailId();
        InternetAddress[] mailToList = null;
        mailToList = mailMap.get("internetAddressToArray") != "" && mailMap.get("internetAddressToArray") != null ? InternetAddress.parse((String)((String)mailMap.get("internetAddressToArray"))) : mail.getInternetAddressToArray();
        InternetAddress[] ccList = null;
        ccList = mailMap.get("internetAddressCCArray") != null && mailMap.get("internetAddressCCArray") != "" ? InternetAddress.parse((String)((String)mailMap.get("internetAddressCCArray"))) : mail.getInternetAddressCCArray();
        InternetAddress[] bccList = null;
        bccList = mailMap.get("internetAddressBCCArray") != null && mailMap.get("internetAddressBCCArray") != "" ? InternetAddress.parse((String)((String)mailMap.get("internetAddressBCCArray"))) : mail.getInternetAddressBCCArray();
        String footerExists = (String)mailMap.get("isMailFooterEnabled");
        Boolean isMailFooterRequired = footerExists != null && !footerExists.isEmpty() ? Boolean.parseBoolean(footerExists) : mail.getIsMailFooterEnabled();
        mail.setIsMailFooterEnabled(isMailFooterRequired);
        String string = mailFooterString = mailMap.get("mailFooter") != null && !((String)mailMap.get("mailFooter")).isEmpty() ? (String)mailMap.get("mailFooter") : mail.getMailFooter();
        if (isMailFooterRequired.booleanValue() && mailFooterString != "") {
            mail.setMailFooter(mailFooterString);
        }
        try {
            if (fromMailId == null || fromMailId == "" || !SendMailService.isValidEmailAddressFromStringValidation(fromMailId)) {
                throw new Exception("Invalid/No From Emailid entered" + fromMailId);
            }
            message.setFrom((Address)new InternetAddress(fromMailId, fromMailName));
            if (isReplyToDifferentMail != null && isReplyToDifferentMail.equals(Boolean.TRUE)) {
                if (replyToDifferentEmailId != null && SendMailService.isValidEmailInternetAddress(replyToDifferentEmailId)) {
                    message.setReplyTo(new Address[]{replyToDifferentEmailId});
                } else {
                    throw new Exception("Invalid/No Reply to  Emailid entered " + replyToDifferentEmailId);
                }
            }
            if (mailToList == null) {
                throw new Exception("To mail id missing  ");
            }
            message.addRecipients(Message.RecipientType.TO, (Address[])mailToList);
            if (ccList != null) {
                message.addRecipients(Message.RecipientType.CC, (Address[])ccList);
            }
            if (bccList != null) {
                message.addRecipients(Message.RecipientType.BCC, (Address[])bccList);
            }
            if (mail.getSubject() != null && mail.getSubject() != "") {
                message.setSubject(mail.getSubject());
            }
            if (mail.getBody() != null && mail.getBody() != "") {
                mailBody = mail.getBody();
            }
            if (mail.getIsMailFooterEnabled() != null && mail.getIsMailFooterEnabled().equals(Boolean.TRUE)) {
                mailBody = (String)mailBody + "\t<br>" + mail.getMailFooter();
            }
            messageBodyPart.setContent(mailBody, "text/html; charset=utf-8");
            mimeMultipart.addBodyPart((BodyPart)messageBodyPart);
            if (mail.getAttachementsArray() != null && !mail.getAttachementsArray().isEmpty()) {
                for (File attachedFile : mail.getAttachementsArray()) {
                    MimeBodyPart atachmentBodyPart = new MimeBodyPart();
                    FileDataSource source = new FileDataSource(attachedFile);
                    atachmentBodyPart.setDataHandler(new DataHandler((DataSource)source));
                    atachmentBodyPart.setFileName(attachedFile.getName());
                    mimeMultipart.addBodyPart((BodyPart)atachmentBodyPart);
                }
            }
            message.setSentDate(new Date());
            message.setContent((Multipart)mimeMultipart);
            Transport.send((Message)message);
        }
        catch (Exception e) {
            isSent = false;
            e.printStackTrace();
            if (mailBody != "") {
                messageBodyPart.setContent(mailBody, "text/html; charset=utf-8");
            } else if (mail.getBody() != null && mail.getBody() != "") {
                messageBodyPart.setContent((Object)mail.getBody(), "text/html; charset=utf-8");
            } else {
                messageBodyPart.setContent((Object)"", "text/html; charset=utf-8");
            }
            mimeMultipart.addBodyPart((BodyPart)messageBodyPart);
            message.setContent((Multipart)mimeMultipart);
            try {
                String emailEMLFile = UUID.randomUUID().toString();
                String filePath = "d:/" + emailEMLFile + "_Mail.eml";
                message.writeTo((OutputStream)new FileOutputStream(new File(filePath)));
                MailHistory mailHistory = new MailHistory();
                String uuidGenerated = UUID.randomUUID().toString();
                mailHistory.setFailedMailId(uuidGenerated);
                if (fromMailId == null) {
                    mailHistory.setMailSentBy("fromMailId@notFound.com");
                } else {
                    mailHistory.setMailSentBy(fromMailId.toString());
                }
                if (mailToList == null) {
                    mailHistory.setMailSentTo("atleastOneTOMailId@required.com");
                } else {
                    mailHistory.setMailSentTo(mailToList.toString());
                }
                mailHistory.setMailFaliedTime(Calendar.getInstance());
                mailHistory.setEmlFilePath(filePath);
                this.sendMailDao.saveFailedMails(mailHistory);
            }
            catch (IOException | MessagingException e1) {
                isSent = false;
                e1.printStackTrace();
            }
        }
        return CompletableFuture.completedFuture(isSent);
    }
}

