/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.service;

import com.trigyn.jws.dbutils.entities.PropertyMaster;
import com.trigyn.jws.dbutils.repository.PropertyMasterRepository;
import com.trigyn.jws.dbutils.service.PropertyMasterService;
import com.trigyn.jws.dbutils.spi.IUserDetailsService;
import com.trigyn.jws.templating.service.DBTemplatingService;
import com.trigyn.jws.templating.service.MenuService;
import com.trigyn.jws.templating.utils.TemplatingUtils;
import com.trigyn.jws.templating.vo.TemplateVO;
import com.trigyn.jws.usermanagement.entities.JwsAuthenticationType;
import com.trigyn.jws.usermanagement.entities.JwsEntityRoleAssociation;
import com.trigyn.jws.usermanagement.entities.JwsMasterModules;
import com.trigyn.jws.usermanagement.entities.JwsRole;
import com.trigyn.jws.usermanagement.entities.JwsRoleMasterModulesAssociation;
import com.trigyn.jws.usermanagement.entities.JwsUser;
import com.trigyn.jws.usermanagement.entities.JwsUserRoleAssociation;
import com.trigyn.jws.usermanagement.repository.JwsAuthenticationTypeRepository;
import com.trigyn.jws.usermanagement.repository.JwsEntityRoleAssociationRepository;
import com.trigyn.jws.usermanagement.repository.JwsMasterModulesRepository;
import com.trigyn.jws.usermanagement.repository.JwsRoleMasterModulesAssociationRepository;
import com.trigyn.jws.usermanagement.repository.JwsRoleRepository;
import com.trigyn.jws.usermanagement.repository.JwsUserRepository;
import com.trigyn.jws.usermanagement.repository.JwsUserRoleAssociationRepository;
import com.trigyn.jws.usermanagement.repository.UserManagementDAO;
import com.trigyn.jws.usermanagement.security.config.ApplicationSecurityDetails;
import com.trigyn.jws.usermanagement.security.config.UserInformation;
import com.trigyn.jws.usermanagement.utils.Constants;
import com.trigyn.jws.usermanagement.vo.JwsAuthenticationTypeVO;
import com.trigyn.jws.usermanagement.vo.JwsEntityRoleAssociationVO;
import com.trigyn.jws.usermanagement.vo.JwsEntityRoleVO;
import com.trigyn.jws.usermanagement.vo.JwsMasterModulesVO;
import com.trigyn.jws.usermanagement.vo.JwsRoleMasterModulesAssociationVO;
import com.trigyn.jws.usermanagement.vo.JwsRoleVO;
import com.trigyn.jws.usermanagement.vo.JwsUserVO;
import com.trigyn.jws.webstarter.service.SendMailService;
import com.trigyn.jws.webstarter.utils.Email;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UserManagementService {
    @Autowired
    private JwsRoleRepository jwsRoleRepository = null;
    @Autowired
    private JwsMasterModulesRepository jwsmasterModuleRepository = null;
    @Autowired
    private JwsRoleMasterModulesAssociationRepository roleModuleRepository = null;
    @Autowired
    private MenuService menuService = null;
    @Autowired
    private JwsUserRepository jwsUserRepository = null;
    @Autowired
    private UserManagementDAO userManagementDAO = null;
    @Autowired
    private JwsUserRoleAssociationRepository userRoleRepository = null;
    @Autowired
    private PropertyMasterRepository propertyMasterRepository = null;
    @Autowired
    private JwsAuthenticationTypeRepository authenticationTypeRepository = null;
    @Autowired
    private JwsEntityRoleAssociationRepository entityRoleAssociationRepository = null;
    @Autowired
    private DBTemplatingService templatingService = null;
    @Autowired
    private TemplatingUtils templatingUtils = null;
    @Autowired
    private IUserDetailsService userDetailsService = null;
    @Autowired
    private PasswordEncoder passwordEncoder = null;
    @Autowired
    private ApplicationSecurityDetails applicationSecurityDetails = null;
    @Autowired
    private PropertyMasterService propertyMasterService = null;
    @Autowired
    private SendMailService sendMailService = null;

    public String addEditRole(String roleId) throws Exception {
        HashMap<String, JwsRole> templateMap = new HashMap<String, JwsRole>();
        JwsRole jwsRole = new JwsRole();
        if (StringUtils.isNotEmpty((CharSequence)roleId)) {
            jwsRole = (JwsRole)this.jwsRoleRepository.findById((Object)roleId).get();
        }
        templateMap.put("jwsRole", jwsRole);
        return this.menuService.getTemplateWithSiteLayout("addEditRole", templateMap);
    }

    public void saveRoleData(JwsRoleVO roleData) {
        JwsRole jwsRole = roleData.convertVOToEntity(roleData);
        this.jwsRoleRepository.save((Object)jwsRole);
        if (Boolean.FALSE.equals(StringUtils.isNotEmpty((CharSequence)roleData.getRoleId())) && jwsRole.getIsActive() == Constants.ISACTIVE) {
            List entityRolesAssociations = this.entityRoleAssociationRepository.findEntityByModuleTypeId(Constants.COMMON_MODULE_TYPE_ID);
            for (JwsEntityRoleAssociation currentJwsEntityRole : entityRolesAssociations) {
                JwsEntityRoleAssociation jwsEntityRoleAssociation = new JwsEntityRoleAssociation();
                jwsEntityRoleAssociation.setEntityName(currentJwsEntityRole.getEntityName());
                jwsEntityRoleAssociation.setEntityId(currentJwsEntityRole.getEntityId());
                jwsEntityRoleAssociation.setIsActive(Constants.ISACTIVE);
                jwsEntityRoleAssociation.setModuleId(currentJwsEntityRole.getModuleId());
                jwsEntityRoleAssociation.setLastUpdatedBy(this.userDetailsService.getUserDetails().getUserId());
                jwsEntityRoleAssociation.setLastUpdatedDate(new Date());
                jwsEntityRoleAssociation.setModuleTypeId(Constants.COMMON_MODULE_TYPE_ID);
                jwsEntityRoleAssociation.setRoleId(jwsRole.getRoleId());
                this.entityRoleAssociationRepository.save((Object)jwsEntityRoleAssociation);
            }
        }
    }

    public String manageRoleModules() throws Exception {
        HashMap mapDetails = new HashMap();
        List roles = new ArrayList();
        roles = this.jwsRoleRepository.findAllRoles();
        ArrayList<JwsMasterModulesVO> masterModulesVO = new ArrayList<JwsMasterModulesVO>();
        List masterModules = new ArrayList();
        masterModules = this.jwsmasterModuleRepository.findAll();
        for (JwsMasterModules jwsMasterModule : masterModules) {
            masterModulesVO.add(new JwsMasterModulesVO().convertEntityToVO(jwsMasterModule));
        }
        List roleModulesAssociations = new ArrayList();
        roleModulesAssociations = this.roleModuleRepository.findAll();
        mapDetails.put("roles", roles);
        mapDetails.put("masterModules", masterModulesVO);
        mapDetails.put("roleModulesAssociations", roleModulesAssociations);
        TemplateVO templateVO = this.templatingService.getTemplateByName("manageRoleModule");
        return this.templatingUtils.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), mapDetails);
    }

    public Boolean saveRoleModules(JwsRoleMasterModulesAssociationVO roleModule) {
        JwsRoleMasterModulesAssociation masterModuleAssociation = roleModule.convertVOToEntity(roleModule);
        this.roleModuleRepository.save((Object)masterModuleAssociation);
        JwsMasterModules jwsMasterModule = (JwsMasterModules)this.jwsmasterModuleRepository.findById((Object)masterModuleAssociation.getModuleId()).get();
        this.entityRoleAssociationRepository.updateEntityRelatedToModule(jwsMasterModule.getModuleTypeId(), masterModuleAssociation.getRoleId(), masterModuleAssociation.getIsActive());
        return true;
    }

    public void saveUserData(JwsUserVO userData) throws Exception {
        String password = null;
        JwsUser jwsUser = new JwsUser();
        if (userData.getIsProfilePage().booleanValue()) {
            jwsUser = this.jwsUserRepository.findByUserId(userData.getUserId());
            jwsUser.setFirstName(userData.getFirstName());
            jwsUser.setLastName(userData.getLastName());
            this.jwsUserRepository.save((Object)jwsUser);
        } else {
            if (StringUtils.isNotEmpty((CharSequence)userData.getUserId())) {
                jwsUser = this.jwsUserRepository.findByUserId(userData.getUserId());
                jwsUser.setFirstName(userData.getFirstName());
                jwsUser.setLastName(userData.getLastName());
                this.userManagementDAO.deleteUserRoleAssociation(jwsUser.getUserId());
            } else {
                jwsUser.setFirstName(userData.getFirstName());
                jwsUser.setLastName(userData.getLastName());
                jwsUser.setEmail(userData.getEmail());
                password = UUID.randomUUID().toString();
                jwsUser.setPassword(this.passwordEncoder.encode((CharSequence)password));
                System.out.println("Your account password is  " + password);
                Email email = new Email();
                email.setInternetAddressToArray(InternetAddress.parse((String)userData.getEmail()));
                email.setSubject("Account Password");
                email.setMailFrom("admin@jquiver.com");
                email.setBody("Your account password is  " + password + " You can login through these url : http://localhost:8080/cf/login");
                this.sendMailService.sendTestMail(email);
            }
            jwsUser.setIsActive(userData.getForcePasswordChange() == 1 ? Constants.INACTIVE : Constants.ISACTIVE);
            jwsUser.setForcePasswordChange(userData.getForcePasswordChange());
            this.jwsUserRepository.save((Object)jwsUser);
            if (userData.getForcePasswordChange() == 1) {
                password = UUID.randomUUID().toString();
                System.out.println("Password is :" + password);
                jwsUser.setPassword(this.passwordEncoder.encode((CharSequence)password));
                StringBuilder messageText = new StringBuilder("Your account password is  " + password);
                if (userData.getForcePasswordChange() == 1) {
                    messageText.append(" Please change your password through these url : http://localhost:8080/cf/changePassword?token=" + jwsUser.getUserId());
                } else {
                    messageText.append(" You can login through these url : http://localhost:8080/cf/login");
                }
                System.out.println(messageText.toString());
                Email email = new Email();
                email.setInternetAddressToArray(InternetAddress.parse((String)userData.getEmail()));
                email.setSubject("Account Password");
                email.setMailFrom("admin@jquiver.com");
                email.setBody(messageText.toString());
                this.sendMailService.sendTestMail(email);
            }
            for (String roleId : userData.getRoleIds()) {
                Date currentDate = new Date();
                JwsUserRoleAssociation userRoleAssociation = new JwsUserRoleAssociation();
                userRoleAssociation.setRoleId(roleId);
                userRoleAssociation.setUserId(jwsUser.getUserId());
                userRoleAssociation.setUpdatedDate(currentDate);
                this.userRoleRepository.save((Object)userRoleAssociation);
            }
        }
    }

    public String addEditUser(String userId, boolean isProfilePage) throws Exception {
        HashMap<String, Serializable> templateMap = new HashMap<String, Serializable>();
        JwsUser jwsUser = new JwsUser();
        List<String> userRoleIds = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            jwsUser = (JwsUser)this.jwsUserRepository.findById((Object)userId).get();
            userRoleIds = this.userManagementDAO.getRoleIdsByUserId(userId);
        }
        JwsRole authenticatedRole = this.jwsRoleRepository.findByRoleName("ANONYMOUS");
        userRoleIds.add(authenticatedRole.getRoleId());
        templateMap.put("userRoleIds", (Serializable)((Object)userRoleIds));
        List<Object> roles = new ArrayList();
        roles = this.jwsRoleRepository.findAllRoles().stream().filter(role -> !role.getRoleName().equalsIgnoreCase("ANONYMOUS")).collect(Collectors.toList());
        templateMap.put("roles", (Serializable)((Object)roles));
        templateMap.put("jwsUser", (Serializable)jwsUser);
        templateMap.put("isProfilePage", Boolean.valueOf(isProfilePage));
        return this.menuService.getTemplateWithSiteLayout("addEditJwsUser", templateMap);
    }

    public String loadUserManagement() throws Exception {
        HashMap<String, Object> mapDetails = new HashMap<String, Object>();
        PropertyMaster propertyMaster = this.propertyMasterRepository.findByOwnerTypeAndOwnerIdAndPropertyName("system", "system", "enable-user-management");
        mapDetails.put("authEnabled", Boolean.parseBoolean(propertyMaster.getPropertyValue()));
        PropertyMaster propertyMasterAuthType = this.propertyMasterRepository.findByOwnerTypeAndOwnerIdAndPropertyName("system", "system", "authentication-type");
        mapDetails.put("authTypeId", propertyMasterAuthType.getPropertyValue());
        List authenticationTypes = this.authenticationTypeRepository.findAll();
        ArrayList<JwsAuthenticationTypeVO> authenticationTypesVO = new ArrayList<JwsAuthenticationTypeVO>();
        for (JwsAuthenticationType authenticationType : authenticationTypes) {
            authenticationTypesVO.add(new JwsAuthenticationTypeVO().convertEntityToVO(authenticationType));
        }
        mapDetails.put("authenticationTypesVO", authenticationTypesVO);
        return this.menuService.getTemplateWithSiteLayout("user-management", mapDetails);
    }

    public void updatePropertyMasterValuesAndAuthProperties(String authenticationEnabled, String authenticationTypeId, String propertyJson, String regexObj) {
        this.propertyMasterRepository.updatePropertyValueByName(authenticationEnabled, "enable-user-management");
        this.propertyMasterRepository.updatePropertyValueByName(authenticationTypeId, "authentication-type");
        this.authenticationTypeRepository.updatePropertyById(Integer.valueOf(Integer.parseInt(authenticationTypeId)), propertyJson);
        if (StringUtils.isNotBlank((CharSequence)regexObj)) {
            this.propertyMasterRepository.updatePropertyValueByName(regexObj, "regexPattern");
        }
    }

    public String manageEntityRoles() throws Exception {
        HashMap mapDetails = new HashMap();
        List roles = new ArrayList();
        roles = this.jwsRoleRepository.findAllRoles();
        mapDetails.put("roles", roles);
        TemplateVO templateVO = this.templatingService.getTemplateByName("manageEntityRoles");
        return this.templatingUtils.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), mapDetails);
    }

    public void saveUpdateEntityRole(List<JwsEntityRoleAssociationVO> entityRoleAssociations) {
        for (JwsEntityRoleAssociationVO jwsEntityRoleAssociationVO : entityRoleAssociations) {
            JwsEntityRoleAssociation jwsEntityRoleAssociation = jwsEntityRoleAssociationVO.convertVOtoEntity(jwsEntityRoleAssociationVO);
            jwsEntityRoleAssociation.setLastUpdatedBy("admin");
            String entityRoleId = this.entityRoleAssociationRepository.getEntityRoleIdByEntityAndRoleId(jwsEntityRoleAssociation.getEntityId(), jwsEntityRoleAssociation.getRoleId());
            jwsEntityRoleAssociation.setEntityRoleId(entityRoleId);
            this.entityRoleAssociationRepository.save((Object)jwsEntityRoleAssociation);
        }
    }

    public List<JwsMasterModulesVO> getModules() {
        ArrayList<JwsMasterModulesVO> masterModulesVO = new ArrayList<JwsMasterModulesVO>();
        List masterModules = new ArrayList();
        masterModules = this.jwsmasterModuleRepository.findAll();
        for (JwsMasterModules jwsMasterModule : masterModules) {
            masterModulesVO.add(new JwsMasterModulesVO().convertEntityToVO(jwsMasterModule));
        }
        return masterModulesVO;
    }

    public void deleteAndSaveEntityRole(JwsEntityRoleVO entityRoles) {
        if (!entityRoles.getRoleIds().contains("ae6465b3-097f-11eb-9a16-f48e38ab9348")) {
            entityRoles.getRoleIds().add("ae6465b3-097f-11eb-9a16-f48e38ab9348");
            entityRoles.setRoleIds(entityRoles.getRoleIds());
        }
        ArrayList newRoleIds = new ArrayList(entityRoles.getRoleIds());
        List entityRoleAssociations = this.entityRoleAssociationRepository.getEntityRoles(entityRoles.getEntityId(), entityRoles.getModuleId());
        for (JwsEntityRoleAssociation jwsEntityRoleAssociation : entityRoleAssociations) {
            if (!entityRoles.getRoleIds().contains(jwsEntityRoleAssociation.getRoleId())) {
                newRoleIds.remove(jwsEntityRoleAssociation.getRoleId());
                jwsEntityRoleAssociation.setIsActive(Constants.INACTIVE);
                jwsEntityRoleAssociation.setLastUpdatedDate(new Date());
                jwsEntityRoleAssociation.setLastUpdatedBy(this.userDetailsService.getUserDetails().getUserId());
                this.entityRoleAssociationRepository.save((Object)jwsEntityRoleAssociation);
                continue;
            }
            newRoleIds.remove(jwsEntityRoleAssociation.getRoleId());
            jwsEntityRoleAssociation.setIsActive(Constants.ISACTIVE);
            jwsEntityRoleAssociation.setLastUpdatedDate(new Date());
            jwsEntityRoleAssociation.setLastUpdatedBy(this.userDetailsService.getUserDetails().getUserId());
            this.entityRoleAssociationRepository.save((Object)jwsEntityRoleAssociation);
        }
        for (String roleId : newRoleIds) {
            JwsEntityRoleAssociation entityRoleAssociation = new JwsEntityRoleAssociation();
            entityRoleAssociation.setRoleId(roleId);
            entityRoleAssociation.setEntityId(entityRoles.getEntityId());
            entityRoleAssociation.setEntityName(entityRoles.getEntityName());
            entityRoleAssociation.setModuleId(entityRoles.getModuleId());
            entityRoleAssociation.setIsActive(Constants.ISACTIVE);
            entityRoleAssociation.setModuleTypeId(Constants.DEFAULT_MODULE_TYPE_ID);
            entityRoleAssociation.setLastUpdatedDate(new Date());
            entityRoleAssociation.setLastUpdatedBy(this.userDetailsService.getUserDetails().getUserId());
            this.entityRoleAssociationRepository.save((Object)entityRoleAssociation);
        }
    }

    public List<JwsRoleVO> getEntityRoles(String entityId, String moduleId) {
        List roles = this.entityRoleAssociationRepository.getRoles(entityId, moduleId, Constants.ISACTIVE);
        return roles;
    }

    public Boolean validatePassword(String password) throws Exception {
        Boolean isValid = Boolean.FALSE;
        if (password == null || password != null && password.trim().isEmpty()) {
            return isValid;
        }
        Integer authType = Integer.parseInt(this.applicationSecurityDetails.getAuthenticationType());
        if (Constants.AuthType.DAO.getAuthType() == authType) {
            String propertyName;
            JwsAuthenticationType authenticationType = (JwsAuthenticationType)this.authenticationTypeRepository.findById((Object)authType).orElseThrow(() -> new Exception("No auth type found with id : " + authType));
            JSONObject jsonObject = null;
            JSONArray jsonArray = new JSONArray(authenticationType.getAuthenticationProperties());
            if ((jsonObject = this.getJsonObjectFromPropertyValue(jsonObject, jsonArray, propertyName = "enableRegex")) != null && jsonObject.getString("value").equalsIgnoreCase("true")) {
                String regex = this.propertyMasterService.findPropertyMasterValue("system", "system", "regexPattern");
                JSONObject jsonObjectRegex = new JSONObject(regex);
                Pattern pattern = Pattern.compile(jsonObjectRegex.getString("regexValue"));
                Matcher isMatches = pattern.matcher(password);
                return isMatches.matches();
            }
            isValid = Boolean.TRUE;
        }
        return isValid;
    }

    private JSONObject getJsonObjectFromPropertyValue(JSONObject jsonObject, JSONArray jsonArray, String propertyName) throws JSONException {
        for (int i = 0; i < jsonArray.length() && !(jsonObject = jsonArray.getJSONObject(i)).get("name").toString().equalsIgnoreCase(propertyName); ++i) {
            jsonObject = null;
        }
        return jsonObject;
    }

    public void getConfigurableDetails(Map<String, Object> mapDetails) throws Exception, JSONException {
        String captchaPropertyName;
        JSONObject jsonObjectCaptcha = null;
        JSONObject jsonObjectRegex = null;
        Integer authType = Integer.parseInt(this.applicationSecurityDetails.getAuthenticationType());
        JwsAuthenticationType authenticationType = (JwsAuthenticationType)this.authenticationTypeRepository.findById((Object)authType).orElseThrow(() -> new Exception("No auth type found with id : " + authType));
        JSONArray jsonArray = new JSONArray(authenticationType.getAuthenticationProperties());
        if ((jsonObjectCaptcha = this.getJsonObjectFromPropertyValue(jsonObjectCaptcha, jsonArray, captchaPropertyName = "enableCaptcha")) != null && jsonObjectCaptcha.getString("value").equalsIgnoreCase("true")) {
            mapDetails.put(captchaPropertyName, Boolean.TRUE);
        } else {
            mapDetails.put(captchaPropertyName, Boolean.FALSE);
        }
        String regexPropertyName = "enableRegex";
        jsonObjectRegex = this.getJsonObjectFromPropertyValue(jsonObjectCaptcha, jsonArray, regexPropertyName);
        if (jsonObjectRegex != null && jsonObjectRegex.getString("value").equalsIgnoreCase("true")) {
            mapDetails.put(regexPropertyName, Boolean.TRUE);
            String propertyMasterRegex = this.propertyMasterService.findPropertyMasterValue("system", "system", "regexPattern");
            JSONObject jsonPropertyMasterRegex = new JSONObject(propertyMasterRegex);
            mapDetails.put("regexExample", jsonPropertyMasterRegex.getString("regexExample"));
        } else {
            mapDetails.put(regexPropertyName, Boolean.FALSE);
        }
        String enableRegistrationPropertyName = "enableRegistration";
        if (this.applicationSecurityDetails.getAuthenticationType() != null) {
            JSONObject jsonObject = null;
            if ((jsonObject = this.getJsonObjectFromPropertyValue(jsonObject, jsonArray, enableRegistrationPropertyName)) != null && jsonObject.getString("value").equalsIgnoreCase("true")) {
                mapDetails.put(enableRegistrationPropertyName, Boolean.TRUE);
            } else {
                mapDetails.put(enableRegistrationPropertyName, Boolean.FALSE);
            }
        }
    }

    public JwsUser findByEmailIgnoreCase(String email) {
        return this.jwsUserRepository.findByEmailIgnoreCase(email);
    }

    public String getProfilePage() throws Exception {
        boolean isProfilePage = true;
        UserInformation userDetails = (UserInformation)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String userId = userDetails.getUserId();
        return this.addEditUser(userId, isProfilePage);
    }

    public String getInputFieldsByProperty(String propertyName) throws Exception {
        String propertyMasterRegex = this.propertyMasterService.findPropertyMasterValue("system", "system", propertyName);
        return propertyMasterRegex;
    }
}

