/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.dashboard.entities.Dashboard;
import com.trigyn.jws.dashboard.entities.DashboardRoleAssociation;
import com.trigyn.jws.dashboard.service.DashletService;
import com.trigyn.jws.dashboard.vo.DashboardVO;
import com.trigyn.jws.dashboard.vo.DashletVO;
import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.dbutils.spi.IUserDetailsService;
import com.trigyn.jws.dbutils.vo.UserRoleVO;
import com.trigyn.jws.menu.service.MenuService;
import com.trigyn.jws.webstarter.service.DashboardCrudService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
public class DashboardCrudController {
    private static final Logger logger = LogManager.getLogger(DashboardCrudController.class);
    @Autowired
    private DashboardCrudService dashboardCrudService = null;
    @Autowired
    private DashletService dashletServive = null;
    @Autowired
    private IUserDetailsService userDetails = null;
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;
    @Autowired
    private MenuService menuService = null;

    @GetMapping(value={"/dlm"}, produces={"text/html"})
    public String dashletMasterListing() throws Exception {
        HashMap<String, String> modelMap = new HashMap<String, String>();
        String environment = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "profile");
        modelMap.put("environment", environment);
        return this.menuService.getTemplateWithSiteLayout("dashlet-listing", modelMap);
    }

    @GetMapping(value={"/dbm"}, produces={"text/html"})
    public String dashboardMasterListing() throws Exception {
        return this.menuService.getTemplateWithSiteLayout("dashboard-listing", new HashMap());
    }

    @PostMapping(value={"/aedb"}, produces={"text/html"})
    public String addEditDashboardDetails(@RequestParam(value="dashboard-id") String dashboardId) throws Exception {
        HashMap<String, Object> templateMap = new HashMap<String, Object>();
        Dashboard dashboard = new Dashboard();
        List<UserRoleVO> userRoleVOs = this.dashboardCrudService.getAllUserRoles();
        if (dashboardId != null && !dashboardId.isEmpty() && !dashboardId.equals("")) {
            dashboard = this.dashboardCrudService.findDashboardByDashboardId(dashboardId);
            List<DashboardRoleAssociation> dashletRoleAssociation = this.dashboardCrudService.findDashboardRoleByDashboardId(dashboardId);
            if (!CollectionUtils.isEmpty(dashletRoleAssociation)) {
                dashboard.setDashboardRoles(dashletRoleAssociation);
            }
        } else {
            dashboard.setDashboardRoles(new ArrayList());
        }
        templateMap.put("userRoleVOs", userRoleVOs);
        Map<String, String> contextDetails = this.dashboardCrudService.findContextDetails();
        templateMap.put("contextDetails", contextDetails);
        templateMap.put("dashboard", dashboard);
        return this.menuService.getTemplateWithSiteLayout("dashboard-manage-details", templateMap);
    }

    @PostMapping(value={"/sdb"})
    @ResponseBody
    public String saveDashboard(@RequestBody DashboardVO dashboardVO, @RequestHeader(value="user-id", required=true) String userId) throws Exception {
        return this.dashboardCrudService.saveDashboardDetails(dashboardVO, userId);
    }

    @PostMapping(value={"/aedl"}, produces={"text/html"})
    public String createEditDashlet(@RequestParam(value="dashlet-id") String dashletId) throws Exception {
        HashMap<String, Object> templateMap = new HashMap<String, Object>();
        DashletVO dashletVO = this.dashletServive.getDashletDetailsById(dashletId);
        Map componentsMap = this.dashletServive.findComponentTypes("COMPONENT_TYPE");
        Map<String, String> contextDetailsMap = this.dashboardCrudService.findContextDetails();
        templateMap.put("dashletVO", dashletVO);
        templateMap.put("componentMap", componentsMap);
        templateMap.put("contextDetailsMap", contextDetailsMap);
        return this.menuService.getTemplateWithSiteLayout("dashlet-manage-details", templateMap);
    }

    @PostMapping(value={"/sdl"})
    @ResponseBody
    public String saveDashlet(@RequestHeader(value="user-id", required=true) String userId, @RequestBody DashletVO dashletVO) throws Exception {
        return this.dashboardCrudService.saveDashlet(userId, dashletVO);
    }

    @PostMapping(value={"/ddl"})
    public void downloadAllDashletsToLocalDirectory(HttpSession session, HttpServletRequest request) throws Exception {
        this.dashboardCrudService.downloadDashlets();
    }

    @PostMapping(value={"/udl"})
    public void uploadAllDashletsToDB(HttpSession session, HttpServletRequest request) throws Exception {
        this.dashboardCrudService.uploadDashlets();
    }
}

