/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.dynamicform.service.DynamicFormService;
import com.trigyn.jws.dynamicform.vo.DynamicFormSaveQueryVO;
import com.trigyn.jws.menu.service.MenuService;
import com.trigyn.jws.webstarter.service.DynamicFormCrudService;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
public class DynamicFormCrudController {
    @Autowired
    private DynamicFormCrudService dynamicFormCrudService = null;
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;
    @Autowired
    private DynamicFormService dynamicFormService = null;
    @Autowired
    private MenuService menuService = null;

    @PostMapping(value={"/aedf"}, produces={"text/html"})
    public String addEditForm(@RequestParam(value="form-id") String formId) throws Exception {
        return this.dynamicFormCrudService.addEditForm(formId);
    }

    @PostMapping(value={"/gfsq"}, produces={"application/json"})
    public List<DynamicFormSaveQueryVO> getAllFormQueriesById(HttpServletRequest httpServletRequest) throws Exception {
        String formId = httpServletRequest.getParameter("formId");
        return this.dynamicFormCrudService.getAllFormQueriesById(formId);
    }

    @PostMapping(value={"/sdfd"}, consumes={"application/x-www-form-urlencoded"})
    public void saveDynamicFormDetails(@RequestBody MultiValueMap<String, String> formData) throws Exception {
        this.dynamicFormCrudService.saveDynamicFormDetails(formData);
    }

    @GetMapping(value={"/dfl"}, produces={"text/html"})
    public String dynamicFormMasterListing() throws Exception {
        HashMap<String, String> modelMap = new HashMap<String, String>();
        String environment = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "profile");
        modelMap.put("environment", environment);
        return this.menuService.getTemplateWithSiteLayout("dynamic-form-listing", modelMap);
    }

    @PostMapping(value={"/dfte"}, produces={"text/html"})
    public String createDefaultFormByTableName(HttpServletRequest httpServletRequest) throws Exception {
        String tableName = httpServletRequest.getParameter("tableName");
        return this.dynamicFormService.createDefaultFormByTableName(tableName);
    }

    @GetMapping(value={"/cdd"})
    @ResponseBody
    public String checkDynamicFormData(HttpServletRequest request, HttpServletResponse response) {
        String formName = request.getParameter("formName");
        String formId = null;
        formId = this.dynamicFormCrudService.checkFormName(formName);
        return formId;
    }

    @PostMapping(value={"/ddf"})
    public void downloadAllFormsToLocalDirectory(HttpSession session, HttpServletRequest request) throws Exception {
        this.dynamicFormCrudService.downloadDynamicFormTemplates();
    }

    @PostMapping(value={"/udf"})
    public void uploadAllFormsToDB(HttpSession session, HttpServletRequest request) throws Exception {
        this.dynamicFormCrudService.uploadAllFormsToDB();
    }
}

