/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.menu.service.MenuService;
import com.trigyn.jws.resourcebundle.service.ResourceBundleService;
import com.trigyn.jws.resourcebundle.vo.ResourceBundleVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
public class ResourceBundleCrudController {
    private static final Logger logger = LogManager.getLogger(ResourceBundleCrudController.class);
    @Autowired
    private ResourceBundleService resourceBundleService = null;
    @Autowired
    private MenuService menuService = null;

    @GetMapping(value={"/rb"}, produces={"text/html"})
    public String dbResourceBundleListing() throws Exception {
        HashMap<String, List> templateMap = new HashMap<String, List>();
        List languageVOList = this.resourceBundleService.getLanguagesList();
        templateMap.put("languageVOList", languageVOList);
        return this.menuService.getTemplateWithSiteLayout("resource-bundle-listing", templateMap);
    }

    @PostMapping(value={"/aerb"})
    public String dbResourceJsp(@RequestParam(value="resource-key") String resourceBundleKey) throws Exception {
        HashMap<String, Object> templateMap = new HashMap<String, Object>();
        if (resourceBundleKey != null) {
            Map resourceBundleVOMap = this.resourceBundleService.getResourceBundleVOMap(resourceBundleKey);
            templateMap.put("resourceBundleVOMap", resourceBundleVOMap);
        }
        List languageVOList = this.resourceBundleService.getLanguagesList();
        templateMap.put("languageVOList", languageVOList);
        templateMap.put("resourceBundleKey", resourceBundleKey);
        return this.menuService.getTemplateWithSiteLayout("resource-bundle-manage-details", templateMap);
    }

    @GetMapping(value={"/crbk"}, produces={"application/json"})
    public ResponseEntity<Boolean> checkResourceData(@RequestParam(value="resourceKey") String resourceBundleKey) throws Exception {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        try {
            Boolean keyAlreadyExist = this.resourceBundleService.checkResourceKeyExist(resourceBundleKey);
            return new ResponseEntity((Object)keyAlreadyExist, (MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)true, (MultiValueMap)httpHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/srb"}, produces={"application/json"})
    public ResponseEntity<Boolean> saveResourceDetails(@RequestParam(value="resourceBundleKey") String resourceBundleKey, @RequestBody List<ResourceBundleVO> dbResourceList) throws Exception {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        try {
            this.resourceBundleService.saveResourceBundleDetails(resourceBundleKey, dbResourceList);
            return new ResponseEntity((Object)true, (MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)false, (MultiValueMap)httpHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

