/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.menu.service.MenuService;
import com.trigyn.jws.templating.service.DBTemplatingService;
import com.trigyn.jws.templating.vo.TemplateVO;
import com.trigyn.jws.webstarter.service.TemplateCrudService;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
public class TemplateCrudController {
    private static final Logger logger = LogManager.getLogger(TemplateCrudController.class);
    @Autowired
    private DBTemplatingService dbTemplatingService = null;
    @Autowired
    private TemplateCrudService templateCrudService = null;
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;
    @Autowired
    private MenuService menuService = null;

    @GetMapping(value={"/te"}, produces={"text/html"})
    public String templatePage() throws Exception {
        HashMap<String, String> modelMap = new HashMap<String, String>();
        String environment = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "profile");
        modelMap.put("environment", environment);
        return this.menuService.getTemplateWithSiteLayout("template-listing", modelMap);
    }

    @GetMapping(value={"/aet"}, produces={"text/html"})
    public String velocityTemplateEditor(HttpServletRequest request) throws Exception {
        String templateId = request.getParameter("vmMasterId");
        HashMap<String, TemplateVO> vmTemplateData = new HashMap<String, TemplateVO>();
        if (templateId != null) {
            TemplateVO templateDetails = this.dbTemplatingService.getVelocityDataById(templateId);
            templateDetails.setTemplate("");
            vmTemplateData.put("templateDetails", templateDetails);
        }
        return this.menuService.getTemplateWithSiteLayout("template-manage-details", vmTemplateData);
    }

    @RequestMapping(value={"/ctd"})
    @ResponseBody
    public String checkTemplateData(HttpServletRequest request, HttpServletResponse response) {
        String templateName = request.getParameter("templateName");
        String templateId = null;
        try {
            templateId = this.templateCrudService.checkVelocityData(templateName);
            return templateId;
        }
        catch (Exception e) {
            return null;
        }
    }

    @GetMapping(value={"/gtbi"})
    public String getTemplateByTemplateId(HttpServletRequest request) throws Exception {
        String templateId = request.getParameter("templateId");
        TemplateVO templateDetails = this.dbTemplatingService.getVelocityDataById(templateId);
        return templateDetails.getTemplate();
    }

    @PostMapping(value={"/std"})
    public void saveTemplateData(HttpSession session, HttpServletRequest request) throws Exception {
        this.dbTemplatingService.saveTemplateData(request);
    }

    @PostMapping(value={"/dtl"})
    public void downloadAllTemplatesToLocalDirectory(HttpSession session, HttpServletRequest request) throws Exception {
        this.templateCrudService.downloadTemplates();
    }

    @PostMapping(value={"/utd"})
    public void uploadAllTemplatesToDB(HttpSession session, HttpServletRequest request) throws Exception {
        this.templateCrudService.uploadTemplates();
    }
}

