/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.utils;

import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.dbutils.utils.FileUtilities;
import com.trigyn.jws.templating.dao.DBTemplatingRepository;
import com.trigyn.jws.templating.dao.TemplateDAO;
import com.trigyn.jws.templating.entities.TemplateMaster;
import com.trigyn.jws.templating.service.DBTemplatingService;
import com.trigyn.jws.templating.vo.TemplateVO;
import com.trigyn.jws.webstarter.utils.DownloadUploadModule;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="template")
public class TemplateModule
implements DownloadUploadModule {
    @Autowired
    private DBTemplatingService dbTemplatingService = null;
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;
    @Autowired
    private TemplateDAO templateDAO = null;
    @Autowired
    private DBTemplatingRepository dbTemplatingRepository = null;
    @Autowired
    private FileUtilities fileUtilities = null;

    @Override
    public void downloadCodeToLocal() throws Exception {
        List templates = this.dbTemplatingService.getAllTemplates();
        List templateVOs = templates.stream().map(template -> new TemplateVO(template.getTemplateId(), template.getTemplateName(), template.getTemplate(), template.getChecksum())).collect(Collectors.toList());
        String ftlCustomExtension = ".tgn";
        String templateDirectory = "Templates";
        Object folderLocation = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "template-storage-path");
        if (!new File((String)(folderLocation = (String)folderLocation + File.separator + templateDirectory)).exists()) {
            File fileDirectory = new File((String)folderLocation);
            fileDirectory.mkdirs();
        }
        for (TemplateVO templateVO : templateVOs) {
            String newFileCheckSum = null;
            File file = new File((String)folderLocation + File.separator + templateVO.getTemplateName() + ftlCustomExtension);
            if (file.exists()) {
                String existingCheckSum;
                String generatedFileCheckSum = this.fileUtilities.generateFileChecksum(file);
                if (!generatedFileCheckSum.equalsIgnoreCase(existingCheckSum = templateVO.getChecksum())) {
                    file.delete();
                    newFileCheckSum = this.fileUtilities.writeFileContents(templateVO.getTemplate(), file);
                    templateVO.setChecksum(newFileCheckSum);
                    continue;
                }
                templateVO.setChecksumChanged(false);
                continue;
            }
            newFileCheckSum = this.fileUtilities.writeFileContents(templateVO.getTemplate(), file);
            templateVO.setChecksum(newFileCheckSum);
        }
        for (TemplateVO templateVO : templateVOs) {
            if (!templateVO.isChecksumChanged()) continue;
            this.templateDAO.updateChecksum(templateVO);
        }
    }

    @Override
    public void uploadCodeToDB() throws Exception {
        File[] files;
        String user = "admin";
        final String ftlCustomExtension = ".tgn";
        String templateDirectory = "Templates";
        Object folderLocation = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "template-storage-path");
        File directory = new File((String)(folderLocation = (String)folderLocation + File.separator + templateDirectory));
        if (!directory.exists()) {
            throw new Exception("No such directory present");
        }
        FilenameFilter textFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(ftlCustomExtension);
            }
        };
        for (File file : files = directory.listFiles(textFilter)) {
            if (!file.isFile()) continue;
            String fileName = file.getName().replace(ftlCustomExtension, "");
            TemplateMaster template = this.templateDAO.getTemplateDetailsByName(fileName);
            String content = this.fileUtilities.readContentsOfFile(file.getAbsolutePath());
            String generateFileCheckSum = this.fileUtilities.generateFileChecksum(file);
            if (template == null) {
                template = new TemplateMaster();
                template.setTemplate(content);
                template.setChecksum(generateFileCheckSum);
                template.setTemplateName(fileName);
                template.setUpdatedDate(new Date());
                template.setUpdatedBy(user);
                template.setCreatedBy(user);
                this.dbTemplatingRepository.save((Object)template);
                continue;
            }
            if (generateFileCheckSum.equalsIgnoreCase(template.getChecksum())) continue;
            template.setTemplate(content);
            template.setChecksum(generateFileCheckSum);
            template.setUpdatedBy(user);
            template.setUpdatedDate(new Date());
            this.dbTemplatingRepository.save((Object)template);
        }
    }
}

