/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.dashboard.service.DashletService;
import com.trigyn.jws.dbutils.service.ModuleService;
import com.trigyn.jws.dbutils.spi.IUserDetailsService;
import com.trigyn.jws.dbutils.vo.UserDetailsVO;
import com.trigyn.jws.dynamicform.service.DynamicFormService;
import com.trigyn.jws.templating.service.MenuService;
import com.trigyn.jws.webstarter.utils.Constant;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/view/**"}, produces={"text/html"})
public class MasterModuleController {
    @Autowired
    private ModuleService moduleService = null;
    @Autowired
    private MenuService menuService = null;
    @Autowired
    private DashletService dashletService = null;
    @Autowired
    private IUserDetailsService userDetails = null;
    @Autowired
    private DynamicFormService dynamicFormService = null;

    @RequestMapping
    public String loadModuleContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            String moduleUrl = httpServletRequest.getRequestURI();
            moduleUrl = moduleUrl.replaceFirst("/view/", "");
            if ("".equals(moduleUrl)) {
                return this.menuService.getTemplateWithSiteLayout("home", new HashMap());
            }
            Map moduleDetailsMap = this.moduleService.getModuleTargetTypeName(moduleUrl);
            Map<String, Object> parameterMap = this.validateAndProcessRequestParams(httpServletRequest);
            Integer targetLookupId = Integer.parseInt(moduleDetailsMap.get("targetLookupId").toString());
            String templateName = moduleDetailsMap.get("targetTypeName").toString();
            String targetTypeId = moduleDetailsMap.get("targetTypeId").toString();
            if (targetLookupId.equals(Constant.TargetLookupId.TEMPLATE.getTargetLookupId())) {
                return this.menuService.getTemplateWithSiteLayout(templateName, parameterMap);
            }
            if (targetLookupId.equals(Constant.TargetLookupId.DASHBOARD.getTargetLookupId())) {
                UserDetailsVO detailsVO = this.userDetails.getUserDetails();
                String userId = detailsVO.getUserId();
                String template = this.dashletService.getDashletUI(userId, false, targetTypeId);
                return this.menuService.getDashletTemplateWithLayout(template, null);
            }
            if (targetLookupId.equals(Constant.TargetLookupId.DYANMICFORM.getTargetLookupId())) {
                String template = this.dynamicFormService.loadDynamicForm(targetTypeId, parameterMap, null);
                HashMap<String, String> templateMap = new HashMap<String, String>();
                templateMap.put("formId", targetTypeId);
                return this.menuService.getDashletTemplateWithLayout(template, templateMap);
            }
            return null;
        }
        catch (NullPointerException exception) {
            throw new RuntimeException(exception.getMessage());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    private Map<String, Object> validateAndProcessRequestParams(HttpServletRequest httpServletRequest) {
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        for (String requestParamKey : httpServletRequest.getParameterMap().keySet()) {
            requestParams.put(requestParamKey, httpServletRequest.getParameter(requestParamKey));
        }
        return requestParams;
    }
}

