/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.templating.service.MenuService;
import com.trigyn.jws.typeahead.model.AutocompleteVO;
import com.trigyn.jws.typeahead.service.TypeAheadService;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
public class TypeAheadCrudController {
    private static final Logger logger = LogManager.getLogger(TypeAheadCrudController.class);
    @Autowired
    private TypeAheadService typeAheadService = null;
    @Autowired
    private MenuService menuService = null;

    @GetMapping(value={"/adl"}, produces={"text/html"})
    public String autocompleteListingsPage() {
        try {
            return this.menuService.getTemplateWithSiteLayout("autocomplete-listing", new HashMap());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    @GetMapping(value={"/da"}, produces={"text/html"})
    public String demoAutocomplete() throws Exception {
        return this.menuService.getTemplateWithSiteLayout("autocomplete-demo", new HashMap());
    }

    @GetMapping(value={"/aea"}, produces={"text/html"})
    public String addEditAutocompleteDetails(HttpServletRequest request) {
        try {
            String autocompleteId = request.getParameter("acId");
            HashMap<String, AutocompleteVO> templateData = new HashMap<String, AutocompleteVO>();
            if (autocompleteId != null) {
                AutocompleteVO autocompleteVO = this.typeAheadService.getAutocompleteDetailsId(autocompleteId);
                templateData.put("autocompleteVO", autocompleteVO);
            }
            return this.menuService.getTemplateWithSiteLayout("autocomplete-manage-details", templateData);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    @PostMapping(value={"/sacd"}, consumes={"application/x-www-form-urlencoded"})
    @ResponseBody
    public String saveAutocompleteDetails(@RequestBody MultiValueMap<String, String> formDataMap) throws Exception {
        return this.typeAheadService.saveAutocompleteDetails(formDataMap);
    }
}

