/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.dao;

import com.trigyn.jws.dashboard.entities.Dashboard;
import com.trigyn.jws.dashboard.entities.DashboardDashletAssociation;
import com.trigyn.jws.dashboard.entities.DashboardRoleAssociation;
import com.trigyn.jws.dbutils.repository.DBConnection;
import com.trigyn.jws.webstarter.controller.DashboardCrudController;
import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DashboardCrudDAO
extends DBConnection {
    private static final Logger logger = LogManager.getLogger(DashboardCrudController.class);

    @Autowired
    public DashboardCrudDAO(DataSource dataSource) {
        super(dataSource);
    }

    public Dashboard findDashboardByDashboardId(String dashboardId) throws Exception {
        return (Dashboard)this.hibernateTemplate.get(Dashboard.class, (Serializable)((Object)dashboardId));
    }

    public List<DashboardRoleAssociation> findDashboardRoleByDashboardId(String dashboardId) throws Exception {
        Query query = this.getCurrentSession().createQuery(" FROM DashboardRoleAssociation AS dra where dra.id.dashboardId = :dashboardId ");
        query.setParameter("dashboardId", (Object)dashboardId);
        return query.list();
    }

    public void deleteAllDashletFromDashboard(String dashboardId) throws Exception {
        Query query = this.getCurrentSession().createQuery("DELETE FROM DashboardDashletAssociation AS dda WHERE dda.id.dashboardId = :dashboardId".toString());
        query.setParameter("dashboardId", (Object)dashboardId);
        query.executeUpdate();
    }

    public void deleteAllDashboardRoles(String dashboardId) throws Exception {
        Query query = this.getCurrentSession().createQuery("DELETE FROM DashboardRoleAssociation AS dra WHERE dra.id.dashboardId = :dashboardId".toString());
        query.setParameter("dashboardId", (Object)dashboardId);
        query.executeUpdate();
    }

    public void saveDashboardDashletAssociation(DashboardDashletAssociation dashboardDashletAssociation) throws Exception {
        this.getCurrentSession().saveOrUpdate((Object)dashboardDashletAssociation);
    }

    public void deleteAllDashletProperty(String dashletId) throws Exception {
        Query query = this.getCurrentSession().createQuery("DELETE FROM DashletProperties AS dp WHERE dp.dashletId = :dashletId".toString());
        query.setParameter("dashletId", (Object)dashletId);
        query.executeUpdate();
    }

    public void deleteAllDashletRoles(String dashletId) throws Exception {
        Query query = this.getCurrentSession().createQuery("DELETE FROM DashletRoleAssociation AS dra WHERE dra.id.dashletId = :dashletId".toString());
        query.setParameter("dashletId", (Object)dashletId);
        query.executeUpdate();
    }
}

