/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.dbutils.service.DownloadUploadModule;
import com.trigyn.jws.dbutils.service.TemplateVersionService;
import com.trigyn.jws.dbutils.utils.FileUtilities;
import com.trigyn.jws.dynarest.dao.JwsDynamicRestDAORepository;
import com.trigyn.jws.dynarest.dao.JwsDynamicRestDetailsRepository;
import com.trigyn.jws.dynarest.dao.JwsDynarestDAO;
import com.trigyn.jws.dynarest.entities.JwsDynamicRestDaoDetail;
import com.trigyn.jws.dynarest.service.JwsDynamicRestDetailService;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

@Service
@Transactional
public class DynarestCrudService {
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;
    @Autowired
    private FileUtilities fileUtilities = null;
    @Autowired
    @Qualifier(value="dynamic-rest")
    private DownloadUploadModule downloadUploadModule = null;
    @Autowired
    private JwsDynamicRestDetailsRepository dynamicRestDetailsRepository = null;
    @Autowired
    private JwsDynamicRestDAORepository dynamicRestDAORepository = null;
    @Autowired
    private JwsDynarestDAO dynarestDAO = null;
    @Autowired
    private JwsDynamicRestDetailService dynamicRestDetailService = null;
    @Autowired
    private TemplateVersionService templateVersionService = null;

    public void downloadDynamicRestCode() throws Exception {
        this.downloadUploadModule.downloadCodeToLocal();
    }

    public void uploadDynamicRestCode() throws Exception {
        this.downloadUploadModule.uploadCodeToDB();
    }

    public String getContentForDevEnvironment(String formName, String fileName) throws Exception {
        String ftlCustomExtension = ".tgn";
        String templateDirectory = "DynamicRest";
        Object folderLocation = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "template-storage-path");
        File directory = new File((String)(folderLocation = (String)folderLocation + File.separator + templateDirectory + File.separator + formName));
        if (!directory.exists()) {
            throw new Exception("No such directory present");
        }
        File selectFile = new File((String)folderLocation + File.separator + fileName + ftlCustomExtension);
        if (selectFile.exists()) {
            return this.fileUtilities.readContentsOfFile(selectFile.getAbsolutePath());
        }
        throw new Exception("Please download the forms from dynamic form  listing  " + formName);
    }

    @Transactional(readOnly=false)
    public Boolean saveDAOQueries(MultiValueMap<String, String> formData) throws Exception {
        String dynarestUrl = (String)formData.getFirst((Object)"dynarestUrl");
        String dynarestMethodName = (String)formData.getFirst((Object)"dynarestMethodName");
        String daoDetailsIds = (String)formData.getFirst((Object)"daoDetailsIds");
        String variableName = (String)formData.getFirst((Object)"variableName");
        String daoQueryDetails = (String)formData.getFirst((Object)"daoQueryDetails");
        Integer dynamicRestId = this.dynamicRestDetailsRepository.findByJwsDynamicRestId(dynarestUrl, dynarestMethodName);
        List daoDetailsIdList = (List)new ObjectMapper().readValue(daoDetailsIds, List.class);
        List variableNameList = (List)new ObjectMapper().readValue(variableName, List.class);
        List daoQueryDetailsList = (List)new ObjectMapper().readValue(daoQueryDetails, List.class);
        ArrayList<JwsDynamicRestDaoDetail> dynamicRestDaoDetailsList = new ArrayList<JwsDynamicRestDaoDetail>();
        if (!CollectionUtils.isEmpty((Collection)daoQueryDetailsList)) {
            for (int counter = 0; counter < variableNameList.size(); ++counter) {
                JwsDynamicRestDaoDetail dynamicRestDaoDetail = new JwsDynamicRestDaoDetail();
                if (!CollectionUtils.isEmpty((Collection)daoDetailsIdList) && daoDetailsIdList.size() > counter) {
                    dynamicRestDaoDetail.setJwsDaoDetailsId((Integer)daoDetailsIdList.get(counter));
                }
                dynamicRestDaoDetail.setJwsDynamicRestDetailId(dynamicRestId);
                dynamicRestDaoDetail.setJwsResultVariableName((String)variableNameList.get(counter));
                dynamicRestDaoDetail.setJwsDaoQueryTemplate((String)daoQueryDetailsList.get(counter));
                dynamicRestDaoDetail.setJwsQuerySequence(Integer.valueOf(counter + 1));
                dynamicRestDaoDetailsList.add(dynamicRestDaoDetail);
            }
            List dynamicRestDaoList = this.dynamicRestDAORepository.saveAll(dynamicRestDaoDetailsList);
            for (JwsDynamicRestDaoDetail dynamicRestDao : dynamicRestDaoList) {
                this.templateVersionService.saveTemplateVersion((Object)dynamicRestDao.getJwsDaoQueryTemplate(), (Object)dynamicRestId, (Object)dynamicRestDao.getJwsDaoDetailsId(), "jws_dynamic_rest_dao_details");
            }
        }
        this.updateLocalClassFiles();
        return true;
    }

    private void updateLocalClassFiles() throws Exception {
        String path = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "dynarest-class-file-path");
        File file = Paths.get(path, new String[0]).toFile();
        if (file.exists()) {
            file.delete();
        }
        File sourceFile = File.createTempFile("ServiceLogic", ".java");
        String className = sourceFile.getName().replaceAll(".java", "");
        this.dynamicRestDetailService.precompileClassAndGetFileLocation(className, sourceFile);
    }

    @Transactional(readOnly=false)
    public void deleteDAOQueries(MultiValueMap<String, String> formData) throws Exception {
        String dynarestUrl = (String)formData.getFirst((Object)"dynarestUrl");
        String dynarestMethodName = (String)formData.getFirst((Object)"dynarestMethodName");
        String daoDetailsIds = (String)formData.getFirst((Object)"daoDetailsIds");
        List daoDetailsIdList = (List)new ObjectMapper().readValue(daoDetailsIds, List.class);
        Integer dynamicRestId = this.dynamicRestDetailsRepository.findByJwsDynamicRestId(dynarestUrl, dynarestMethodName);
        this.dynarestDAO.deleteDAOQueriesById(dynamicRestId, daoDetailsIdList);
    }
}

