/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.dashboard.service.DashletService;
import com.trigyn.jws.dbutils.service.ModuleService;
import com.trigyn.jws.dbutils.spi.IUserDetailsService;
import com.trigyn.jws.dbutils.vo.UserDetailsVO;
import com.trigyn.jws.dynamicform.service.DynamicFormService;
import com.trigyn.jws.templating.service.MenuService;
import com.trigyn.jws.webstarter.controller.MasterCreatorController;
import com.trigyn.jws.webstarter.utils.Constant;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/view/**"}, produces={"text/html"})
public class MasterModuleController {
    private static final Logger logger = LogManager.getLogger(MasterCreatorController.class);
    @Autowired
    private ModuleService moduleService = null;
    @Autowired
    private MenuService menuService = null;
    @Autowired
    private DashletService dashletService = null;
    @Autowired
    private IUserDetailsService userDetails = null;
    @Autowired
    private DynamicFormService dynamicFormService = null;

    @RequestMapping
    public String loadModuleContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            String moduleUrl = httpServletRequest.getRequestURI();
            moduleUrl = moduleUrl.replaceFirst("/view/", "");
            return this.loadTemplate(httpServletRequest, moduleUrl);
        }
        catch (NullPointerException exception) {
            logger.error("Error ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
        }
        catch (Exception exception) {
            logger.error("Error ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
        }
        return null;
    }

    public String loadTemplate(HttpServletRequest httpServletRequest, String moduleUrl) throws Exception {
        if ("".equals(moduleUrl)) {
            return this.menuService.getTemplateWithSiteLayout("home", new HashMap());
        }
        Map moduleDetailsMap = this.moduleService.getModuleTargetTypeName(moduleUrl);
        if (!CollectionUtils.isEmpty((Map)moduleDetailsMap)) {
            Map<String, Object> parameterMap = this.validateAndProcessRequestParams(httpServletRequest);
            Integer targetLookupId = Integer.parseInt(moduleDetailsMap.get("targetLookupId").toString());
            String templateName = moduleDetailsMap.get("targetTypeName").toString();
            String targetTypeId = moduleDetailsMap.get("targetTypeId").toString();
            if (targetLookupId.equals(Constant.TargetLookupId.TEMPLATE.getTargetLookupId())) {
                return this.menuService.getTemplateWithSiteLayout(templateName, parameterMap);
            }
            if (targetLookupId.equals(Constant.TargetLookupId.DASHBOARD.getTargetLookupId())) {
                UserDetailsVO detailsVO = this.userDetails.getUserDetails();
                String userId = detailsVO.getUserId();
                String template = this.dashletService.getDashletUI(userId, false, targetTypeId);
                return this.menuService.getDashletTemplateWithLayout(template, null);
            }
            if (targetLookupId.equals(Constant.TargetLookupId.DYANMICFORM.getTargetLookupId())) {
                String template = this.dynamicFormService.loadDynamicForm(targetTypeId, parameterMap, null);
                HashMap<String, String> templateMap = new HashMap<String, String>();
                templateMap.put("formId", targetTypeId);
                return this.menuService.getDashletTemplateWithLayout(template, templateMap);
            }
        } else {
            return null;
        }
        return null;
    }

    private Map<String, Object> validateAndProcessRequestParams(HttpServletRequest httpServletRequest) {
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        for (String requestParamKey : httpServletRequest.getParameterMap().keySet()) {
            requestParams.put(requestParamKey, httpServletRequest.getParameter(requestParamKey));
        }
        return requestParams;
    }
}

