/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.dbutils.service.ModuleService;
import com.trigyn.jws.dbutils.vo.ModuleDetailsVO;
import com.trigyn.jws.templating.service.MenuService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@RestController
@RequestMapping(value={"/cf"})
public class MenuCrudController {
    private static final Logger logger = LogManager.getLogger(MenuCrudController.class);
    @Autowired
    private ModuleService moduleService = null;
    @Autowired
    private MenuService menuService = null;
    @Autowired
    private RequestMappingHandlerMapping handlerMapping = null;

    @GetMapping(value={"/mul"}, produces={"text/html"})
    public String moduleListingPage() throws Exception {
        return this.menuService.getTemplateWithSiteLayout("menu-module-listing", new HashMap());
    }

    @PostMapping(value={"/aem"}, produces={"text/html"})
    public String addEditModule(@RequestParam(value="module-id") String moduleId, HttpServletRequest a_httHttpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            HashMap<String, Object> templateMap = new HashMap<String, Object>();
            ModuleDetailsVO moduleDetailsVO = this.moduleService.getModuleDetails(moduleId);
            List moduleListingVOList = this.moduleService.getAllParentModules(moduleId);
            List moduleTargetLookupVOList = this.moduleService.getAllModuleLookUp();
            List userRoleVOs = this.moduleService.getAllUserRoles();
            Integer defaultSequence = this.moduleService.getModuleMaxSequence();
            String uri = a_httHttpServletRequest.getRequestURI();
            String url = a_httHttpServletRequest.getRequestURL().toString();
            StringBuilder urlPrefix = new StringBuilder();
            url = url.replace(uri, "");
            urlPrefix.append(url).append("/view/");
            templateMap.put("urlPrefix", urlPrefix);
            templateMap.put("userRoleVOs", userRoleVOs);
            templateMap.put("defaultSequence", defaultSequence);
            templateMap.put("moduleDetailsVO", moduleDetailsVO);
            templateMap.put("moduleListingVOList", moduleListingVOList);
            templateMap.put("moduleTargetLookupVOList", moduleTargetLookupVOList);
            return this.menuService.getTemplateWithSiteLayout("module-manage-details", templateMap);
        }
        catch (Exception exception) {
            logger.error("Error ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
            return null;
        }
    }

    @GetMapping(value={"/ltlm"}, produces={"application/json"})
    public List<Map<String, Object>> getTargetTypes(@RequestHeader(value="target-lookup-id", required=true) Integer targetLookupId) throws Exception {
        return this.moduleService.getTargetTypes(targetLookupId, null);
    }

    @GetMapping(value={"/cms"})
    @ResponseBody
    public String checkSequenceNumber(@RequestHeader(name="parent-module-id", required=false) String parentModuleId, @RequestHeader(name="sequence", required=true) Integer sequence) throws Exception {
        try {
            return this.moduleService.getModuleIdBySequence(parentModuleId, sequence);
        }
        catch (Exception e) {
            return "Error occurred";
        }
    }

    @GetMapping(value={"/cmurl"})
    @ResponseBody
    public String checkModuleURL(@RequestHeader(name="module-url", required=false) String moduleURL) throws Exception {
        return this.moduleService.getModuleIdByURL(moduleURL);
    }

    @GetMapping(value={"/ced"}, produces={"application/json"})
    public Map<String, Object> getExistingData(@RequestHeader(name="module-name", required=false) String moduleName, @RequestHeader(name="parent-module-id", required=false) String parentModuleId, @RequestHeader(name="sequence", required=true) Integer sequence, @RequestHeader(name="module-url", required=false) String moduleURL) throws Exception {
        return this.moduleService.getExistingModuleData(moduleName, parentModuleId, sequence, moduleURL);
    }

    @PostMapping(value={"/sm"})
    @ResponseBody
    public String saveModule(@RequestBody ModuleDetailsVO moduleDetailsVO) throws Exception {
        return this.moduleService.saveModuleDetails(moduleDetailsVO);
    }

    @GetMapping(value={"/dsp"})
    @ResponseBody
    public Integer getMaxSequenceByParent(@RequestHeader(name="parent-module-id", required=false) String parentModuleId) throws Exception {
        return this.moduleService.getMaxSequenceByParent(parentModuleId);
    }

    @GetMapping(value={"/dsg"})
    @ResponseBody
    public Integer getMaxSequenceByGroup() throws Exception {
        return this.moduleService.getModuleMaxSequence();
    }

    @PostMapping(value={"/chp"}, produces={"text/html"})
    public String configHomePage(HttpServletRequest a_httHttpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            HashMap<String, Object> templateMap = new HashMap<String, Object>();
            String homeModuleId = this.moduleService.getHomePageModuleId();
            ModuleDetailsVO moduleDetailsVO = this.moduleService.getModuleDetails(homeModuleId);
            List targetLookupVOList = this.moduleService.getAllModuleLookUp();
            templateMap.put("moduleDetailsVO", moduleDetailsVO);
            templateMap.put("targetLookupVOList", targetLookupVOList);
            return this.menuService.getTemplateWithSiteLayout("config-home-page", templateMap);
        }
        catch (Exception exception) {
            logger.error("Error ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
            return null;
        }
    }

    @PostMapping(value={"/schm"})
    @ResponseBody
    public String saveConfigHomeModule(HttpServletRequest a_httHttpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String moduleId = a_httHttpServletRequest.getParameter("moduleId");
        Integer targetLookupTypeId = a_httHttpServletRequest.getParameter("targetLookupTypeId") != null ? Integer.valueOf(Integer.parseInt(a_httHttpServletRequest.getParameter("targetLookupTypeId"))) : null;
        String targetTypeId = a_httHttpServletRequest.getParameter("targetTypeId");
        return this.moduleService.saveConfigHomePage(moduleId, targetLookupTypeId, targetTypeId);
    }
}

